/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.model;

import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoLineBreakpoint;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class AcceleoLineBreakpointAdapter
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getEditor(part);
        if (textEditor instanceof AcceleoEditor) {
            AcceleoEditor acceleoEditor = (AcceleoEditor)textEditor;
            IResource resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine();
            int offset = textSelection.getOffset();
            int length = textSelection.getLength();
            if (offset == -1) {
                return;
            }
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.acceleo.ide.ui.debug.model.AcceleoModelPresentation");
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (resource.equals((Object)breakpoint.getMarker().getResource())) {
                    int bLineNumber = ((ILineBreakpoint)breakpoint).getLineNumber();
                    int bCharStart = ((ILineBreakpoint)breakpoint).getCharStart();
                    int bCharEnd = ((ILineBreakpoint)breakpoint).getCharEnd();
                    if (bLineNumber == lineNumber + 1 || bCharStart == offset || offset <= bCharStart && offset + length >= bCharEnd) {
                        breakpoint.delete();
                        return;
                    }
                }
                ++i;
            }
            ASTNode astNode = AcceleoLineBreakpointAdapter.getBreakpointASTNodeAt(acceleoEditor.getContent(), offset);
            if (astNode != null) {
                AcceleoLineBreakpoint lineBreakpoint = new AcceleoLineBreakpoint((EObject)astNode, resource, lineNumber + 1, offset, length);
                DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)lineBreakpoint);
            }
        }
    }

    protected static ASTNode getBreakpointASTNodeAt(AcceleoSourceContent content, int offset) {
        int i = offset;
        while (i > 0 && content.getText().charAt(i - 1) != '\n') {
            --i;
        }
        while (i < content.getText().length()) {
            char c = content.getText().charAt(i);
            if (c == '\n') {
                i = -1;
                break;
            }
            if (c == '[') {
                i += 2;
                break;
            }
            ++i;
        }
        ASTNode astNode = content.getASTNode(i, i);
        if (astNode != null) {
            while (astNode.eContainer() instanceof ASTNode && ((ASTNode)astNode.eContainer()).getStartPosition() == astNode.getStartPosition()) {
                astNode = (ASTNode)astNode.eContainer();
            }
        }
        return astNode;
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.getEditor(part) != null;
    }

    private ITextEditor getEditor(IWorkbenchPart part) {
        String extension;
        ITextEditor editorPart;
        IResource resource;
        if (part instanceof ITextEditor && (resource = (IResource)(editorPart = (ITextEditor)part).getEditorInput().getAdapter(IResource.class)) != null && "mtl".equals(extension = resource.getFileExtension())) {
            return editorPart;
        }
        return null;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

