/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.compiler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class JETCompilerOptions {
    public static final String DEFAULT_COMPILED_TEMPLATE_PACKAGE = "org.eclipse.jet.compiled";
    public static final String DEFAULT_COMPILED_TEMPLATE_SRC_DIR = "jet2java";
    public static final String DEFAULT_TEMPLATE_EXT = "jet,jet2";
    public static final Boolean DEFAULT_SET_JAVA_FILES_AS_DERIVED = Boolean.TRUE;
    private static final String NS = "org.eclipse.jet.";
    public static final String OPTION_COMPILED_TEMPLATE_PACKAGE = "org.eclipse.jet.compiledTemplatePackage";
    public static final String OPTION_COMPILED_TEMPLATE_SRC_DIR = "org.eclipse.jet.compiledTemplateSrcDir";
    public static final String OPTION_TEMPLATE_EXT = "org.eclipse.jet.templateExt";
    public static final String OPTION_SET_JAVA_FILES_AS_DERIVED = "org.eclipse.jet.setJavaDerived";
    public static final String OPTION_JET_SPECIFICATION_VERSION = "org.eclipse.jet.jetSpecificationVersion";
    public static final Integer DEFAULT_JET_SPECIFICATION_VERSION = new Integer(2);
    public static final String OPTION_V1_BASE_TRANSFORMATION = "org.eclipse.jet.v1BaseTransformationID";
    public static final String DEFAULT_V1_BASE_TRANSFORMATION = "";
    public static final String OPTION_V1_COMPILE_BASE_TEMPLATES = "org.eclipse.jet.v1CompileBaseTemplates";
    public static final Boolean DEFAULT_V1_COMPILE_BASE_TEMPLATES = Boolean.FALSE;
    public static final String OPTION_V1_TEMPLATES_DIR = "org.eclipse.jet.v1TemplatesDir";
    public static final String DEFAULT_V1_TEMPLATES_DIR = "templates";
    public static final String OPTION_JAVA_OUTPUT_FOLDER = "org.eclipse.jet.javaOutputFolder";
    public static final String DEFAULT_JAVA_OUTPUT_FOLDER = "bin";
    public static final String OPTION_USE_JAVA5 = "org.eclipse.jet.useJava5";
    public static final String DEFAULT_USE_JAVA5 = Boolean.FALSE.toString();
    static Map defaultCompileOptions = null;
    static final Object defaultCompileOptionsLock = new Object();

    private JETCompilerOptions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getDefaultCompilerOptions() {
        if (defaultCompileOptions == null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(OPTION_COMPILED_TEMPLATE_PACKAGE, DEFAULT_COMPILED_TEMPLATE_PACKAGE);
            map.put(OPTION_COMPILED_TEMPLATE_SRC_DIR, DEFAULT_COMPILED_TEMPLATE_SRC_DIR);
            map.put(OPTION_TEMPLATE_EXT, DEFAULT_TEMPLATE_EXT);
            map.put(OPTION_SET_JAVA_FILES_AS_DERIVED, DEFAULT_SET_JAVA_FILES_AS_DERIVED);
            map.put(OPTION_JET_SPECIFICATION_VERSION, DEFAULT_JET_SPECIFICATION_VERSION);
            map.put(OPTION_V1_COMPILE_BASE_TEMPLATES, DEFAULT_V1_COMPILE_BASE_TEMPLATES);
            map.put(OPTION_V1_BASE_TRANSFORMATION, DEFAULT_V1_BASE_TRANSFORMATION);
            map.put(OPTION_V1_TEMPLATES_DIR, DEFAULT_V1_TEMPLATES_DIR);
            map.put(OPTION_JAVA_OUTPUT_FOLDER, DEFAULT_JAVA_OUTPUT_FOLDER);
            map.put(OPTION_USE_JAVA5, DEFAULT_USE_JAVA5);
            Object object = defaultCompileOptionsLock;
            synchronized (object) {
                defaultCompileOptions = Collections.unmodifiableMap(map);
            }
        }
        return defaultCompileOptions;
    }

    public static String getStringOption(Map options, String key) {
        if (options == null || key == null) {
            throw new NullPointerException();
        }
        if (!JETCompilerOptions.getDefaultCompilerOptions().containsKey(key)) {
            throw new IllegalArgumentException(key);
        }
        Object value = options.get(key);
        if (value == null) {
            value = JETCompilerOptions.getDefaultCompilerOptions().get(key);
        }
        return value == null ? null : value.toString();
    }

    public static boolean getBooleanOption(Map options, String key) {
        if (options == null || key == null) {
            throw new NullPointerException();
        }
        if (!JETCompilerOptions.getDefaultCompilerOptions().containsKey(key)) {
            throw new IllegalArgumentException(key);
        }
        Object value = options.get(key);
        if (value == null) {
            value = JETCompilerOptions.getDefaultCompilerOptions().get(key);
        }
        return value == null ? false : (value instanceof Boolean ? ((Boolean)value).booleanValue() : Boolean.valueOf(value.toString()).booleanValue());
    }

    public static int getIntOption(Map options, String key) {
        if (options == null || key == null) {
            throw new NullPointerException();
        }
        if (!JETCompilerOptions.getDefaultCompilerOptions().containsKey(key)) {
            throw new IllegalArgumentException(key);
        }
        Object value = options.get(key);
        if (value == null) {
            value = JETCompilerOptions.getDefaultCompilerOptions().get(key);
        }
        return value == null ? -1 : (value instanceof Integer ? ((Integer)value).intValue() : Integer.valueOf(value.toString()).intValue());
    }
}

