/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.parser;

import java.io.CharArrayReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jet.core.parser.IJETParser;
import org.eclipse.jet.core.parser.ITagLibraryResolver;
import org.eclipse.jet.core.parser.ITemplateInput;
import org.eclipse.jet.core.parser.ITemplateResolver;
import org.eclipse.jet.core.parser.ProblemSeverity;
import org.eclipse.jet.core.parser.TemplateInputException;
import org.eclipse.jet.core.parser.ast.Comment;
import org.eclipse.jet.core.parser.ast.EmbeddedExpression;
import org.eclipse.jet.core.parser.ast.JETAST;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.JETDirective;
import org.eclipse.jet.core.parser.ast.JavaDeclaration;
import org.eclipse.jet.core.parser.ast.JavaExpression;
import org.eclipse.jet.core.parser.ast.JavaScriptlet;
import org.eclipse.jet.core.parser.ast.TagLibraryUsageManager;
import org.eclipse.jet.core.parser.ast.TextElement;
import org.eclipse.jet.core.parser.ast.XMLBodyElement;
import org.eclipse.jet.core.parser.ast.XMLEmptyElement;
import org.eclipse.jet.internal.core.parser.ElementStack;
import org.eclipse.jet.internal.core.parser.TagValidationVisitor;
import org.eclipse.jet.internal.core.parser.TextTrimmingVisitor;
import org.eclipse.jet.internal.core.parser.jasper.CommentElementDelegate;
import org.eclipse.jet.internal.core.parser.jasper.DeclarationElementDelegate;
import org.eclipse.jet.internal.core.parser.jasper.EmbeddedExpressionElement;
import org.eclipse.jet.internal.core.parser.jasper.ErrorRedirectingCoreElementDelegate;
import org.eclipse.jet.internal.core.parser.jasper.JETCoreElement;
import org.eclipse.jet.internal.core.parser.jasper.JETException;
import org.eclipse.jet.internal.core.parser.jasper.JETMark;
import org.eclipse.jet.internal.core.parser.jasper.JETParseEventListener2;
import org.eclipse.jet.internal.core.parser.jasper.JETParser;
import org.eclipse.jet.internal.core.parser.jasper.JETReader;
import org.eclipse.jet.internal.core.parser.jasper.XMLElementDelegate;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.TagDefinition;
import org.eclipse.jet.taglib.TagLibraryReference;

public class InternalJET2Parser
implements JETParseEventListener2,
IJETParser {
    private static final String ID__ATTR = "id";
    private static final String PREFIX__ATTR = "prefix";
    private static final String TAGLIB__DIRECTIVE = "taglib";
    private static final String JET__DIRECTIVE = "jet";
    private final ElementStack elementStack = new ElementStack();
    private JETCompilationUnit compilationUnit;
    private JETAST ast;
    private final TagLibraryUsageManager tagLibManager;
    private JETReader reader;
    private final ITemplateResolver templateResolver;
    private final boolean supportEmbeddedExpressions;
    private static Set knownJETAttributes = new LinkedHashSet<String>(Arrays.asList("skeleton", "package", "imports", "class", "nlString", "startTag", "endTag", "version", "extends"));
    private static Set deprecatedJETAttributes = new LinkedHashSet<String>(Arrays.asList("skeleton", "nlString"));
    private JETParser parser;

    public InternalJET2Parser(ITemplateResolver templateResolver, ITagLibraryResolver tagLibraryResolver, Map predefinedLibraryMap, boolean supportEmbeddedExpressions) {
        this.templateResolver = templateResolver;
        this.supportEmbeddedExpressions = supportEmbeddedExpressions;
        this.tagLibManager = new TagLibraryUsageManager(predefinedLibraryMap, tagLibraryResolver);
    }

    public void beginPageProcessing() {
    }

    public void handleDirective(String directive, JETMark start, JETMark stop, Map attributes) {
        JETDirective directiveImpl = this.ast.newJETDirective(start.getLine(), start.getCol(), start.getCursor(), stop.getCursor() + 1, directive, attributes);
        this.compilationUnit.addBodyElement(directiveImpl);
        if (TAGLIB__DIRECTIVE.equalsIgnoreCase(directive)) {
            this.handleTagLibDirective(start, stop, attributes);
        } else if (JET__DIRECTIVE.equalsIgnoreCase(directive)) {
            this.handleJetDirective(start, stop, attributes);
        } else {
            this.recordProblem(ProblemSeverity.WARNING, 15, JET2Messages.ASTCompilerParseListener_UnsupportedDirective, new Object[]{directive}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        }
    }

    private void handleJetDirective(JETMark start, JETMark stop, Map attributes) {
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            if (!knownJETAttributes.contains(attrName)) {
                this.recordProblem(ProblemSeverity.ERROR, 6, JET2Messages.JET2Compiler_UnknownAttribute, new Object[]{attrName}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
            }
            if (!deprecatedJETAttributes.contains(attrName)) continue;
            this.recordProblem(ProblemSeverity.WARNING, 11, JET2Messages.JET2Compiler_DeprecatedAttribute, new Object[]{attrName}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        }
        String pkg = (String)attributes.get("package");
        String cls = (String)attributes.get("class");
        String importStr = (String)attributes.get("imports");
        String startTag = (String)attributes.get("startTag");
        String endTag = (String)attributes.get("endTag");
        String extend = (String)attributes.get("extends");
        if (pkg != null) {
            this.compilationUnit.setOutputJavaPackage(pkg);
        }
        if (cls != null) {
            this.compilationUnit.setOutputJavaClassName(cls);
        }
        if (importStr != null) {
            String[] imports = importStr.split("\\s+");
            this.compilationUnit.addImports(Arrays.asList(imports));
        }
        if (startTag != null) {
            this.parser.setStartTag(startTag);
        }
        if (endTag != null) {
            this.parser.setEndTag(endTag);
        }
        if (extend != null) {
            this.compilationUnit.setExtend(extend);
        }
    }

    private void handleTagLibDirective(JETMark start, JETMark stop, Map attributes) {
        String prefix = ((String)attributes.get(PREFIX__ATTR)).trim().toLowerCase();
        String id = (String)attributes.get(ID__ATTR);
        if (id == null) {
            this.compilationUnit.createProblem(ProblemSeverity.ERROR, 3, JET2Messages.JET2Compiler_MissingDirectiveAttribute, new Object[]{TAGLIB__DIRECTIVE, ID__ATTR}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        } else if (prefix == null) {
            this.compilationUnit.createProblem(ProblemSeverity.ERROR, 3, JET2Messages.JET2Compiler_MissingDirectiveAttribute, new Object[]{TAGLIB__DIRECTIVE, PREFIX__ATTR}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        } else if (!this.tagLibManager.canDefinePrefix(prefix, id)) {
            this.compilationUnit.createProblem(ProblemSeverity.ERROR, 4, JET2Messages.JET2Compiler_PrefixAlreadyAssigned, new Object[]{prefix, this.tagLibManager.getLibraryIdFromPrefix(prefix)}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        } else if (this.tagLibManager.isLibraryDefined(id)) {
            this.compilationUnit.createProblem(ProblemSeverity.ERROR, 5, JET2Messages.JET2Compiler_UnknownTagLibrary, new Object[]{id}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        } else {
            this.tagLibManager.add(prefix, id);
        }
    }

    public void handleExpression(JETMark start, JETMark stop, Map attributes) {
        JavaExpression expression = this.ast.newJavaExpression(start.getLine(), start.getCol(), start.getCursor() - 3, stop.getCursor() + 2, start.getCursor(), stop.getCursor(), this.reader.getChars(start, stop));
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.addBodyElement(expression);
        } else {
            XMLBodyElement topElement = this.elementStack.peek();
            topElement.addBodyElement(expression);
        }
    }

    public void handleCharData(char[] chars) {
        TextElement text = this.ast.newTextElement(chars);
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.addBodyElement(text);
        } else {
            XMLBodyElement topElement = this.elementStack.peek();
            topElement.addBodyElement(text);
        }
    }

    public void endPageProcessing() {
        while (!this.elementStack.isEmpty()) {
            XMLBodyElement element = this.elementStack.pop();
            this.compilationUnit.createProblem(ProblemSeverity.ERROR, 2, JET2Messages.JET2Compiler_MissingEndTag, new Object[]{element.getName()}, element.getStart(), element.getEnd(), element.getLine(), element.getColumn());
        }
    }

    public void handleScriptlet(JETMark start, JETMark stop, Map attributes) {
        JavaScriptlet scriplet = this.ast.newJavaScriptlet(start.getLine(), start.getCol(), start.getCursor() - 2, stop.getCursor() + 2, start.getCursor(), stop.getCursor(), this.reader.getChars(start, stop));
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.addBodyElement(scriplet);
        } else {
            XMLBodyElement topElement = this.elementStack.peek();
            topElement.addBodyElement(scriplet);
        }
    }

    public void handleComment(JETMark start, JETMark stop) {
        Comment comment = this.ast.newComment(start.getLine(), start.getCol(), start.getCursor() - 4, stop.getCursor() + 4, start.getCursor(), stop.getCursor(), this.reader.getChars(start, stop));
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.addBodyElement(comment);
        } else {
            XMLBodyElement topElement = this.elementStack.peek();
            topElement.addBodyElement(comment);
        }
    }

    public void handleDeclaration(JETMark start, JETMark stop) {
        JavaDeclaration decl = this.ast.newJavaDeclaration(start.getLine(), start.getCol(), start.getCursor() - 3, stop.getCursor() + 2, start.getCursor(), stop.getCursor(), this.reader.getChars(start, stop));
        this.compilationUnit.addBodyElement(decl);
    }

    /*
     * Unable to fully structure code
     */
    public void handleXMLEndTag(String tagName, JETMark start, JETMark stop) {
        block3: {
            tagIndex = this.elementStack.findElementIndex(tagName);
            endTag = this.ast.newXMLBodyElementEnd(start.getLine(), start.getCol(), start.getCursor(), stop.getCursor(), tagName);
            if (tagIndex != -1) ** GOTO lbl8
            this.compilationUnit.createProblem(ProblemSeverity.ERROR, 1, JET2Messages.JET2Compiler_MissingStartTag, new Object[]{tagName}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
            break block3;
lbl-1000:
            // 1 sources

            {
                top = this.elementStack.pop();
                this.compilationUnit.createProblem(ProblemSeverity.ERROR, 2, JET2Messages.JET2Compiler_MissingEndTag, new Object[]{top.getName()}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
lbl8:
                // 2 sources

                ** while (!this.elementStack.isAtTop((int)tagIndex))
            }
lbl9:
            // 1 sources

            topElement = this.elementStack.pop();
            endTag.setStartTag(topElement);
            topElement.setEndTag(endTag);
        }
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.addBodyElement(endTag);
        } else {
            topElement = this.elementStack.peek();
            topElement.addBodyElement(endTag);
        }
    }

    public void handleXMLEmptyTag(String tagName, JETMark start, JETMark stop, Map attributeMap) {
        TagDefinition td = this.tagLibManager.getTagDefinition(tagName);
        XMLEmptyElement decl = this.ast.newXMLEmptyElement(start.getLine(), start.getCol(), start.getCursor(), stop.getCursor(), tagName, attributeMap, td);
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.addBodyElement(decl);
        } else {
            XMLBodyElement topElement = this.elementStack.peek();
            topElement.addBodyElement(decl);
        }
    }

    public void handleXMLStartTag(String tagName, JETMark start, JETMark stop, Map attributeMap) {
        TagDefinition td = this.tagLibManager.getTagDefinition(tagName);
        if (!td.isContentAllowed() && tagName.indexOf(58) == -1) {
            this.recordProblem(ProblemSeverity.WARNING, 17, JET2Messages.JET2Compiler_TagShouldBeEmptyFormat, new Object[]{"<" + tagName + "/>"}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
            this.handleXMLEmptyTag(tagName, start, stop, attributeMap);
        } else {
            XMLBodyElement decl = this.ast.newXMLBodyElement(start.getLine(), start.getCol(), start.getCursor(), stop.getCursor(), tagName, attributeMap, td);
            if (this.elementStack.isEmpty()) {
                this.compilationUnit.addBodyElement(decl);
            } else {
                XMLBodyElement topElement = this.elementStack.peek();
                topElement.addBodyElement(decl);
            }
            this.elementStack.push(decl);
        }
    }

    public boolean isKnownTag(String tagName) {
        return this.tagLibManager.isKnownTag(tagName);
    }

    public JETCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void recordProblem(ProblemSeverity severity, int problemId, String message, Object[] msgArgs, int start, int end, int line, int colOffset) {
        this.compilationUnit.createProblem(severity, problemId, message, msgArgs, start, end, line, colOffset);
    }

    public TagLibraryReference[] getTagLibraryReferences() {
        TagLibraryReference[] result = this.tagLibManager.getTagLibraryReferences();
        return result;
    }

    public void parse(JETReader reader) {
        this.parser = this.configureParser(reader);
        this.beginPageProcessing();
        try {
            this.parser.parse();
        }
        catch (JETException e) {
            this.recordProblem(ProblemSeverity.ERROR, 9, e.getLocalizedMessage(), null, 0, 0, 1, 1);
        }
        this.endPageProcessing();
    }

    private JETParser configureParser(JETReader reader) {
        JETParser.Directive directive = new JETParser.Directive();
        directive.getDirectives().add(JET__DIRECTIVE);
        directive.getDirectives().add(TAGLIB__DIRECTIVE);
        directive.getDirectives().add("include");
        directive.getDirectives().add("start");
        directive.getDirectives().add("end");
        JETCoreElement[] coreElements = this.supportEmbeddedExpressions ? new JETCoreElement[]{new ErrorRedirectingCoreElementDelegate(directive), new ErrorRedirectingCoreElementDelegate(new JETParser.Expression()), new ErrorRedirectingCoreElementDelegate(new EmbeddedExpressionElement()), new ErrorRedirectingCoreElementDelegate(new CommentElementDelegate()), new ErrorRedirectingCoreElementDelegate(new DeclarationElementDelegate()), new ErrorRedirectingCoreElementDelegate(new JETParser.Scriptlet()), new ErrorRedirectingCoreElementDelegate(new XMLElementDelegate())} : new JETCoreElement[]{new ErrorRedirectingCoreElementDelegate(directive), new ErrorRedirectingCoreElementDelegate(new JETParser.Expression()), new ErrorRedirectingCoreElementDelegate(new CommentElementDelegate()), new ErrorRedirectingCoreElementDelegate(new DeclarationElementDelegate()), new ErrorRedirectingCoreElementDelegate(new JETParser.Scriptlet()), new ErrorRedirectingCoreElementDelegate(new XMLElementDelegate())};
        return new JETParser(reader, this, coreElements, this.supportEmbeddedExpressions ? "jet.xpath" : null);
    }

    public boolean isKnownInvalidTagName(String tagName) {
        return this.tagLibManager.isKnownInvalidTagName(tagName);
    }

    public Object parse(String templatePath) {
        ITemplateInput templateInput = this.templateResolver.getInput(templatePath);
        URI baseLocation = templateInput.getBaseLocation();
        try {
            if (this.compilationUnit == null) {
                this.compilationUnit = new JETAST().newJETCompilationUnit(baseLocation, templatePath, templateInput.getEncoding());
                this.ast = this.compilationUnit.getAst();
            }
            this.reader = new JETReader(baseLocation == null ? null : baseLocation.toString(), templatePath, templateInput.getReader());
            this.intermalParse();
        }
        catch (JETException e) {
            this.recordProblem(ProblemSeverity.ERROR, 9, e.getLocalizedMessage(), null, 0, 0, 1, 1);
        }
        catch (TemplateInputException e) {
            this.recordProblem(ProblemSeverity.ERROR, 9, e.getLocalizedMessage(), null, 0, 0, 1, 1);
        }
        return this.compilationUnit;
    }

    public Object parse(char[] template) {
        if (this.compilationUnit == null) {
            this.compilationUnit = new JETAST().newJETCompilationUnit(null, "", null);
            this.ast = this.compilationUnit.getAst();
        }
        try {
            this.reader = new JETReader(null, "", new CharArrayReader(template));
            this.intermalParse();
        }
        catch (JETException e) {
            this.recordProblem(ProblemSeverity.ERROR, 9, e.getLocalizedMessage(), null, 0, 0, 1, 1);
        }
        return this.compilationUnit;
    }

    private void intermalParse() throws JETException {
        this.parser = this.configureParser(this.reader);
        this.beginPageProcessing();
        this.parser.parse();
        this.endPageProcessing();
        this.compilationUnit.setTagLibraryReferences(this.getTagLibraryReferences());
        this.compilationUnit.accept(new TagValidationVisitor(this.compilationUnit));
        this.compilationUnit.accept(new TextTrimmingVisitor());
    }

    public void handleEmbeddedExpression(String language, JETMark start, JETMark stop) throws JETException {
        EmbeddedExpression ee = this.ast.newEmbeddedExpression(start.getLine(), start.getCol(), start.getCursor(), stop.getCursor(), language, this.reader.getChars(start, stop));
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.addBodyElement(ee);
        } else {
            XMLBodyElement topElement = this.elementStack.peek();
            topElement.addBodyElement(ee);
        }
    }
}

