/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.ui.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.internal.ui.l10n.Messages;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.eclipse.jet.ui.Activator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class JETLaunchHelper {
    private static ILaunchConfigurationType jetLaunchType = JETLaunchHelper.getConfigurationType();

    public static ILaunchConfiguration createConfig(String id, IResource resource) {
        try {
            ILaunchConfigurationWorkingCopy wConfig = jetLaunchType.newInstance(null, JETLaunchHelper.generateLaunchName(id, resource, Messages.LaunchShortcut_DefaultLaunchName));
            wConfig.setAttribute("org.eclipse.jet.id", id);
            wConfig.setAttribute("org.eclipse.jet.source", resource != null ? resource.getFullPath().toString() : "");
            ILaunchConfiguration config = wConfig.doSave();
            return config;
        }
        catch (CoreException e) {
            throw JETLaunchHelper.convertToRuntimeException(e);
        }
    }

    public static void findAndLaunchForTransformAndResource(Shell shell, String mode, String transformId, IResource resource) {
        ILaunchConfiguration configToLaunch;
        ILaunchConfiguration[] configs = JETLaunchHelper.findConfigsForTransformAndResource(mode, transformId, resource);
        switch (configs.length) {
            case 0: {
                configToLaunch = JETLaunchHelper.createConfig(transformId, resource);
                break;
            }
            case 1: {
                configToLaunch = configs[0];
                break;
            }
            default: {
                configToLaunch = JETLaunchHelper.chooseExistingConfig(shell, configs);
            }
        }
        if (configToLaunch != null) {
            DebugUITools.launch((ILaunchConfiguration)configToLaunch, (String)mode);
        }
    }

    public static boolean findAndLaunchForTransform(Shell shell, String mode, String transformId, boolean showConfigFirst) {
        ILaunchConfiguration[] configs = JETLaunchHelper.findConfigsForTransform(transformId);
        ILaunchConfiguration configToLaunch = null;
        switch (configs.length) {
            case 0: {
                IResource resource = JETLaunchHelper.chooseResource(shell);
                if (resource == null) break;
                configToLaunch = JETLaunchHelper.createConfig(transformId, resource);
                break;
            }
            case 1: {
                configToLaunch = configs[0];
                break;
            }
            default: {
                configToLaunch = JETLaunchHelper.chooseExistingConfig(shell, configs);
            }
        }
        if (configToLaunch != null) {
            boolean doLaunch = true;
            if (showConfigFirst) {
                int dialogResult = DebugUITools.openLaunchConfigurationDialog((Shell)shell, (ILaunchConfiguration)configToLaunch, (String)"org.eclipse.debug.ui.launchGroup.run", null);
                boolean bl = doLaunch = dialogResult != 1;
            }
            if (doLaunch) {
                DebugUITools.launch((ILaunchConfiguration)configToLaunch, (String)mode);
            }
        }
        return configToLaunch != null;
    }

    private static IResource chooseResource(Shell shell) {
        IResource resource = null;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.setTitle(Messages.JETTransformMainTab_SelectResourceDialogTitle);
        dialog.setMessage(Messages.JETTransformMainTab_SelectResourceDialogTitle);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length > 0) {
                    return new Status(0, Activator.getDefault().getBundle().getSymbolicName(), 0, "", null);
                }
                return new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 4, "", null);
            }
        });
        if (dialog.open() == 0) {
            resource = (IResource)dialog.getFirstResult();
        }
        return resource;
    }

    public static boolean findAndLauchForResource(Shell shell, String mode, IResource resource) {
        ILaunchConfiguration[] configs = JETLaunchHelper.findConfigsForResource(mode, resource);
        ILaunchConfiguration configToLaunch = null;
        switch (configs.length) {
            case 0: {
                IJETBundleDescriptor jetBundleDesc = JET2Platform.getProjectDescription((String)resource.getProject().getName());
                if (jetBundleDesc != null) {
                    configToLaunch = JETLaunchHelper.createConfig(jetBundleDesc.getId(), resource);
                    break;
                }
                configToLaunch = JETLaunchHelper.createConfig("", resource);
                if (configToLaunch == null) break;
                int dialogResult = DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)shell, (ILaunchConfiguration)configToLaunch, (String)"org.eclipse.debug.ui.launchGroup.run", null);
                if (dialogResult == 1) {
                    try {
                        configToLaunch.delete();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    configToLaunch = null;
                    break;
                }
                configs = JETLaunchHelper.findConfigsForResource(mode, resource);
                configToLaunch = configs.length > 0 ? configs[0] : null;
                break;
            }
            case 1: {
                configToLaunch = configs[0];
                break;
            }
            default: {
                configToLaunch = JETLaunchHelper.chooseExistingConfig(shell, configs);
            }
        }
        if (configToLaunch != null) {
            DebugUITools.launch((ILaunchConfiguration)configToLaunch, (String)mode);
        }
        return configToLaunch != null;
    }

    private static ILaunchConfiguration chooseExistingConfig(Shell shell, ILaunchConfiguration[] configs) {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((ILaunchConfiguration)element).getName();
            }
        };
        ElementListSelectionDialog dlg = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dlg.setElements((Object[])configs);
        dlg.setTitle(Messages.LaunchShortcut_DefaultLaunchName);
        dlg.setMessage(Messages.LaunchShortcut_DefaultLaunchName);
        dlg.setMultipleSelection(false);
        int result = dlg.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dlg.getFirstResult();
        }
        return null;
    }

    public static ILaunchConfiguration[] findConfigsForResource(String mode, IResource resource) {
        ArrayList<ILaunchConfiguration> finds = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] configs = JETLaunchHelper.getJETLaunchConfigs();
        IPath fullPath = resource.getFullPath().makeRelative();
        int i = 0;
        while (i < configs.length) {
            if (fullPath.equals((Object)new Path(JETLaunchHelper.getSource(configs[i])).makeRelative())) {
                finds.add(configs[i]);
            }
            ++i;
        }
        return finds.toArray(new ILaunchConfiguration[finds.size()]);
    }

    public static ILaunchConfiguration[] findConfigsForTransformAndResource(String mode, String transformId, IResource resource) {
        ArrayList<ILaunchConfiguration> finds = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] configs = JETLaunchHelper.getJETLaunchConfigs();
        String fullPath = resource.getFullPath().toString();
        int i = 0;
        while (i < configs.length) {
            if (fullPath.equals(JETLaunchHelper.getSource(configs[i])) && transformId.equals(JETLaunchHelper.getTransformID(configs[i]))) {
                finds.add(configs[i]);
            }
            ++i;
        }
        return finds.toArray(new ILaunchConfiguration[finds.size()]);
    }

    public static ILaunchConfiguration[] findConfigsForTransform(String transformId) {
        ILaunchConfiguration[] configs = JETLaunchHelper.getJETLaunchConfigs();
        ArrayList<ILaunchConfiguration> finds = new ArrayList<ILaunchConfiguration>();
        int i = 0;
        while (i < configs.length) {
            if (transformId.equals(JETLaunchHelper.getTransformID(configs[i]))) {
                finds.add(configs[i]);
            }
            ++i;
        }
        return finds.toArray(new ILaunchConfiguration[finds.size()]);
    }

    private static String getSource(ILaunchConfiguration config) {
        try {
            return config.getAttribute("org.eclipse.jet.source", null);
        }
        catch (CoreException e) {
            throw JETLaunchHelper.convertToRuntimeException(e);
        }
    }

    private static String getTransformID(ILaunchConfiguration config) {
        try {
            return config.getAttribute("org.eclipse.jet.id", null);
        }
        catch (CoreException e) {
            throw JETLaunchHelper.convertToRuntimeException(e);
        }
    }

    private static RuntimeException convertToRuntimeException(CoreException e) {
        return new RuntimeException("Unexpected exception", e);
    }

    private static ILaunchConfiguration[] getJETLaunchConfigs() {
        try {
            ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
            return lm.getLaunchConfigurations(jetLaunchType);
        }
        catch (CoreException e) {
            throw JETLaunchHelper.convertToRuntimeException(e);
        }
    }

    private static ILaunchConfigurationType getConfigurationType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.jet.jet2Transformation");
    }

    public static String generateLaunchName(String id, IResource input, String defaultName) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        String prefix = id == null && input == null ? defaultName : (input == null ? id : (id == null ? input.getName() : String.valueOf(id) + " (" + input.getName() + ")"));
        return lm.generateUniqueLaunchConfigurationNameFrom(prefix);
    }

    public static ILaunchConfiguration[] findAllConfigs() {
        return JETLaunchHelper.getJETLaunchConfigs();
    }
}

