/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.ui.newproject;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class NewProjectInfo {
    private String projectName;
    private Map otherInfo = null;
    private static final String NL = System.getProperty("line.separator");
    private static final String INDENT = "    ";
    private final Map projectAttributes = new LinkedHashMap();

    public final String getProjectName() {
        return this.projectName;
    }

    public final void setProjectName(String projectName) {
        this.projectName = projectName;
        this.setProjectAttribute("name", projectName);
    }

    public String toXmlString() {
        if (this.projectName == null) {
            throw new IllegalStateException("projectName not set");
        }
        StringBuffer xml = new StringBuffer();
        xml.append("<newProjectModel>").append(NL);
        xml.append(INDENT).append("<project");
        Iterator i = this.projectAttributes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.addAttribute(xml, (String)entry.getKey(), (String)entry.getValue());
        }
        xml.append("/>").append(NL);
        if (this.otherInfo != null) {
            i = this.otherInfo.values().iterator();
            while (i.hasNext()) {
                String otherElement = (String)((Object)i.next());
                xml.append(INDENT).append(otherElement).append(NL);
            }
        }
        xml.append("</newProjectModel>").append(NL);
        return xml.toString();
    }

    private void addAttribute(StringBuffer xml, String name, String value) {
        if (value != null) {
            xml.append(' ').append(name).append("=\"").append(value).append("\"");
        }
    }

    public void setOtherInfo(String key, String xmlContent) {
        if (this.otherInfo == null) {
            this.otherInfo = new LinkedHashMap();
        }
        if (xmlContent != null) {
            this.otherInfo.put(key, xmlContent);
        } else {
            this.otherInfo.remove(key);
        }
    }

    public void setLocation(String location) {
        this.setProjectAttribute("location", location);
    }

    public void setProjectAttribute(String attributeName, String value) {
        this.projectAttributes.put(attributeName, value);
    }
}

