/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jet.internal.InternalJET2Platform;

public class SavedStateManager
implements ISaveParticipant {
    private static boolean DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/savedState")) != false;
    private ISavedState savedState;
    private List stateSavers = new ArrayList();
    private Map saversByProject = new HashMap();
    private final InternalJET2Platform plugin = InternalJET2Platform.getDefault();

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        switch (context.getKind()) {
            case 1: {
                this.doSave(context, this.stateSavers);
                break;
            }
            case 3: {
                IProject project = context.getProject();
                List projectSavers = (List)this.saversByProject.get(project);
                if (projectSavers == null) break;
                this.doSave(context, projectSavers);
                break;
            }
            case 2: {
                this.doSave(context, this.stateSavers);
            }
        }
    }

    private void doSave(ISaveContext context, List projectSavers) throws IllegalStateException, CoreException {
        Iterator i = projectSavers.iterator();
        while (i.hasNext()) {
            WeakReference ref = (WeakReference)i.next();
            IStateSaver saver = (IStateSaver)ref.get();
            if (saver == null) continue;
            IPath logicalPath = this.getLogicalStatePath(saver);
            IPath realPath = this.getActualPath(logicalPath, context.getSaveNumber());
            context.map(logicalPath, realPath);
            IPath location = this.plugin.getStateLocation().append(realPath);
            saver.doSave(location);
            context.needSaveNumber();
        }
    }

    private IPath getActualPath(IPath logicalPath, int saveNumber) {
        Path saveDirPath = this.getSaveDirectory(saveNumber);
        IPath realPath = saveDirPath.append(logicalPath);
        return realPath;
    }

    private IPath getLogicalStatePath(IStateSaver saver) {
        IPath logicalPath = new Path(saver.getProject().getName()).append(saver.getStateFileName());
        return logicalPath;
    }

    private Path getSaveDirectory(int saveNumber) {
        return new Path("save-" + Integer.toString(saveNumber));
    }

    public void startup() {
        if (DEBUG) {
            System.out.println("SavedStateManager.startup()");
        }
        try {
            this.savedState = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)InternalJET2Platform.getDefault(), (ISaveParticipant)this);
            if (DEBUG && this.savedState != null) {
                System.out.println("   found saved state: " + this.savedState.getSaveNumber());
            }
        }
        catch (CoreException coreException) {
            this.savedState = null;
        }
    }

    public void shutdown() {
        if (DEBUG) {
            System.out.println("SavedStateManager.shutdown()");
        }
        ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)InternalJET2Platform.getDefault());
    }

    public IPath addSaveSaver(IStateSaver saver, IProject project) {
        this.stateSavers.add(new WeakReference<IStateSaver>(saver));
        this.rememberProjectSaver(project, saver);
        IPath initialLocation = null;
        if (this.savedState != null) {
            int saveNumber = this.savedState.getSaveNumber();
            IPath realPath = this.getActualPath(this.getLogicalStatePath(saver), saveNumber);
            initialLocation = InternalJET2Platform.getDefault().getStateLocation().append(realPath);
        }
        if (DEBUG) {
            System.out.println("SavedStateManager.addSaveSaver(): " + project + ", " + initialLocation);
        }
        return initialLocation;
    }

    private void rememberProjectSaver(IProject project, IStateSaver saver) {
        ArrayList<WeakReference<IStateSaver>> list = (ArrayList<WeakReference<IStateSaver>>)this.saversByProject.get(project);
        if (list == null) {
            list = new ArrayList<WeakReference<IStateSaver>>();
        }
        list.add(new WeakReference<IStateSaver>(saver));
    }

    public static interface IStateSaver {
        public String getStateFileName();

        public void doSave(IPath var1) throws CoreException;

        public IProject getProject();
    }
}

