/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jet.CoreJETException;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.AbstractEmptyTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.transform.TransformContextExtender;

public class LoadTag
extends AbstractEmptyTag {
    public void doAction(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        URL modelURL;
        String url = this.getAttribute("url");
        String var = this.getAttribute("var");
        String urlContext = this.getAttribute("urlContext");
        String type = this.getAttribute("type");
        String loaderId = this.getAttribute("loader");
        TransformContextExtender tce = new TransformContextExtender(context);
        URL baseURL = tce.getBaseURL(urlContext);
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        try {
            modelURL = new URL(baseURL, url);
        }
        catch (MalformedURLException e) {
            throw new JET2TagException(e);
        }
        try {
            Object modelRoot = TransformContextExtender.loadModel(modelURL, loaderId, type);
            context.setVariable(var, modelRoot);
        }
        catch (IOException e) {
            String msg = JET2Messages.LoadTag_CouldNotLoad;
            throw new JET2TagException(MessageFormat.format(msg, url), e);
        }
        catch (CoreJETException e) {
            String msg = JET2Messages.LoadTag_CouldNotLoad;
            throw new JET2TagException(MessageFormat.format(msg, url), e);
        }
    }
}

