/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.workspace;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.AbstractWorkspaceAction;
import org.eclipse.jet.taglib.workspace.ActionsUtil;
import org.eclipse.jet.taglib.workspace.IWorkspaceAction;

public class WsCopyTextFileAction
extends AbstractWorkspaceAction
implements IWorkspaceAction {
    private final IFile file;
    private final boolean replace;
    private final String targetEncoding;
    private final String sourceFileContents;
    private final JET2Context context;

    public WsCopyTextFileAction(JET2Context context, String templatePath, TagInfo td, String sourceFileContents, IFile file, boolean replaceExisting, String targetEncoding) {
        super(td, templatePath);
        this.context = context;
        this.sourceFileContents = sourceFileContents;
        this.file = file;
        this.replace = replaceExisting;
        this.targetEncoding = targetEncoding;
    }

    public IResource getResource() {
        return this.file;
    }

    public boolean requiresValidateEdit() {
        return this.replace && this.file.exists() && this.file.isReadOnly();
    }

    public void performAction(IProgressMonitor monitor) throws JET2TagException {
        ActionsUtil.writeTextFile(this.file, this.replace, this.targetEncoding, false, this.sourceFileContents, monitor);
        String fileMessage = MessageFormat.format(JET2Messages.WsFileFromWriterAction_WritingFile, this.file.getFullPath().toString());
        RuntimeLoggerContextExtender.log(this.context, fileMessage, this.getTagInfo(), this.getTemplatePath(), 3);
    }
}

