/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath;

import java.text.MessageFormat;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.xpath.XPathExpressionImpl;
import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.internal.xpath.functions.BuiltinXPathFunctionResolver;
import org.eclipse.jet.internal.xpath.parser.Token;
import org.eclipse.jet.internal.xpath.parser.XPathParser;
import org.eclipse.jet.xpath.IAnnotationManager;
import org.eclipse.jet.xpath.NamespaceContext;
import org.eclipse.jet.xpath.XPath;
import org.eclipse.jet.xpath.XPathException;
import org.eclipse.jet.xpath.XPathExpression;
import org.eclipse.jet.xpath.XPathFunctionResolver;
import org.eclipse.jet.xpath.XPathSyntaxException;
import org.eclipse.jet.xpath.XPathVariableResolver;

public class XPathImpl
implements XPath {
    private XPathFunctionResolver functionResolver = BuiltinXPathFunctionResolver.getInstance();
    private XPathVariableResolver variableResolver;
    private final IAnnotationManager annotationManager;
    private NamespaceContext nsContext;

    public XPathImpl(IAnnotationManager annotationManager) {
        this.annotationManager = annotationManager;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver resolver) {
        this.functionResolver = resolver;
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.functionResolver;
    }

    public void setXPathVariableResolver(XPathVariableResolver resolver) {
        this.variableResolver = resolver;
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.variableResolver;
    }

    public XPathExpression compile(String expression) throws XPathException {
        XPathParser parser = new XPathParser(expression, this.functionResolver, this.nsContext);
        ExprNode expr = parser.expr();
        if (parser.peekNext() != Token.EOF_TOKEN) {
            throw new XPathSyntaxException(MessageFormat.format(JET2Messages.XPath_UnrecognizedToken, parser.peekNext()));
        }
        XPathExpressionImpl pathExpr = new XPathExpressionImpl(expr, this.variableResolver, this.annotationManager);
        return pathExpr;
    }

    public void setNamespaceContext(NamespaceContext nsContext) {
        if (nsContext == null) {
            throw new NullPointerException();
        }
        this.nsContext = nsContext;
    }

    public NamespaceContext getNamespaceContext() {
        return this.nsContext;
    }
}

