/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.launch;

import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jet.CoreJETException;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.launch.JETStreamsProxy;
import org.eclipse.jet.taglib.workspace.WorkspaceContextExtender;
import org.eclipse.jet.transform.IJETBundleDescriptor;

public class JETProcess
extends PlatformObject
implements IProcess {
    private final String label;
    private final ILaunch launch;
    private boolean terminated = false;
    private final String id;
    private final IResource resource;
    private final IProgressMonitor monitor;
    private JET2Context context;
    private JETStreamsProxy streamsProxy;
    private final Map attributes = new HashMap();

    public JETProcess(ILaunch launch, String id, IResource resource, int logFilterLevel, IProgressMonitor monitor) {
        this.label = " - " + DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
        this.launch = launch;
        this.id = id;
        this.resource = resource;
        this.monitor = monitor;
        this.context = new JET2Context(null);
        this.streamsProxy = new JETStreamsProxy(this.context, logFilterLevel);
        this.setAttribute(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.jet.process");
    }

    public String getLabel() {
        return this.label;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.streamsProxy;
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getAttribute(String key) {
        return (String)this.attributes.get(key);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public boolean canTerminate() {
        return false;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() throws DebugException {
    }

    public void run() {
        try {
            IJETBundleDescriptor descriptor = JET2Platform.getJETBundleManager().getDescriptor(this.id);
            if (descriptor != null) {
                String loaderId = descriptor.getModelLoaderId();
                String fileType = descriptor.getModelExtension();
                WorkspaceContextExtender.loadResourceAsSource(this.context, this.resource, loaderId, fileType);
                IStatus status = JET2Platform.runTransform(this.id, this.context, this.monitor);
                this.context.logInfo(status.getMessage());
            } else {
                this.context.logError(MessageFormat.format(JET2Messages.JET2Platform_TransformNotFound, this.id));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, this.id, 0, e.getLocalizedMessage(), (Throwable)e);
            this.context.logError(e.getLocalizedMessage());
        }
        catch (CoreJETException e) {
            Status status = new Status(4, this.id, 0, e.getLocalizedMessage(), (Throwable)e);
            this.context.logError(e.getLocalizedMessage());
        }
        this.terminated = true;
        this.context = null;
    }
}

