/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime.model.jdt;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jet.internal.xpath.inspectors.jdt.ASTNodeDocumentRoot;
import org.eclipse.jet.runtime.model.IModelLoader;

public class JavaLoader
implements IModelLoader {
    public boolean canLoad(String kind) {
        return "java".equals(kind);
    }

    public Object load(URL modelUrl) throws IOException {
        return this.load(modelUrl, "java");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object load(URL modelUrl, String kind) throws IOException {
        Object var7_8;
        String path;
        if ("platform".equals(modelUrl.getProtocol()) && (path = modelUrl.getPath()) != null && path.startsWith("/resource/")) {
            IJavaElement javaElement;
            IPath ipath = new Path(path).removeFirstSegments(1);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(ipath);
            if (resource != null && (javaElement = JavaCore.create((IResource)resource)) instanceof ICompilationUnit) {
                ASTParser astParser = ASTParser.newParser((int)3);
                astParser.setSource((ICompilationUnit)javaElement);
                ASTNode astNode = astParser.createAST((IProgressMonitor)new NullProgressMonitor());
                try {
                    String contents = ((ICompilationUnit)javaElement).getBuffer().getContents();
                    return new ASTNodeDocumentRoot(astNode, contents);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(modelUrl.openStream()));
        StringBuffer buffer = new StringBuffer(512);
        try {
            int i;
            char[] cbuf = new char[512];
            while ((i = reader.read(cbuf)) > 0) {
                buffer.append(cbuf, 0, i);
            }
        }
        catch (Throwable throwable) {
            var7_8 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            var7_8 = null;
        }
        try {}
        catch (IOException iOException) {
            return this.loadFromString(buffer.toString(), kind);
        }
        reader.close();
        return this.loadFromString(buffer.toString(), kind);
    }

    public Object loadFromString(String serializedModel, String kind) throws IOException {
        ASTParser astParser = ASTParser.newParser((int)3);
        astParser.setSource(serializedModel.toCharArray());
        astParser.setKind(this.getKind(kind));
        ASTNode astNode = astParser.createAST((IProgressMonitor)new NullProgressMonitor());
        return new ASTNodeDocumentRoot(astNode, serializedModel);
    }

    private int getKind(String kind) {
        if ("classbodydeclarations".equalsIgnoreCase(kind)) {
            return 4;
        }
        if ("expression".equals(kind)) {
            return 1;
        }
        if ("statements".equals(kind)) {
            return 2;
        }
        return 8;
    }
}

