/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jet.internal.xpath.NodeSetImpl;
import org.eclipse.jet.internal.xpath.ast.NodeTest;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.IAnnotationManager;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.inspector.IElementInspector;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.INodeInspectorExtension1;
import org.eclipse.jet.xpath.inspector.InspectorManager;

public abstract class Axis {
    private static final Axis childAxis = new ChildAxis();
    private static final Axis attributeAxis = new AttributeAxis();
    private static final Axis parentAxis = new ParentAxis();
    private static final Axis selfAxis = new SelfAxis();
    private static final Axis descendantOrSelfAxis = new DescendantOrSelfAxis();
    private static final Map axisByNameMap = new HashMap(15);

    static {
        axisByNameMap.put(childAxis.getAxisName(), childAxis);
        axisByNameMap.put(attributeAxis.getAxisName(), attributeAxis);
        axisByNameMap.put(parentAxis.getAxisName(), parentAxis);
        axisByNameMap.put(selfAxis.getAxisName(), selfAxis);
        axisByNameMap.put(descendantOrSelfAxis.getAxisName(), descendantOrSelfAxis);
    }

    protected final Object hasAnnotations(Context context, Object contextNode, AnnotationAction action) {
        IAnnotationManager annotationManager;
        if (context.hasAnnotationManager() && (annotationManager = context.getAnnotationManager()).hasAnnotations(contextNode)) {
            Object annotation = annotationManager.getAnnotationObject(contextNode);
            IElementInspector inspector = (IElementInspector)InspectorManager.getInstance().getInspector(annotation);
            return action.doAction(annotation, inspector);
        }
        return null;
    }

    public abstract NodeSet evaluate(NodeTest var1, Context var2);

    public abstract INodeInspector.NodeKind principalNodeKind();

    public abstract String getAxisName();

    public static Axis childAxis() {
        return childAxis;
    }

    public static Axis attributeAxis() {
        return attributeAxis;
    }

    public static Axis parentAxis() {
        return parentAxis;
    }

    public static Axis descendantOrSelf() {
        return descendantOrSelfAxis;
    }

    public static Axis axisByName(String axisName) {
        return (Axis)axisByNameMap.get(axisName);
    }

    public static Axis selfAxis() {
        return selfAxis;
    }

    public String toString() {
        return String.valueOf(this.getAxisName()) + "::";
    }

    protected NodeSet arrayToNodeSet(Object[] attributes) {
        NodeSetImpl result = new NodeSetImpl(attributes.length);
        int i = 0;
        while (i < attributes.length) {
            result.add(attributes[i]);
            ++i;
        }
        return result;
    }

    private static interface AnnotationAction {
        public Object doAction(Object var1, IElementInspector var2);
    }

    private static final class AttributeAxis
    extends Axis {
        private AttributeAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSet result = NodeSetImpl.EMPTY_SET;
            Object contextNode = context.getContextNode();
            INodeInspector inspector = context.getContextNodeInspector();
            if (inspector instanceof IElementInspector && inspector.getNodeKind(contextNode) == INodeInspector.NodeKind.ELEMENT) {
                IElementInspector elementInspector = (IElementInspector)inspector;
                if (nodeTest.isSimpleNameTest()) {
                    Object namedAttribute = elementInspector.getNamedAttribute(contextNode, nodeTest.getNameTestExpandedName());
                    if (namedAttribute == null) {
                        namedAttribute = this.hasAnnotations(context, contextNode, new AnnotationAction(this, nodeTest){
                            final /* synthetic */ AttributeAxis this$1;
                            private final /* synthetic */ NodeTest val$nodeTest;
                            {
                                this.this$1 = attributeAxis;
                                this.val$nodeTest = nodeTest;
                            }

                            public Object doAction(Object annotation, IElementInspector inspector) {
                                return inspector.getNamedAttribute(annotation, this.val$nodeTest.getNameTestExpandedName());
                            }
                        });
                    }
                    if (namedAttribute != null) {
                        result = new NodeSetImpl();
                        result.add(namedAttribute);
                    }
                } else {
                    Object[] attributes = elementInspector.getAttributes(contextNode);
                    result = this.arrayToNodeSet(attributes);
                    Object[] annAttributes = (Object[])this.hasAnnotations(context, contextNode, new AnnotationAction(this){
                        final /* synthetic */ AttributeAxis this$1;
                        {
                            this.this$1 = attributeAxis;
                        }

                        public Object doAction(Object annotation, IElementInspector inspector) {
                            return inspector.getAttributes(annotation);
                        }
                    });
                    if (annAttributes != null) {
                        result.addAll(Arrays.asList(annAttributes));
                    }
                    nodeTest.filter(result);
                }
            }
            return result;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ATTRIBUTE;
        }

        public String getAxisName() {
            return "attribute";
        }
    }

    private static final class ChildAxis
    extends Axis {
        private ChildAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSet result = NodeSetImpl.EMPTY_SET;
            Object contextNode = context.getContextNode();
            INodeInspector inspector = context.getContextNodeInspector();
            INodeInspector.NodeKind nodeKind = inspector.getNodeKind(contextNode);
            if (nodeKind == INodeInspector.NodeKind.ELEMENT || nodeKind == INodeInspector.NodeKind.ROOT) {
                if (nodeTest.isSimpleNameTest() && inspector instanceof INodeInspectorExtension1) {
                    Object[] children = ((INodeInspectorExtension1)((Object)inspector)).getNamedChildren(contextNode, nodeTest.getNameTestExpandedName());
                    if (children != null) {
                        result = this.arrayToNodeSet(children);
                    }
                } else {
                    Object[] children = inspector.getChildren(contextNode);
                    result = this.arrayToNodeSet(children);
                    nodeTest.filter(result);
                }
            }
            return result;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }

        public String getAxisName() {
            return "child";
        }
    }

    private static final class DescendantOrSelfAxis
    extends Axis {
        private DescendantOrSelfAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSetImpl result = new NodeSetImpl();
            result.add(context.getContextNode());
            nodeTest.filter(result);
            NodeSet children = DescendantOrSelfAxis.childAxis().evaluate(NodeTest.allNodes(), context);
            int contextPos = 1;
            Iterator i = children.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                Context subcontext = context.newSubContext(object, contextPos, children.size());
                result.addAll(this.evaluate(nodeTest, subcontext));
                ++contextPos;
            }
            return result;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }

        public String getAxisName() {
            return "descendant-or-self";
        }
    }

    private static final class ParentAxis
    extends Axis {
        private ParentAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            Object obj = context.getContextNode();
            INodeInspector inspector = context.getContextNodeInspector();
            Object parent = inspector.getParent(obj);
            NodeSet result = NodeSetImpl.EMPTY_SET;
            if (parent != null) {
                result = new NodeSetImpl(1);
                result.add(parent);
            }
            nodeTest.filter(result);
            return result;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }

        public String getAxisName() {
            return "parent";
        }
    }

    private static final class SelfAxis
    extends Axis {
        private SelfAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSetImpl nodeSet = new NodeSetImpl(1);
            nodeSet.add(context.getContextNode());
            nodeTest.filter(nodeSet);
            return nodeSet;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }

        public String getAxisName() {
            return "self";
        }
    }
}

