/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.xtend.shared.ui.internal.XtendLog;
import org.eclipse.xtend.typesystem.MetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelContainer
implements IElementChangedListener,
IResourceChangeListener {
    List<IJavaProject> projects;
    boolean changed = false;
    private Set<MetaModel> metaModels;
    Set<IResource> resources;

    public MetamodelContainer(List<IJavaProject> project, Set<IResource> resource, Set<MetaModel> metamodels) {
        this.projects = project;
        this.metaModels = metamodels;
        this.resources = resource;
    }

    public void elementChanged(ElementChangedEvent event) {
        Iterator<IJavaProject> iter = this.projects.iterator();
        while (!this.changed && iter.hasNext()) {
            IJavaProject project = iter.next();
            if (!project.isOnClasspath(event.getDelta().getElement())) continue;
            this.changed = true;
        }
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public Set<MetaModel> getMetaModels() {
        return this.metaModels;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.changed) {
            return;
        }
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta rootDelta = event.getDelta();
        try {
            rootDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (!MetamodelContainer.this.changed && delta.getResource() != null) {
                        if (MetamodelContainer.this.resources.contains(delta.getResource())) {
                            MetamodelContainer.this.changed = true;
                        }
                        if (delta.getResource() instanceof IProject) {
                            Iterator<IJavaProject> iter = MetamodelContainer.this.projects.iterator();
                            while (!MetamodelContainer.this.changed && iter.hasNext()) {
                                IJavaProject project = iter.next();
                                if (!project.getProject().equals((Object)delta.getResource())) continue;
                                MetamodelContainer.this.changed = true;
                            }
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
    }
}

