/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.Analyzable;
import org.eclipse.xtend.expression.Evaluatable;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
extends SyntaxElement
implements Analyzable,
Evaluatable {
    protected Type findType(Identifier type, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type toCast = ctx.getTypeForName(type.getValue());
        if (toCast == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, type.getValue(), type));
        }
        return toCast;
    }

    @Override
    public final Object evaluate(ExecutionContext ctx) {
        try {
            Object evaluateInternal = this.evaluateInternal(ctx);
            return evaluateInternal;
        }
        catch (EvaluationException ex) {
            ctx.handleRuntimeException(ex, this, null);
            return null;
        }
        catch (RuntimeException ex) {
            EvaluationException evalex = new EvaluationException(ex.getMessage(), (SyntaxElement)this, ctx);
            ctx.handleRuntimeException(evalex, this, null);
            return null;
        }
    }

    public final String toString() {
        return this.toStringInternal();
    }

    protected abstract String toStringInternal();

    protected abstract Object evaluateInternal(ExecutionContext var1);
}

