/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;

public class Identifier
extends SyntaxElement {
    private String value;
    private List<Identifier> follows = new ArrayList<Identifier>();
    private String fullVal = null;

    public Identifier(String value) {
        this.value = value;
    }

    public Identifier append(Identifier t) {
        this.follows.add(t);
        return this;
    }

    public String getValue() {
        if (this.fullVal == null) {
            StringBuffer buff = new StringBuffer(this.internalGetText());
            for (Identifier id : this.follows) {
                buff.append(id.getValue());
            }
            this.fullVal = buff.toString();
        }
        return this.fullVal;
    }

    private String internalGetText() {
        if (this.value.startsWith("^")) {
            return this.value.substring(1);
        }
        return this.value;
    }

    public int getEnd() {
        if (!this.follows.isEmpty()) {
            return this.follows.get(this.follows.size() - 1).getEnd();
        }
        return super.getEnd();
    }

    public String toString() {
        return this.getValue();
    }
}

