/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.type.impl.java.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.internal.xtend.type.baseimpl.FeatureImpl;
import org.eclipse.internal.xtend.type.baseimpl.StaticPropertyImpl;
import org.eclipse.internal.xtend.type.impl.java.JavaOperationImpl;
import org.eclipse.internal.xtend.type.impl.java.JavaPropertyImpl;
import org.eclipse.internal.xtend.type.impl.java.JavaStaticPropertyImpl;
import org.eclipse.internal.xtend.type.impl.java.JavaTypeStrategy;
import org.eclipse.internal.xtend.type.impl.java.TypeFinder;
import org.eclipse.internal.xtend.util.StringHelper;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeansStrategy
implements JavaTypeStrategy {
    private static Map<Class<?>, PropertyDescriptor[]> propertyDescCache = new HashMap();

    public Feature[] getFeatures(TypeFinder typeFinder, Class clazz, Type t) {
        PropertyDescriptor[] pdArr;
        ArrayList<FeatureImpl> result = new ArrayList<FeatureImpl>();
        HashSet<Method> usedMethods = new HashSet<Method>();
        if (propertyDescCache.containsKey(clazz)) {
            pdArr = propertyDescCache.get(clazz);
        } else {
            try {
                pdArr = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            }
            catch (IntrospectionException introspectionException) {
                pdArr = new PropertyDescriptor[]{};
            }
            propertyDescCache.put(clazz, pdArr);
        }
        int i = 0;
        while (i < pdArr.length) {
            Method m;
            PropertyDescriptor pd = pdArr[i];
            Method method = m = pd.getReadMethod() != null ? pd.getReadMethod() : pd.getWriteMethod();
            if (m != null && clazz.equals(m.getDeclaringClass())) {
                String propName = pd.getName();
                if (pd.getReadMethod() != null) {
                    usedMethods.add(pd.getReadMethod());
                }
                result.add(new JavaPropertyImpl(t, propName, typeFinder.builtinAwareGetTypeForClass(pd.getPropertyType()), pd.getReadMethod(), pd.getWriteMethod()));
            }
            ++i;
        }
        Method[] meths = clazz.getDeclaredMethods();
        int i2 = 0;
        while (i2 < meths.length) {
            Method method = meths[i2];
            if (Modifier.isPublic(method.getModifiers()) && !usedMethods.contains(method)) {
                try {
                    if (this.isNonStandardBooleanProperty(method)) {
                        this.handleNonStandardBooleanProperty(typeFinder, t, result, pdArr, method);
                    } else {
                        Type returnType = typeFinder.builtinAwareGetTypeForClass(method.getReturnType());
                        result.add(new JavaOperationImpl(t, method.getName(), returnType, this.createTypes(method.getParameterTypes(), typeFinder), method));
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
            ++i2;
        }
        Field[] fields = clazz.getFields();
        int i3 = 0;
        while (i3 < fields.length) {
            Field field = fields[i3];
            int mod = field.getModifiers();
            if (Modifier.isPublic(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod)) {
                result.add(new JavaStaticPropertyImpl(t, field.getName(), typeFinder.builtinAwareGetTypeForClass(field.getType()), field));
            }
            ++i3;
        }
        T[] enumValues = clazz.getEnumConstants();
        if (enumValues != null) {
            T[] TArray = enumValues;
            int n = enumValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = TArray[n2];
                final Enum curEnum = (Enum)o;
                result.add(new StaticPropertyImpl(t, curEnum.name(), t){

                    public Object get() {
                        return curEnum;
                    }
                });
                ++n2;
            }
        }
        return result.toArray(new Feature[result.size()]);
    }

    private boolean isNonStandardBooleanProperty(Method method) {
        return method.getName().startsWith("is") && method.getReturnType().getName().equals(Boolean.class.getName()) && method.getParameterTypes().length == 0;
    }

    private void handleNonStandardBooleanProperty(TypeFinder typeFinder, Type t, List<FeatureImpl> result, PropertyDescriptor[] pdArr, Method method) {
        String propName = method.getName().substring(2);
        if (propName.length() > 1 && propName.matches("\\p{Upper}\\p{Lower}.*")) {
            propName = StringHelper.firstLower(propName);
        }
        JavaPropertyImpl setMethod = null;
        Method writeMethod = null;
        block0: for (FeatureImpl feature : result) {
            if (!feature.getName().equals(propName)) continue;
            setMethod = (JavaPropertyImpl)feature;
            PropertyDescriptor[] propertyDescriptorArray = pdArr;
            int n = pdArr.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (pd.getName().equals(propName)) {
                    writeMethod = pd.getWriteMethod();
                    break block0;
                }
                ++n2;
            }
            break block0;
        }
        if (setMethod != null) {
            result.remove(setMethod);
        }
        JavaPropertyImpl prop = new JavaPropertyImpl(t, propName, typeFinder.builtinAwareGetTypeForClass(Boolean.class), method, writeMethod);
        result.add(prop);
    }

    protected Type[] createTypes(Class<?>[] parameterTypes, TypeFinder tf) {
        Type[] result = new Type[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            result[i] = tf.builtinAwareGetTypeForClass(parameterTypes[i]);
            if (result[i] == null) {
                throw new NullPointerException();
            }
            ++i;
        }
        return result;
    }
}

