/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.check;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.internal.xtend.xtend.parser.ParseFacade;
import org.eclipse.xtend.check.CheckUtils;
import org.eclipse.xtend.expression.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckFacade {
    public static final void checkAll(String checkFile, Collection<?> toCheck, ExecutionContext ctx, Issues issues) {
        CheckFacade.checkAll(checkFile, toCheck, ctx, issues, false);
    }

    public static final void checkAll(String checkFile, InputStream in, Collection<?> toCheck, ExecutionContext ctx, Issues issues) {
        CheckFacade.checkAll(checkFile, in, toCheck, ctx, issues, false);
    }

    public static final void checkAll(String checkFile, InputStream in, Collection<?> toCheck, ExecutionContext ctx, Issues issues, boolean warnIfNothingChecked) {
        if (in == null) {
            throw new ConfigurationException("Couldn't find check file :'" + checkFile + "'");
        }
        ExtensionFile file = ParseFacade.file(new InputStreamReader(in), checkFile);
        file.check(ctx, toCheck, issues, warnIfNothingChecked);
    }

    public static final void checkAll(String checkFile, Collection<?> toCheck, ExecutionContext ctx, Issues issues, boolean warnIfNothingChecked) {
        InputStream in = ResourceLoaderFactory.createResourceLoader().getResourceAsStream(CheckUtils.getJavaResourceName(checkFile));
        CheckFacade.checkAll(checkFile, in, toCheck, ctx, issues, warnIfNothingChecked);
    }
}

