/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.ResourceContributor;
import org.eclipse.xtend.shared.ui.core.AbstractResource;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandBuilder;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandMarkerManager;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandNature;
import org.eclipse.xtend.shared.ui.core.internal.JDTUtil;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendXpandProject
implements IXtendXpandProject {
    private static final Set<IJavaProject> initializing = new HashSet<IJavaProject>();
    private static final IXtendXpandResource NULL_RESOURCE = new AbstractResource(null){

        @Override
        public String getFileExtension() {
            return null;
        }

        @Override
        protected void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        }

        @Override
        protected boolean internalRefresh() {
            return false;
        }
    };
    final IJavaProject project;
    private final Map<String, Map<ResourceID, IXtendXpandResource>> resources = new HashMap<String, Map<ResourceID, IXtendXpandResource>>();
    private final Set<ResourceID> fromJar = new HashSet<ResourceID>();

    public XtendXpandProject(IJavaProject resource) {
        this.project = resource;
        try {
            IProject[] ps = this.project.getProject().getReferencedProjects();
            int i = 0;
            while (i < ps.length) {
                if (initializing.add(this.project)) {
                    try {
                        Activator.getExtXptModelManager().findProject((IResource)ps[i]);
                    }
                    finally {
                        initializing.remove(this.project);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        JavaCore.addElementChangedListener((IElementChangedListener)new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                if (XtendXpandProject.this.fromJar.isEmpty()) {
                    return;
                }
                if (XtendXpandProject.this.containsRemovedClassPathEntry(event.getDelta().getAffectedChildren())) {
                    XtendXpandProject.this.removeResourcesFromJar();
                }
            }
        }, (int)1);
        Job j = new Job("Initializing " + this.project.getElementName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IProject p = XtendXpandProject.this.project.getProject();
                    if (p.isAccessible() && p.isNatureEnabled(XtendXpandNature.NATURE_ID)) {
                        p.build(15, XtendXpandBuilder.getBUILDER_ID(), new HashMap(), monitor);
                    }
                }
                catch (CoreException e) {
                    XtendLog.logError(e);
                }
                return Status.OK_STATUS;
            }
        };
        j.setRule(this.project.getResource().getWorkspace().getRuleFactory().buildRule());
        j.schedule();
    }

    protected boolean containsRemovedClassPathEntry(IJavaElementDelta[] affectedChildren) {
        int i = 0;
        while (i < affectedChildren.length) {
            IJavaElementDelta delta = affectedChildren[i];
            if ((delta.getFlags() & 0x80) != 0) {
                return true;
            }
            if (this.containsRemovedClassPathEntry(delta.getAffectedChildren())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void removeResourcesFromJar() {
        block0: for (ResourceID id : this.fromJar) {
            for (Map<ResourceID, IXtendXpandResource> values : this.resources.values()) {
                if (values.remove(id) != null) continue block0;
            }
        }
    }

    @Override
    public IXtendXpandResource[] getRegisteredResources() {
        ArrayList<IXtendXpandResource> result = new ArrayList<IXtendXpandResource>();
        int size = 0;
        Collection<Map<ResourceID, IXtendXpandResource>> values = this.resources.values();
        for (Map<ResourceID, IXtendXpandResource> value : values) {
            size += value.values().size();
            result.addAll(value.values());
        }
        return result.toArray(new IXtendXpandResource[size]);
    }

    @Override
    public IXtendXpandResource[] getAllRegisteredResources() {
        HashSet<IXtendXpandResource> result = new HashSet<IXtendXpandResource>();
        result.addAll(Arrays.asList(this.getRegisteredResources()));
        IXtendXpandProject[] iXtendXpandProjectArray = this.getAllReferencedProjects();
        int n = iXtendXpandProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandProject p = iXtendXpandProjectArray[n2];
            result.addAll(Arrays.asList(p.getRegisteredResources()));
            ++n2;
        }
        return result.toArray(new IXtendXpandResource[result.size()]);
    }

    @Override
    public IXtendXpandProject[] getReferencedProjects() {
        HashSet<IXtendXpandProject> result = new HashSet<IXtendXpandProject>();
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = this.getProject().getProject().getReferencedProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IXtendXpandProject p = Activator.getExtXptModelManager().findProject((IResource)project);
                if (p != null) {
                    result.add(p);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        return result.toArray(new IXtendXpandProject[result.size()]);
    }

    @Override
    public IXtendXpandProject[] getAllReferencedProjects() {
        HashSet<IXtendXpandProject> result = new HashSet<IXtendXpandProject>();
        IXtendXpandProject[] projects = this.getReferencedProjects();
        result.addAll(Arrays.asList(projects));
        IXtendXpandProject[] iXtendXpandProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandProject project = iXtendXpandProjectArray[n2];
            result.addAll(Arrays.asList(project.getAllReferencedProjects()));
            ++n2;
        }
        return result.toArray(new IXtendXpandProject[result.size()]);
    }

    @Override
    public IJavaProject getProject() {
        return this.project;
    }

    @Override
    public void unregisterXtendXpandResource(IXtendXpandResource res) {
        if (res != null && res.getUnderlyingStorage() instanceof IFile) {
            IFile file = (IFile)res.getUnderlyingStorage();
            XtendXpandMarkerManager.deleteMarkers((IResource)file);
            for (Map<ResourceID, IXtendXpandResource> values : this.resources.values()) {
                if (values.remove(Activator.findXtendXpandResourceID(this.project, (IStorage)file)) != null) break;
            }
        }
    }

    @Override
    public IXtendXpandResource findExtXptResource(String fqn, String extension) {
        assert (fqn != null);
        assert (extension != null);
        if (Activator.getRegisteredResourceContributorFor(extension) == null) {
            return null;
        }
        IXtendXpandResource res = this.findCachedXtendXpandResource(fqn, extension);
        if (res == NULL_RESOURCE) {
            return null;
        }
        if (res != null) {
            IFile workspaceFile;
            if (res.getUnderlyingStorage() instanceof IFile && !(workspaceFile = (IFile)res.getUnderlyingStorage()).exists()) {
                return null;
            }
            return res;
        }
        res = this.loadXtendXpandResource(fqn, extension, false);
        if (res != null) {
            return res;
        }
        res = this.loadXtendXpandResource(fqn, extension, true);
        if (res == null) {
            HashMap<ResourceID, IXtendXpandResource> map = new HashMap<ResourceID, IXtendXpandResource>();
            map.put(new ResourceID(fqn, extension), NULL_RESOURCE);
            this.resources.put(fqn, map);
        }
        return res;
    }

    private IXtendXpandResource findCachedXtendXpandResource(String fqn, String extension) {
        Map<ResourceID, IXtendXpandResource> map = this.resources.get(fqn);
        if (map != null) {
            if (map.entrySet().size() == 1) {
                return map.values().iterator().next();
            }
            ArrayList<ResourceID> idsWithSameExtension = new ArrayList<ResourceID>();
            for (ResourceID id : map.keySet()) {
                if (!extension.equals(id.extension)) continue;
                idsWithSameExtension.add(id);
            }
            if (idsWithSameExtension.size() == 1) {
                return map.get(idsWithSameExtension.get(0));
            }
            return null;
        }
        ResourceID searchedID = new ResourceID(fqn, extension);
        for (Map<ResourceID, IXtendXpandResource> values : this.resources.values()) {
            if (!values.containsKey(searchedID)) continue;
            return values.get(searchedID);
        }
        return null;
    }

    private IXtendXpandResource loadXtendXpandResource(String fqn, String extension, boolean searchJars) {
        return this.loadXtendXpandResource(fqn, extension, searchJars, new HashSet<XtendXpandProject>(5));
    }

    private IXtendXpandResource loadXtendXpandResource(String fqn, String extension, boolean searchJars, Set<XtendXpandProject> projects) {
        assert (fqn != null);
        assert (extension != null);
        if (!projects.add(this)) {
            return null;
        }
        IStorage storage = Activator.findStorage(this.project, new ResourceID(fqn, extension), searchJars);
        if (storage != null && (searchJars || storage instanceof IFile)) {
            ResourceID jdtResourceID = JDTUtil.findXtendXpandResourceID(this.getProject(), storage);
            Map<ResourceID, IXtendXpandResource> resourcesWithSameResourceID = null;
            if (jdtResourceID != null) {
                resourcesWithSameResourceID = this.resources.get(this.getBaseName(jdtResourceID));
            }
            IXtendXpandResource result = null;
            if (resourcesWithSameResourceID != null) {
                result = (IXtendXpandResource)resourcesWithSameResourceID.get(jdtResourceID);
            }
            if (result != null && result.getUnderlyingStorage() != null) {
                this.cacheXtendXpandResource(storage, result);
                return result;
            }
            String fileExtension = storage.getFullPath().getFileExtension();
            ResourceContributor contr = Activator.getRegisteredResourceContributorFor(fileExtension);
            if (contr != null && (result = contr.create(storage, fqn)) != null) {
                this.cacheXtendXpandResource(storage, result);
                if (!(storage instanceof IFile)) {
                    this.fromJar.add(new ResourceID(fqn, extension));
                }
                return result;
            }
        }
        try {
            IProject[] p = this.project.getProject().getReferencedProjects();
            int i = 0;
            while (i < p.length) {
                IXtendXpandResource result;
                IProject project = p[i];
                XtendXpandProject extxptp = (XtendXpandProject)Activator.getExtXptModelManager().findProject((IResource)project);
                if (extxptp != null && (result = extxptp.loadXtendXpandResource(fqn, extension, searchJars, projects)) != null) {
                    if (storage == null) {
                        storage = result.getUnderlyingStorage();
                    }
                    this.cacheXtendXpandResource(storage, result);
                    return result;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        return null;
    }

    private void cacheXtendXpandResource(IStorage storage, IXtendXpandResource result) {
        String baseName = this.getBaseName(storage);
        Map<ResourceID, IXtendXpandResource> resourcesWithSameBaseName = this.resources.get(baseName);
        if (resourcesWithSameBaseName == null) {
            resourcesWithSameBaseName = new HashMap<ResourceID, IXtendXpandResource>();
            this.resources.put(baseName, resourcesWithSameBaseName);
        }
        resourcesWithSameBaseName.put(Activator.findXtendXpandResourceID(this.project, storage), result);
    }

    private String getBaseName(IStorage storage) {
        return storage.getFullPath().removeFileExtension().lastSegment();
    }

    private String getBaseName(ResourceID id) {
        if (id != null && id.name != null && id.name.length() > 1) {
            int lastIndexOf = id.name.lastIndexOf(":");
            if (lastIndexOf != -1) {
                if (lastIndexOf < id.name.length()) {
                    return id.name.substring(lastIndexOf + 1, id.name.length());
                }
                return null;
            }
            return id.name;
        }
        return null;
    }

    @Override
    public IXtendXpandResource findXtendXpandResource(IStorage file) {
        if (file == null) {
            return null;
        }
        ResourceID id = Activator.findXtendXpandResourceID(this.project, file);
        if (id == null) {
            return null;
        }
        return this.findExtXptResource(id.name, id.extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(IProgressMonitor monitor, ExecutionContext ctx) {
        int size = 0;
        Collection<Map<ResourceID, IXtendXpandResource>> resourceValues = this.resources.values();
        for (Map<ResourceID, IXtendXpandResource> value : resourceValues) {
            size += value.values().size();
        }
        monitor.beginTask("analyzing project " + this.toString(), size);
        Iterator<IXtendXpandResource> iter = Arrays.asList(this.getRegisteredResources()).iterator();
        while (iter.hasNext()) {
            IXtendXpandResource resource;
            if (monitor.isCanceled()) {
                return;
            }
            IXtendXpandResource iXtendXpandResource = resource = iter.next();
            synchronized (iXtendXpandResource) {
                if (!this.isInExternalPackageFragmentRoot(resource)) {
                    resource.analyze(ctx);
                }
            }
            monitor.worked(1);
        }
    }

    private boolean isInExternalPackageFragmentRoot(IXtendXpandResource resource) {
        IStorage underlyingStorage = resource.getUnderlyingStorage();
        IProject containerProject = null;
        if (underlyingStorage instanceof IJarEntryResource) {
            containerProject = ((IJarEntryResource)underlyingStorage).getPackageFragmentRoot().getJavaProject().getProject();
        }
        if (underlyingStorage instanceof IFile) {
            containerProject = ((IFile)underlyingStorage).getProject();
        }
        return containerProject != null && containerProject.isHidden();
    }

    public String toString() {
        return this.project.getPath().toString();
    }
}

