/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import prefuse.data.Graph;
import prefuse.data.io.DataIOException;
import prefuse.data.io.GraphReader;
import prefuse.util.io.IOLib;

public abstract class AbstractGraphReader
implements GraphReader {
    public Graph readGraph(String location) throws DataIOException {
        try {
            InputStream is = IOLib.streamFromString(location);
            if (is == null) {
                throw new DataIOException("Couldn't find " + location + ". Not a valid file, URL, or resource locator.");
            }
            return this.readGraph(is);
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
    }

    public Graph readGraph(URL url) throws DataIOException {
        try {
            return this.readGraph(url.openStream());
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
    }

    public Graph readGraph(File f) throws DataIOException {
        try {
            return this.readGraph(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            throw new DataIOException(e);
        }
    }

    public abstract Graph readGraph(InputStream var1) throws DataIOException;
}

