/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.core;

import java.io.IOException;
import java.lang.constant.Constable;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.core.AbstractDiscoverer;
import org.eclipse.modisco.infra.discovery.core.Messages;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.infra.discovery.core.internal.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelDiscoverer<T>
extends AbstractDiscoverer<T> {
    private static final int FLUSH_LIMIT_SHIFT = 16;
    private static final Integer FLUSH_LIMIT = 65536;
    private URI fDefaultTargetURI = null;
    private Resource fTargetModel;
    private boolean fSerializeTarget;
    private URI fTargetURI;
    private ResourceSet fResourceSet = null;

    @Parameter(name="TARGET_MODEL", requiresInputValue=false, description="A model container; usually an output of the discovery but may also be provided as input.")
    public Resource getTargetModel() {
        return this.fTargetModel;
    }

    @Parameter(name="TARGET_MODEL")
    public void setTargetModel(Resource targetModel) {
        this.fTargetModel = targetModel;
    }

    protected boolean isTargetSerializationChosen() {
        return this.fSerializeTarget;
    }

    @Parameter(name="SERIALIZE_TARGET", requiresInputValue=false, description="Whether to serialize the target model. The save behavior depends on the Discoverer implementation. The standard behavior is to use XMI serialization.")
    public void setSerializeTarget(boolean serializeTarget) {
        this.fSerializeTarget = serializeTarget;
    }

    public URI getTargetURI() {
        return this.fTargetURI;
    }

    @Parameter(name="TARGET_URI", requiresInputValue=false, description="A target location for optional model serialization. Save behavior depends on the Discoverer implementation.")
    public void setTargetURI(URI targetURI) {
        this.fTargetURI = targetURI;
    }

    protected ResourceSet getResourceSet() {
        if (this.fResourceSet == null) {
            this.fResourceSet = new ResourceSetImpl();
        }
        return this.fResourceSet;
    }

    protected void setResourceSet(ResourceSet resourceSet) {
        this.fResourceSet = resourceSet;
    }

    protected Resource createTargetModel() {
        Resource targetModel = this.getTargetModel();
        if (targetModel != null) {
            return targetModel;
        }
        targetModel = new XMIResourceImpl();
        this.getResourceSet().getResources().add((Object)targetModel);
        this.setTargetModel(targetModel);
        return targetModel;
    }

    protected void saveTargetModel() throws IOException {
        if (this.getTargetModel() != null) {
            HashMap<String, Constable> options = new HashMap<String, Constable>();
            options.put("FLUSH_THRESHOLD", FLUSH_LIMIT);
            options.put("USE_FILE_BUFFER", Boolean.TRUE);
            URI targetURI = this.getTargetURI();
            URI defaultURI = this.getDefaultTargetURI();
            Resource targetModel = this.getTargetModel();
            if (targetURI != null && targetURI.toString().trim().length() > 0) {
                targetModel.setURI(targetURI);
            } else if (defaultURI != null) {
                this.getTargetModel().setURI(defaultURI);
            } else if (targetModel.getURI() == null) {
                MoDiscoLogger.logError((String)"Cannot save a Resource without URI. You must pass a valid URI using AbstractModelDiscoverer#setTargetURI", (Plugin)Activator.getDefault());
                return;
            }
            try {
                targetModel.save(options);
            }
            catch (Resource.IOWrappedException e) {
                if (e.getCause() != null && e.getCause() instanceof CoreException) {
                    MoDiscoLogger.logWarning((Throwable)e, (String)("XMI serialization has failed on '" + targetModel.getURI() + "'. Trying again without File Buffer."), (Plugin)Activator.getDefault());
                    options.clear();
                    targetModel.save(options);
                    MoDiscoLogger.logInfo((String)("XMI serialization is done for " + targetModel.getURI()), (Plugin)Activator.getDefault());
                }
                throw e;
            }
        }
    }

    @Override
    public final void discoverElement(T source, IProgressMonitor monitor) throws DiscoveryException {
        super.discoverElement(source, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(Messages.AbstractModelDiscoverer_savingModel);
        if (this.isTargetSerializationChosen()) {
            try {
                this.saveTargetModel();
            }
            catch (Exception e) {
                String message = String.format("The saving step of '%s' failed (targetURI='%s')", this.getClass().getName(), this.getTargetURI());
                MoDiscoLogger.logError((Throwable)e, (String)message, (Plugin)Activator.getDefault());
            }
        }
    }

    protected void setDefaultTargetURI(URI defaultURI) {
        this.fDefaultTargetURI = defaultURI;
    }

    public URI getDefaultTargetURI() {
        return this.fDefaultTargetURI;
    }
}

