/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.edit.core.internal.command;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.modisco.facet.efacet.core.FacetUtils;
import org.eclipse.modisco.facet.efacet.core.IFacetManager;
import org.eclipse.modisco.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.modisco.facet.efacet.edit.core.FacetCommandException;
import org.eclipse.modisco.facet.efacet.edit.core.internal.Activator;
import org.eclipse.modisco.facet.efacet.edit.core.internal.FacetCommandRuntimeException;
import org.eclipse.modisco.facet.util.core.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFacetCommand
extends AbstractOverrideableCommand {
    private final EObject owner;
    private final EStructuralFeature feature;
    private final IFacetManager facetManager;

    public AbstractFacetCommand(EObject owner, EStructuralFeature feature, EditingDomain domain, IFacetManager facetManager, String label, String description) {
        super(domain, label, description);
        this.owner = owner;
        this.feature = feature;
        this.facetManager = facetManager;
    }

    public boolean doCanExecute() {
        boolean result = false;
        try {
            Set features = FacetUtils.getETypedElements((EObject)this.owner, EStructuralFeature.class, (IFacetManager)this.facetManager);
            result = features.contains(this.feature);
        }
        catch (FacetManagerException e) {
            String msg = String.format("\t\t\t\t\tWhen evaluation doCanExecute on %s.%s, the facetManager called return error.", this.owner, this.feature);
            Logger.logError((Throwable)e, (String)msg, (Plugin)Activator.getDefault());
        }
        return result;
    }

    protected Object getCurrentValue() throws FacetCommandException {
        Object result = null;
        if (this.doCanExecute()) {
            try {
                if (!this.feature.isMany()) {
                    result = this.facetManager.getOrInvoke(this.owner, (ETypedElement)this.feature, Object.class);
                }
            }
            catch (FacetManagerException e) {
                throw new FacetCommandException("When getCurrentValue method invoked, the facetManager called return error", e);
            }
        }
        return result;
    }

    protected List<Object> getCurrentValues() throws FacetCommandException {
        List result = null;
        if (this.doCanExecute()) {
            try {
                if (this.feature.isMany()) {
                    result = this.facetManager.getOrInvokeMultiValued(this.owner, (ETypedElement)this.feature, Object.class);
                }
            }
            catch (FacetManagerException e) {
                throw new FacetCommandException("When getCurrentValues method invoked, the facetManager return error", e);
            }
        }
        return result;
    }

    protected void set(Object value) {
        try {
            this.facetManager.set(this.owner, this.feature, value, this.domain);
        }
        catch (FacetManagerException e) {
            String msg = String.format("Can set value %s in the facet, the facetManager return error", value.toString());
            Logger.logError((Throwable)e, (String)msg, (Plugin)Activator.getDefault());
            throw new FacetCommandRuntimeException(msg, e);
        }
    }

    protected EStructuralFeature getFeature() {
        return this.feature;
    }
}

