/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editor.ui.internal.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.modisco.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.modisco.facet.custom.ui.ICustomizationManagerProvider2;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.modisco.facet.efacet.ui.IFacetManagerProvider2;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.infra.browser.editor.ui.internal.Activator;
import org.eclipse.modisco.infra.browser.editor.ui.internal.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeEditorShortcutUtils {
    private TreeEditorShortcutUtils() {
    }

    public static List<ICustomizationManagerProvider2.ICustomShortcut> getCustomShortcuts(ResourceSet resourceSet) {
        ArrayList<ICustomizationManagerProvider2.ICustomShortcut> shortcuts = new ArrayList<ICustomizationManagerProvider2.ICustomShortcut>();
        TreeEditorShortcutUtils.addShortcut(resourceSet, shortcuts, "platform:/plugin/org.eclipse.modisco.facet.ecore.ui/custom/hideDerivedReferences.custom", Messages.TreeEditorShortcutUtils_CustomHideDerivedReferences);
        TreeEditorShortcutUtils.addShortcut(resourceSet, shortcuts, "platform:/plugin/org.eclipse.modisco.facet.ecore.ui/custom/hideEmptyReferences.custom", Messages.TreeEditorShortcutUtils_CustomHideEmptyReferences);
        TreeEditorShortcutUtils.addShortcut(resourceSet, shortcuts, "platform:/plugin/org.eclipse.modisco.facet.ecore.ui/custom/linksCount.custom", Messages.TreeEditorShortcutUtils_CustomShowLinksCount);
        return shortcuts;
    }

    private static void addShortcut(ResourceSet resourceSet, List<ICustomizationManagerProvider2.ICustomShortcut> shortcuts, String uri, String menuItemLabel) {
        try {
            shortcuts.add(TreeEditorShortcutUtils.createCustomShortcut(resourceSet, uri, menuItemLabel));
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    public static List<IFacetManagerProvider2.IFacetSetShortcut> getFacetSetShortcuts(ResourceSet resourceSet) {
        return Collections.emptyList();
    }

    private static ICustomizationManagerProvider2.ICustomShortcut createCustomShortcut(ResourceSet resourceSet, String uriStr, String label) {
        return TreeEditorShortcutUtils.createCustomShortcut(resourceSet, uriStr, label, null);
    }

    private static ICustomizationManagerProvider2.ICustomShortcut createCustomShortcut(ResourceSet resourceSet, String uriStr, final String label, final ImageDescriptor icon) {
        final Customization custom = (Customization)TreeEditorShortcutUtils.getObjectFromURI(uriStr, resourceSet);
        return new ICustomizationManagerProvider2.ICustomShortcut(){

            public String getLabel() {
                return label;
            }

            public Customization getCustom() {
                return custom;
            }

            public ImageDescriptor getIcon() {
                return icon;
            }
        };
    }

    private static IFacetManagerProvider2.IFacetSetShortcut createFacetSetShortcut(ResourceSet resourceSet, String uriStr, String label) {
        return TreeEditorShortcutUtils.createFacetSetShortcut(resourceSet, uriStr, label, null);
    }

    private static IFacetManagerProvider2.IFacetSetShortcut createFacetSetShortcut(ResourceSet resourceSet, String uriStr, final String label, final ImageDescriptor icon) {
        final FacetSet facetSet = (FacetSet)TreeEditorShortcutUtils.getObjectFromURI(uriStr, resourceSet);
        return new IFacetManagerProvider2.IFacetSetShortcut(){

            public String getLabel() {
                return label;
            }

            public FacetSet getFacetSet() {
                return facetSet;
            }

            public ImageDescriptor getIcon() {
                return icon;
            }
        };
    }

    private static EObject getObjectFromURI(String uriStr, ResourceSet resourceSet) {
        URI uri = URI.createURI((String)uriStr);
        Resource resource = resourceSet.getResource(uri, true);
        EList contents = resource.getContents();
        return (EObject)contents.get(0);
    }
}

