/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.facet.core.internal.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.infra.common.core.internal.extensions.AbstractRegistry;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.facet.Facet;
import org.eclipse.modisco.infra.facet.core.extensions.RefreshStrategy;
import org.eclipse.modisco.infra.facet.core.internal.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class RefreshStrategiesRegistry
extends AbstractRegistry {
    private static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.modisco.infra.facet.core";
    private static final String EXTENSION_POINT_NAME = "facetRefreshStrategy";
    private static final String REFRESH_STRATEGY_ELEMENT = "refreshStrategy";
    private static final String CLASS_ATTRIBUTE = "class";
    private static RefreshStrategiesRegistry instance = null;
    private final List<RefreshStrategy> strategies = new ArrayList<RefreshStrategy>();

    public static RefreshStrategiesRegistry getInstance() {
        if (instance == null) {
            instance = new RefreshStrategiesRegistry();
        }
        return instance;
    }

    public RefreshStrategiesRegistry() {
        this.initialize();
    }

    public List<RefreshStrategy> getRefreshStrategies(Collection<Facet> facets) {
        ArrayList<RefreshStrategy> applicableStrategies = new ArrayList<RefreshStrategy>();
        block0: for (RefreshStrategy strategy : this.strategies) {
            for (Facet facet : facets) {
                if (!strategy.isApplicableTo(facet)) continue;
                applicableStrategies.add(strategy);
                continue block0;
            }
        }
        return applicableStrategies;
    }

    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    protected String getExtensionPointNamespace() {
        return EXTENSION_POINT_NAMESPACE;
    }

    protected void handleRootElement(IConfigurationElement configurationElement) {
        String name = configurationElement.getName();
        if (name.equalsIgnoreCase(REFRESH_STRATEGY_ELEMENT)) {
            this.readRefreshStrategyElement(configurationElement);
        } else {
            this.logUnknownElement(configurationElement);
        }
    }

    private void readRefreshStrategyElement(IConfigurationElement configurationElement) {
        Object refreshStrategyObject;
        try {
            refreshStrategyObject = configurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return;
        }
        if (refreshStrategyObject == null) {
            this.logMissingAttribute(configurationElement, CLASS_ATTRIBUTE);
            return;
        }
        if (refreshStrategyObject instanceof RefreshStrategy) {
            RefreshStrategy refreshStrategy = (RefreshStrategy)refreshStrategyObject;
            this.strategies.add(refreshStrategy);
        } else {
            this.logError(configurationElement, "a class implementing RefreshStrategy is expected");
        }
    }
}

