/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.internal.io.java;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractTypeDeclaration;
import org.eclipse.gmt.modisco.java.BodyDeclaration;
import org.eclipse.gmt.modisco.java.ClassDeclaration;
import org.eclipse.gmt.modisco.java.ClassInstanceCreation;
import org.eclipse.gmt.modisco.java.MethodDeclaration;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.SingleVariableDeclaration;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;
import org.eclipse.gmt.modisco.java.internal.util.JavaUtil;

public final class MethodRedefinitionManager {
    private MethodRedefinitionManager() {
    }

    public static void resolveMethodRedefinitions(Model model, JavaFactory facto) {
        TreeIterator i = model.eAllContents();
        while (i.hasNext()) {
            ClassInstanceCreation cic;
            MethodDeclaration aMethod;
            Object item = i.next();
            if (!(item instanceof MethodDeclaration) || (aMethod = (MethodDeclaration)item).isProxy()) continue;
            String signature = MethodRedefinitionManager.getRawSignature(aMethod);
            TypeAccess superClassRef = null;
            AbstractTypeDeclaration declaringType = aMethod.getAbstractTypeDeclaration();
            if (declaringType != null && declaringType instanceof ClassDeclaration) {
                superClassRef = ((ClassDeclaration)declaringType).getSuperClass();
            }
            if (declaringType == null && aMethod.getAnonymousClassDeclarationOwner() != null && (cic = aMethod.getAnonymousClassDeclarationOwner().getClassInstanceCreation()) != null) {
                superClassRef = cic.getType();
            }
            boolean bFound = false;
            while (!bFound && superClassRef != null && superClassRef.getType() instanceof ClassDeclaration) {
                ClassDeclaration superClass = (ClassDeclaration)superClassRef.getType();
                for (BodyDeclaration bodyDecl : superClass.getBodyDeclarations()) {
                    if (!(bodyDecl instanceof MethodDeclaration) || !signature.equals(MethodRedefinitionManager.getRawSignature((MethodDeclaration)bodyDecl))) continue;
                    bFound = true;
                    aMethod.setRedefinedMethodDeclaration((MethodDeclaration)bodyDecl);
                }
                superClassRef = superClass.getSuperClass();
            }
        }
    }

    private static String getRawSignature(MethodDeclaration aMethod) {
        String signature = aMethod.getName();
        for (SingleVariableDeclaration aParam : aMethod.getParameters()) {
            signature = String.valueOf(signature) + "|";
            signature = String.valueOf(signature) + MethodRedefinitionManager.getRawSignature(aParam.getType());
            if (!aParam.isVarargs()) continue;
            signature = String.valueOf(signature) + "...";
        }
        return signature;
    }

    private static String getRawSignature(TypeAccess typeRef) {
        String signature = typeRef.getType() instanceof AbstractTypeDeclaration ? JavaUtil.getQualifiedName((ASTNode)typeRef.getType(), (boolean)true) : typeRef.getType().getName();
        return signature;
    }
}

