/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.jsp.discoverer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.jee.jsp.Model;
import org.eclipse.modisco.jee.jsp.discoverer.AbstractJspDiscoverer;
import org.eclipse.modisco.jee.jsp.discoverer.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverJspModelFromJavaElement
extends AbstractJspDiscoverer<IJavaElement> {
    public static final String ID = "org.eclipse.modisco.jee.jsp.discoverer.javaElement";

    public boolean isApplicableTo(IJavaElement javaElement) {
        if (javaElement instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)javaElement;
            return javaProject.exists() && javaProject.getProject() != null && javaProject.getProject().exists();
        }
        if (javaElement instanceof IPackageFragment) {
            IPackageFragment packageFragment = (IPackageFragment)javaElement;
            return packageFragment.exists() && packageFragment.getResource().exists() && packageFragment.getResource() instanceof IContainer;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void basicDiscoverElement(IJavaElement javaElement, IProgressMonitor monitor) throws DiscoveryException {
        monitor.beginTask(Messages.discoveringJspModel, -1);
        Model model = DiscoverJspModelFromJavaElement.getEFactory().createModel();
        Resource targetModel = this.createTargetModel();
        targetModel.getContents().add((Object)model);
        if (javaElement instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)javaElement;
            IProject project = javaProject.getProject();
            this.setDefaultTargetURI(URI.createPlatformResourceURI((String)project.getFullPath().append(project.getName()).toString().concat("_jsp.xmi"), (boolean)true));
            DiscoverJspModelFromJavaElement.discoverDirectory(project.getLocation().toFile(), model);
            return;
        } else {
            if (!(javaElement instanceof IPackageFragment)) throw new IllegalArgumentException("Unhandled input");
            IPackageFragment packageFragment = (IPackageFragment)javaElement;
            IResource resource = packageFragment.getResource();
            if (!(resource instanceof IContainer)) throw new IllegalArgumentException("Not a container");
            IContainer container = (IContainer)resource;
            this.setDefaultTargetURI(URI.createPlatformResourceURI((String)container.getFullPath().append(container.getName()).toString().concat("_jsp.xmi"), (boolean)true));
            DiscoverJspModelFromJavaElement.discoverDirectory(container.getLocation().toFile(), model);
        }
    }
}

