/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.queries;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.modisco.infra.browser.queries.SelectedQueriesManager;
import org.eclipse.modisco.infra.browser.uicore.internal.Activator;
import org.eclipse.modisco.infra.browser.uicore.internal.Messages;
import org.eclipse.modisco.infra.browser.uicore.internal.util.EMFUtil;
import org.eclipse.modisco.infra.browser.uicore.internal.util.QueryUtil;
import org.eclipse.modisco.infra.browser.uicore.internal.util.Util;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.query.ModelQuery;
import org.eclipse.osgi.util.NLS;

public class SelectedQuery {
    private final ModelQuery modelQuery;
    private final EObject context;
    private boolean executed = false;
    private Object result;
    private final SelectedQueriesManager selectedQueriesManager;

    public SelectedQuery(ModelQuery modelQuery, EObject context, SelectedQueriesManager selectedQueriesManager) {
        this.modelQuery = modelQuery;
        this.context = context;
        this.selectedQueriesManager = selectedQueriesManager;
    }

    public void executeQuery() {
        if (EMFUtil.tryResolve((EObject)this.modelQuery)) {
            this.result = QueryUtil.basicEvaluate((ModelQuery)this.modelQuery, (EObject)this.context);
            this.executed = true;
            this.selectedQueriesManager.fireChangeNotification();
        } else {
            MoDiscoLogger.logError((String)NLS.bind((String)Messages.unresolvedQuery, (Object)EMFUtil.proxyURI((EObject)this.modelQuery)), (Plugin)Activator.getDefault());
        }
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public Object getResult() {
        if (!this.isExecuted()) {
            this.executeQuery();
        }
        return this.result;
    }

    public ModelQuery getModelQuery() {
        return this.modelQuery;
    }

    public EObject getContext() {
        return this.context;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SelectedQuery) {
            SelectedQuery other = (SelectedQuery)obj;
            return Util.safeEquals((Object)this.modelQuery, (Object)other.modelQuery) && Util.safeEquals((Object)this.context, (Object)other.context);
        }
        return false;
    }

    public int hashCode() {
        int hashPrime1 = 47;
        int hashPrime2 = 13;
        int queryHashCode = this.modelQuery.hashCode() + 13;
        if (this.context != null) {
            return this.context.hashCode() * 47 + queryHashCode;
        }
        return queryHashCode;
    }
}

