/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.filter;

import java.util.Iterator;
import prefuse.Visualization;
import prefuse.action.GroupAction;
import prefuse.data.expression.OrPredicate;
import prefuse.data.expression.Predicate;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.VisiblePredicate;

public class VisibilityFilter
extends GroupAction {
    private Predicate m_filter;
    private Predicate m_predicate;

    public VisibilityFilter(Predicate p) {
        this.setPredicate(p);
    }

    public VisibilityFilter(String group, Predicate p) {
        super(group);
        this.setPredicate(p);
    }

    public VisibilityFilter(Visualization vis, String group, Predicate p) {
        super(vis, group);
        this.setPredicate(p);
    }

    protected void setPredicate(Predicate p) {
        this.m_predicate = p;
        this.m_filter = new OrPredicate(p, VisiblePredicate.TRUE);
    }

    public void run(double frac) {
        Iterator items = this.m_vis.items(this.m_group, this.m_filter);
        while (items.hasNext()) {
            VisualItem item = (VisualItem)items.next();
            PrefuseLib.updateVisible(item, this.m_predicate.getBoolean(item));
        }
    }
}

