/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.dynamic.ExplicitClassLoader;
import org.eclipse.ocl.examples.codegen.dynamic.JavaClasspath;
import org.eclipse.ocl.examples.codegen.dynamic.JavaFileUtil;
import org.eclipse.ocl.examples.codegen.genmodel.OCLGenModelUtil;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCase;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.evaluation.AbstractModelManager;
import org.eclipse.ocl.pivot.internal.evaluation.AbstractExecutor;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorManager;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibPackage;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.AbstractEnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.uml2.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.uml2.types.TypesPackage;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ecore.importer.UMLImporter;
import org.eclipse.uml2.uml.editor.presentation.UMLEditor;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.util.EmfFormatter;
import org.osgi.framework.Bundle;

public class UsageTests
extends PivotTestSuite {
    public Logger log;

    public void checkResourceSet(@NonNull ResourceSet resourceSet) throws ConfigurationException {
        int errorCount = 0;
        for (Resource aResource : resourceSet.getResources()) {
            EList warnings;
            EList errors = aResource.getErrors();
            if (errors.size() > 0) {
                for (Resource.Diagnostic error : errors) {
                    if (error instanceof ExceptionDiagnostic) {
                        this.log.error((Object)("Error for '" + aResource.getURI() + "'"), (Throwable)((ExceptionDiagnostic)error).getException());
                    } else {
                        this.log.error((Object)(error + " for '" + aResource.getURI() + "'"));
                    }
                    ++errorCount;
                }
            }
            if ((warnings = aResource.getWarnings()).size() <= 0) continue;
            for (Resource.Diagnostic warning : warnings) {
                if (warning instanceof ExceptionDiagnostic) {
                    this.log.warn((Object)("Warning for '" + aResource.getURI() + "'"), (Throwable)((ExceptionDiagnostic)warning).getException());
                    continue;
                }
                this.log.warn((Object)(warning + " for '" + aResource.getURI() + "'"));
            }
        }
        if (errorCount > 0) {
            throw new RuntimeException(String.valueOf(errorCount) + " errors in ResourceSet");
        }
    }

    @Override
    protected @NonNull TestOCL createOCL() {
        return new TestOCL(this.getTestFileSystem(), this.getTestPackageName(), this.getName(), this.getTestProjectManager(), null);
    }

    protected @NonNull URI getModelsURI(@NonNull String filePath) {
        return URI.createPlatformResourceURI((String)(String.valueOf(this.getTestBundleName()) + "/models/" + filePath), (boolean)true);
    }

    @Override
    protected @NonNull File getProjectFile() {
        return this.getTestProject().getFile();
    }

    @Override
    protected @NonNull URI getProjectFileURI(@NonNull String referenceName) {
        return this.getTestFileURI(referenceName);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.log = Logger.getLogger(UsageTests.class);
        TestUtil.doOCLinEcoreSetup();
        UsageTests.configurePlatformResources();
    }

    @Override
    protected void tearDown() throws Exception {
        ThreadLocalExecutor.waitForGC();
        this.log = null;
        this.uninstall();
        super.tearDown();
    }

    public static @NonNull String createClassPath(@NonNull List<String> projectNames) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String pathSeparator = null;
        StringBuilder s = new StringBuilder();
        for (String projectName : projectNames) {
            URI uri;
            Bundle bundle;
            IPath location;
            String projectPath = null;
            IProject project = root.getProject(projectName);
            if (project != null && (location = project.getLocation()) != null) {
                projectPath = String.valueOf(location.toString()) + "/";
            }
            if (projectPath == null && (bundle = Platform.getBundle((String)projectName)) != null) {
                projectPath = bundle.getLocation();
            }
            if (projectPath == null) continue;
            if (projectPath.startsWith("reference:")) {
                projectPath = projectPath.substring(10);
            }
            if ((uri = URI.createURI((String)projectPath)).isFile()) {
                String fileString = uri.toFileString();
                assert (fileString != null);
                projectPath = fileString.replace("\\", "/");
            }
            assert (projectPath != null);
            if (projectPath.endsWith("/")) {
                projectPath = String.valueOf(projectPath) + "test-bin";
            }
            if (pathSeparator != null) {
                s.append(pathSeparator);
            } else {
                pathSeparator = System.getProperty("path.separator");
            }
            s.append(projectPath);
        }
        return s.toString();
    }

    public @NonNull String createEcoreGenModelContent(@NonNull String fileName, @Nullable Map<@NonNull String, @Nullable String> genOptions) throws Exception {
        String templateDirectory;
        String interfacePackageSuffix = genOptions != null ? genOptions.get("interfacePackageSuffix") : null;
        String metaDataPackageSuffix = genOptions != null ? genOptions.get("metaDataPackageSuffix") : null;
        String usedGenPackages = genOptions != null ? genOptions.get("usedGenPackages") : null;
        String modelDirectory = genOptions != null ? genOptions.get("modelDirectory") : null;
        String dynamicTemplates = genOptions != null ? genOptions.get("dynamicTemplates") : null;
        String string = templateDirectory = genOptions != null ? genOptions.get("templateDirectory") : null;
        if (modelDirectory == null) {
            modelDirectory = String.valueOf(this.getTestProject().getName()) + "/" + "test-src";
        }
        StringBuilder s = new StringBuilder();
        s.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        s.append("<genmodel:GenModel xmi:version=\"2.0\"\n");
        s.append("    xmlns:xmi=\"http://www.omg.org/XMI\"\n");
        s.append("    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\"\n");
        s.append("    xmlns:genmodel=\"http://www.eclipse.org/emf/2002/GenModel\"\n");
        s.append("    modelDirectory=\"/" + modelDirectory + "\"\n");
        s.append("    modelPluginID=\"" + fileName + "\"\n");
        s.append("    modelName=\"" + fileName + "\"\n");
        s.append("    importerID=\"org.eclipse.emf.importer.ecore\"\n");
        s.append("    complianceLevel=\"8.0\"\n");
        s.append("    operationReflection=\"true\"\n");
        s.append("    copyrightFields=\"false\"\n");
        s.append("    bundleManifest=\"false\"\n");
        s.append("    pluginKey=\"\"\n");
        if (dynamicTemplates != null) {
            s.append("    dynamicTemplates=\"" + dynamicTemplates + "\"\n");
        }
        if (templateDirectory != null) {
            s.append("    templateDirectory=\"" + templateDirectory + "\"\n");
        }
        s.append("    usedGenPackages=\"");
        if (usedGenPackages != null) {
            s.append(String.valueOf(usedGenPackages) + " ");
        }
        s.append("platform:/resource/org.eclipse.ocl.pivot/model/oclstdlib.genmodel#//oclstdlib\"\n");
        s.append("    updateClasspath=\"false\">\n");
        s.append("  <genAnnotations source=\"http://www.eclipse.org/OCL/GenModel\">\n");
        s.append("    <details key=\"Use Delegates\" value=\"false\"/>\n");
        s.append("    <details key=\"Use Null Annotations\" value=\"true\"/>\n");
        s.append("  </genAnnotations>\n");
        s.append("  <foreignModel>" + fileName + ".ecore</foreignModel>\n");
        s.append("  <genPackages prefix=\"" + fileName + "\"\n");
        s.append("    disposableProviderFactory=\"true\"\n");
        s.append("    ecorePackage=\"" + fileName + ".ecore#/\"\n");
        if (interfacePackageSuffix != null) {
            s.append("    interfacePackageSuffix=\"" + interfacePackageSuffix + "\"\n");
        }
        if (metaDataPackageSuffix != null) {
            s.append("    metaDataPackageSuffix=\"" + metaDataPackageSuffix + "\"\n");
        }
        s.append("  />\n");
        s.append("</genmodel:GenModel>\n");
        s.append("\n");
        return s.toString();
    }

    public void createManifestFile() throws IOException {
        String bundleName = "_" + this.getTestProject().getName();
        TestFile testFile = this.getTestProject().getOutputFile("META-INF/MANIFEST.MF");
        File file = testFile.getFile();
        FileWriter writer = new FileWriter(file);
        ((Writer)writer).append("Manifest-Version: 1.0\n");
        ((Writer)writer).append("Bundle-ManifestVersion: 2\n");
        ((Writer)writer).append("Bundle-Name: " + bundleName + "\n");
        ((Writer)writer).append("Bundle-SymbolicName: " + bundleName + ";singleton:=true\n");
        ((Writer)writer).append("Bundle-Version: 1.0.0.qualifier\n");
        ((Writer)writer).close();
    }

    protected @NonNull URI createModels(@NonNull String testFileStem, @Nullable String oclinecoreFile, @NonNull String genmodelContent) throws Exception {
        OCL ocl2 = OCL.newInstance((ProjectManager)this.getTestProjectManager());
        try {
            URI genModelURI;
            if (oclinecoreFile != null) {
                this.createEcoreFile(ocl2, testFileStem, oclinecoreFile);
            }
            URI uRI = genModelURI = this.createTestFileWithContent(this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".genmodel"), genmodelContent);
            return uRI;
        }
        finally {
            ocl2.dispose();
        }
    }

    public @NonNull URI createTestFileWithContent(@NonNull TestFile testFile, String fileContent) throws IOException {
        File file = testFile.getFile();
        FileWriter writer = new FileWriter(file);
        ((Writer)writer).append(fileContent);
        ((Writer)writer).close();
        return testFile.getURI();
    }

    public @NonNull String createUMLEcoreModelContent(@NonNull Resource umlProfileResource) throws Exception {
        StringBuilder s = new StringBuilder();
        s.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        s.append("<xmi:XMI xmi:version=\"2.0\"\n");
        s.append("    xmlns:xmi=\"http://www.omg.org/XMI\"\n");
        s.append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        s.append("    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\">\n");
        for (EObject eRootObject : umlProfileResource.getContents()) {
            if (eRootObject instanceof Model) {
                for (Package umlPackage : ((Model)eRootObject).getNestedPackages()) {
                    assert (umlPackage != null);
                    this.appendEcorePackage(s, umlPackage);
                }
                continue;
            }
            if (!(eRootObject instanceof Package)) continue;
            this.appendEcorePackage(s, (Package)eRootObject);
        }
        s.append("</xmi:XMI>\n");
        return s.toString();
    }

    private void appendEcorePackage(@NonNull StringBuilder s, @NonNull Package umlPackage) {
        Stereotype ecoreStereotype = umlPackage.getAppliedStereotype("Ecore::EPackage");
        String basePackage = (String)umlPackage.getValue(ecoreStereotype, "basePackage");
        String nsPrefix = (String)umlPackage.getValue(ecoreStereotype, "nsPrefix");
        String nsURI = (String)umlPackage.getValue(ecoreStereotype, "nsURI");
        String packageName = (String)umlPackage.getValue(ecoreStereotype, "packageName");
        String prefix = (String)umlPackage.getValue(ecoreStereotype, "prefix");
        s.append("  <ecore:EPackage");
        s.append(" name=\"" + (packageName != null ? packageName : umlPackage.getName()) + "\"");
        if (basePackage != null) {
            s.append(" basePackage=\"" + basePackage + "\"");
        }
        if (nsPrefix != null) {
            s.append(" nsPrefix=\"" + nsPrefix + "\"");
        }
        if (nsURI != null) {
            s.append(" nsURI=\"" + nsURI + "\"");
        }
        if (prefix != null) {
            s.append(" prefix=\"" + prefix + "\"");
        }
        s.append(">\n");
        s.append("    <eClassifiers xsi:type=\"ecore:EClass\" name=\"Dummy\"/>\n");
        s.append("  </ecore:EPackage>\n");
    }

    public @NonNull String createUMLGenModelContent(@NonNull Resource umlProfileResource, @NonNull String fileName, @Nullable Map<@NonNull String, @Nullable String> genOptions) throws Exception {
        String templateDirectory;
        String interfacePackageSuffix = genOptions != null ? genOptions.get("interfacePackageSuffix") : null;
        String metaDataPackageSuffix = genOptions != null ? genOptions.get("metaDataPackageSuffix") : null;
        String usedGenPackages = genOptions != null ? genOptions.get("usedGenPackages") : null;
        String modelDirectory = genOptions != null ? genOptions.get("modelDirectory") : null;
        String dynamicTemplates = genOptions != null ? genOptions.get("dynamicTemplates") : null;
        String string = templateDirectory = genOptions != null ? genOptions.get("templateDirectory") : null;
        if (modelDirectory == null) {
            modelDirectory = String.valueOf(this.getTestProject().getName()) + "/" + "test-src";
        }
        StringBuilder s = new StringBuilder();
        s.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        s.append("<genmodel:GenModel xmi:version=\"2.0\"\n");
        s.append("    xmlns:xmi=\"http://www.omg.org/XMI\"\n");
        s.append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        s.append("    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\"\n");
        s.append("    xmlns:genmodel=\"http://www.eclipse.org/uml2/2.2.0/GenModel\"\n");
        s.append("    modelDirectory=\"/" + modelDirectory + "\"\n");
        s.append("    modelPluginID=\"" + fileName + "\"\n");
        s.append("    modelName=\"" + fileName + "\"\n");
        s.append("    importerID=\"org.eclipse.uml2.uml.ecore.importer\"\n");
        s.append("    complianceLevel=\"8.0\"\n");
        s.append("    operationReflection=\"true\"\n");
        s.append("    copyrightFields=\"false\"\n");
        s.append("    bundleManifest=\"false\"\n");
        s.append("    pluginKey=\"\"\n");
        if (dynamicTemplates != null) {
            s.append("    dynamicTemplates=\"" + dynamicTemplates + "\"\n");
        }
        if (templateDirectory != null) {
            s.append("    templateDirectory=\"" + templateDirectory + "\"\n");
        }
        s.append("    updateClasspath=\"false\">\n");
        s.append("  <genAnnotations source=\"http://www.eclipse.org/emf/2002/GenModel/importer/org.eclipse.uml2.uml.ecore.importer\">\n");
        s.append("    <details key=\"OPPOSITE_ROLE_NAMES\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"DUPLICATE_FEATURES\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"ANNOTATION_DETAILS\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"PROPERTY_DEFAULT_EXPRESSIONS\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"DUPLICATE_FEATURE_INHERITANCE\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"COMMENTS\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"DERIVED_FEATURES\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"SUPER_CLASS_ORDER\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"DUPLICATE_OPERATION_INHERITANCE\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"REDEFINING_OPERATIONS\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"INVARIANT_CONSTRAINTS\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"UNION_PROPERTIES\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"DUPLICATE_OPERATIONS\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"NON_API_INVARIANTS\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"CAMEL_CASE_NAMES\" value=\"IGNORE\"/>\n");
        s.append("    <details key=\"SUBSETTING_PROPERTIES\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"OPERATION_BODIES\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"ECORE_TAGGED_VALUES\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"UNTYPED_PROPERTIES\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"REDEFINING_PROPERTIES\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"INVOCATION_DELEGATES\" value=\"PROCESS\"/>\n");
        s.append("    <details key=\"VALIDATION_DELEGATES\" value=\"PROCESS\"/>\n");
        s.append("  </genAnnotations>\n");
        s.append("  <genAnnotations source=\"http://www.eclipse.org/OCL/GenModel\">\n");
        s.append("    <details key=\"Use Delegates\" value=\"false\"/>\n");
        s.append("    <details key=\"Use Null Annotations\" value=\"true\"/>\n");
        s.append("  </genAnnotations>\n");
        s.append("  <foreignModel>" + umlProfileResource.getURI().lastSegment() + "</foreignModel>\n");
        for (EObject eRootObject : umlProfileResource.getContents()) {
            if (eRootObject instanceof Model) {
                for (Package umlPackage : ((Model)eRootObject).getNestedPackages()) {
                    assert (umlPackage != null);
                    this.appendGenModelPackage(s, umlPackage, interfacePackageSuffix, metaDataPackageSuffix, fileName);
                }
                continue;
            }
            if (!(eRootObject instanceof Package)) continue;
            this.appendGenModelPackage(s, (Package)eRootObject, interfacePackageSuffix, metaDataPackageSuffix, fileName);
        }
        if (usedGenPackages != null) {
            String[] stringArray = usedGenPackages.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object usedGenPackage = stringArray[n2];
                s.append("  <usedGenPackages href=\"" + (String)usedGenPackage + "\"/>\\n");
                ++n2;
            }
        }
        s.append("  <usedGenPackages href=\"platform:/resource/org.eclipse.emf.ecore/model/Ecore.genmodel#//ecore\"/>\n");
        s.append("  <usedGenPackages href=\"platform:/resource/org.eclipse.uml2.types/model/Types.genmodel#//types\"/>\n");
        s.append("  <usedGenPackages href=\"platform:/resource/org.eclipse.uml2.uml/model/UML.genmodel#//uml\"/>\n");
        s.append("</genmodel:GenModel>\n");
        return s.toString();
    }

    private void appendGenModelPackage(StringBuilder s, @NonNull Package umlPackage, String interfacePackageSuffix, String metaDataPackageSuffix, @NonNull String fileStem) {
        String packageName = umlPackage.getName();
        s.append("  <genPackages xsi:type=\"genmodel:GenPackage\" prefix=\"" + packageName + "\"\n");
        s.append("    disposableProviderFactory=\"true\"\n");
        s.append("    ecorePackage=\"" + fileStem + ".profile.ecore#/\"\n");
        s.append("    basePackage=\"" + fileStem + "\"\n");
        if (interfacePackageSuffix != null) {
            s.append("    interfacePackageSuffix=\"" + interfacePackageSuffix + "\"\n");
        }
        if (metaDataPackageSuffix != null) {
            s.append("    metaDataPackageSuffix=\"" + metaDataPackageSuffix + "\"\n");
        }
        s.append("  />\n");
    }

    protected boolean doCompile(@NonNull OCL ocl, @NonNull JavaClasspath classpath, String ... testProjectNames) throws Exception {
        ArrayList<@NonNull E> compilationUnits = new ArrayList();
        StringBuilder sources = new StringBuilder();
        if (testProjectNames != null) {
            String[] stringArray = testProjectNames;
            int n = testProjectNames.length;
            int n2 = 0;
            while (n2 < n) {
                String testProjectName = stringArray[n2];
                TestFile srcTestFile = this.getTestProject().getOutputFile("test-src/" + testProjectName);
                JavaFileUtil.gatherCompilationUnits(compilationUnits, (File)srcTestFile.getFile());
                if (sources.length() > 0) {
                    sources.append(", ");
                }
                sources.append(srcTestFile.getFileString());
                ++n2;
            }
        }
        String objectPath = this.getTestProject().getOutputFile("test-bin/").getFileString();
        classpath.addClass(((Object)((Object)this)).getClass());
        String problemMessage = JavaFileUtil.compileClasses(compilationUnits, (String)sources.toString(), (String)objectPath, (JavaClasspath)classpath);
        if (problemMessage != null) {
            UsageTests.fail((String)problemMessage);
        }
        return true;
    }

    protected boolean doEcoreCompile(@NonNull OCL ocl, String ... testProjectNames) throws Exception {
        JavaClasspath classpath = JavaFileUtil.createDefaultOCLClasspath();
        return this.doCompile(ocl, classpath, testProjectNames);
    }

    protected void doGenModel(@NonNull URI genmodelURI) throws Exception {
        TestOCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        try {
            BasicMonitor monitor;
            URI fileURI = genmodelURI;
            ProjectManager projectMap = ocl.getProjectManager();
            projectMap.configure(resourceSet, StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
            resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage.eINSTANCE);
            resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/2.2.0/GenModel", (Object)GenModelPackage.eINSTANCE);
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("genmodel", new EcoreResourceFactoryImpl());
            OCLGenModelUtil.initializeGeneratorAdapterFactoryRegistry();
            Resource resource = resourceSet.getResource(fileURI, true);
            this.checkResourceSet(resourceSet);
            EObject eObject = (EObject)resource.getContents().get(0);
            if (!(eObject instanceof GenModel)) {
                throw new ConfigurationException("No GenModel found in '" + resource.getURI() + "'");
            }
            GenModel genModel = (GenModel)eObject;
            genModel.reconcile();
            this.checkResourceSet(resourceSet);
            genModel.setValidateModel(true);
            genModel.setForceOverwrite(false);
            genModel.setCanGenerate(true);
            genModel.setBundleManifest(false);
            genModel.setUpdateClasspath(false);
            Diagnostic diagnostic = genModel.diagnose();
            if (diagnostic.getSeverity() != 0) {
                String s = PivotUtil.formatDiagnostics((Diagnostic)diagnostic, (String)"\n");
                UsageTests.fail((String)("Diagnose failure " + s));
            }
            String oldGenModelStr = EmfFormatter.objToStr((Object)genModel, (EStructuralFeature[])new EStructuralFeature[0]);
            Generator generator = GenModelUtil.createGenerator((GenModel)genModel);
            diagnostic = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)(monitor = new BasicMonitor()));
            if (diagnostic.getSeverity() != 0) {
                String s = PivotUtil.formatDiagnostics((Diagnostic)diagnostic, (String)"\n");
                UsageTests.fail((String)("Generation failure" + s));
            }
            genModel.reconcile();
            String newGenModelStr = EmfFormatter.objToStr((Object)genModel, (EStructuralFeature[])new EStructuralFeature[0]);
            TestCase.assertEquals((String)oldGenModelStr, (String)newGenModelStr);
        }
        finally {
            ocl.dispose();
            ocl = null;
            UsageTests.unloadResourceSet(resourceSet);
            boolean waitedOK = ThreadLocalExecutor.waitForGC();
            UsageTests.assertTrue((boolean)waitedOK);
        }
    }

    protected EPackage doLoadPackage(@NonNull ExplicitClassLoader classLoader, @NonNull String qualifiedModelPackageName) throws Exception {
        Class testClass = classLoader.loadClass(qualifiedModelPackageName);
        Object eInstance = testClass.getDeclaredField("eINSTANCE").get(null);
        return (EPackage)eInstance;
    }

    protected void doUMLCompile(@NonNull TestOCL ocl, @NonNull String testProjectName) throws Exception {
        JavaClasspath classpath = JavaFileUtil.createDefaultOCLClasspath();
        classpath.addClass(TypesPackage.class);
        classpath.addClass(UMLPackage.class);
        this.doCompile((OCL)ocl, classpath, testProjectName);
    }

    @Override
    protected void initializeResourceSet() {
        resourceSet = null;
    }

    protected @NonNull Resource loadUmlProfile(@NonNull ResourceSet resourceSet, @NonNull URI umlProfileURI) {
        UMLResourcesUtil.init((ResourceSet)resourceSet);
        Resource umlProfileResource = resourceSet.getResource(umlProfileURI, true);
        assert (umlProfileResource != null);
        UsageTests.assertNoResourceErrors("Profile load", umlProfileResource);
        UsageTests.assertNoValidationErrors("Profile validation", umlProfileResource);
        return umlProfileResource;
    }

    protected @NonNull Resource validateUmlModel(@NonNull URI umlModelURI, @NonNull String qualifiedPackageClassName, @NonNull String pathMapName, @Nullable Map<URI, URI> extraUriMap) throws Exception, IllegalAccessException {
        File projectFile = this.getTestProject().getFile();
        File explicitClassPath = new File(projectFile, "test-bin");
        URL url = explicitClassPath.toURI().toURL();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{url}, ((Object)((Object)this)).getClass().getClassLoader());
        Class<?> packageImplClass = urlClassLoader.loadClass(qualifiedPackageClassName);
        Field field = packageImplClass.getField("eINSTANCE");
        EPackage packageImpl = (EPackage)field.get(null);
        assert (packageImpl != null);
        String nsURI = packageImpl.getNsURI();
        EPackage.Registry.INSTANCE.remove((Object)nsURI);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        UMLResourcesUtil.init((ResourceSet)resourceSet);
        resourceSet.getPackageRegistry().put((Object)nsURI, (Object)packageImpl);
        URI pathMapURI = URI.createURI((String)pathMapName, (boolean)true);
        URI profileFolderURI = umlModelURI.trimSegments(1).appendSegment("");
        Map uriMap = resourceSet.getURIConverter().getURIMap();
        uriMap.put(pathMapURI, profileFolderURI);
        if (extraUriMap != null) {
            uriMap.putAll(extraUriMap);
        }
        Resource umlModelResource = resourceSet.getResource(umlModelURI, true);
        assert (umlModelResource != null);
        UsageTests.assertNoResourceErrors("Model load", umlModelResource);
        UsageTests.assertNoValidationErrors("Model validation", umlModelResource);
        urlClassLoader.close();
        return umlModelResource;
    }

    public void testBug370824() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "Bug370824";
                String testProjectName = "bug370824";
                String oclinecoreFile = "package bug370824 : bug370824 = 'http://bug370824'\n{\n    class Clase1\n    {\n        invariant : self.name.size() > 0;\n        attribute name : String[?] { ordered };\n    }\n}\n";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent("Bug370824", null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                ocl.dispose();
            }
        });
    }

    public void testBug409650() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "Bug409650";
                String testProjectName = "bug409650";
                String oclinecoreFile = "package bug409650 : bug409650 = 'http://bug409650'\n{\n    class Clase1\n    {\n        invariant : self.name.size() > 0;\n        attribute name : String[?] { ordered };\n        operation copy(b : Boolean) : Boolean { body: b; }\n        operation complement(b : Boolean) : Boolean { body: not b; }\n        operation myPrefixedName(s1 : String, s2 : String) : String { body: s1 + name + s2; }\n        operation me() : Clase1 { body: self.oclAsType(Clase1); }\n    }\n}\n";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent("Bug409650", null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                String qualifiedPackageName = String.valueOf(testProjectName) + "." + testFileStem + "Package";
                File classFilePath = UsageTests.this.getTestProject().getOutputFolder("test-bin/").getFile();
                @NonNull List packagePaths = JavaFileUtil.gatherPackageNames((File)classFilePath, null);
                ExplicitClassLoader classLoader = new ExplicitClassLoader(classFilePath, packagePaths, this.getClass().getClassLoader());
                EPackage ePackage = UsageTests.this.doLoadPackage(classLoader, qualifiedPackageName);
                EClass eClass = (EClass)ePackage.getEClassifier("Clase1");
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("name");
                EFactory eFactory = ePackage.getEFactoryInstance();
                EObject eObject = eFactory.create(eClass);
                ocl.assertQueryTrue(eObject, "name = null");
                ocl.assertQueryTrue(eObject, "complement(true) = false");
                eObject.eSet(eStructuralFeature, (Object)"testing");
                ocl.assertQueryFalse(eObject, "name = null");
                ocl.assertQueryTrue(eObject, "name = 'testing'");
                ocl.assertQueryEquals(eObject, "XtestingY", "self.myPrefixedName('X', 'Y')");
                ocl.assertQueryEquals(eObject, eObject, "self.me()");
                ocl.dispose();
            }
        });
    }

    public void testBug415782() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "Bug415782";
                String testProjectName = "bug415782";
                String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage bug415782 : bug415782 = 'http://bug415782'\n{\n    class MyClass\n    {\n    \t   attribute manyDates : ecore::EDate[*] { ordered };\n        attribute aBool : Boolean;\n        operation anOp() : MyClass {             body : MyClass {               manyDates = OrderedSet{},\n               aBool = manyDates->isEmpty()\n             };        }\n    }\n}\n";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent(testFileStem, null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                ocl.dispose();
            }
        });
    }

    public void testBug416421() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStemA = "Bug416421A";
                String testProjectNameA = "bug416421A";
                String oclinecoreFileA = "package bug416421A : bug416421A = 'example.org/bug416421A'\n{\n\tclass ClassA\n\t{\n\t\toperation getFalse() : Boolean\n\t\t{\n\t\t\tbody: false;\n\t\t}\n\t}\n}\n";
                String genmodelFileA = UsageTests.this.createEcoreGenModelContent(testFileStemA, null);
                String testFileStemB = "Bug416421B";
                String testProjectNameB = "bug416421B";
                String oclinecoreFileB = "import bug416421A : 'Bug416421A.ecore#/';\npackage bug416421B : bug416421B = 'example.org/bug416421B'\n{\n\tclass ClassB extends bug416421A::ClassA\n\t{\n\t\toperation getTrue() : Boolean\n\t\t{\n\t\t\tbody: true;\n\t\t}\n\t}\n}\n";
                UsageTests.this.createManifestFile();
                HashMap<@NonNull String, @Nullable String> genOptions = new HashMap<String, String>();
                genOptions.put("usedGenPackages", "Bug416421A.genmodel#//bug416421A");
                String genmodelFileB = UsageTests.this.createEcoreGenModelContent(testFileStemB, genOptions);
                URI genModelURIA = UsageTests.this.createModels(testFileStemA, oclinecoreFileA, genmodelFileA);
                URI genModelURIB = UsageTests.this.createModels(testFileStemB, oclinecoreFileB, genmodelFileB);
                UsageTests.this.doGenModel(genModelURIB);
                UsageTests.this.doGenModel(genModelURIA);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectNameA, testProjectNameB);
                ocl.dispose();
            }
        });
    }

    public void testBug458722() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "Bug458722";
                String testProjectName = "bug458722";
                String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore';\n\npackage bug458722 : bug458722 = 'http://www.example.com/bug458722/rootPackage/2.0'\n{\n\tpackage subPackage : subPackage = 'http://www.example.com/bug458722/subPackage/2.0'\n\t{\n\t\tclass SubElement\n\t\t{\n\t\t\toperation op(tokens : String[*] { ordered !unique }) : Boolean\n\t\t\t{\n\t\t\t\tbody: \n\t\t\t\t\n\t\t\t\tif tokens->at(1) = '1'\n\t\t\t\tthen\n\t\t\t\t\top2(tokens)\n\t\t\t    else\n\t\t\t    \ttrue\n\t\t\t    endif;\n\t\t\t}\n\t\t\toperation op2(tokens : String[*] { ordered !unique }) : Boolean\n\t\t\t{\n\t\t\t\tbody: \n\t\t\t\ttrue;\n\t\t\t}\n\t\t}\n\t}\n\tabstract class Element\n\t{\n\t\tattribute name : String = '';\n\t}\n}\n";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent(testFileStem, null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                ocl.dispose();
            }
        });
    }

    public void testBug458723() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "Bug458723";
                String testProjectName = "bug458723";
                String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore';\n\npackage bug458723 : bug458723 = 'http://www.example.com/bug458723/rootPackage/1.0'\n{\n    package subPackage : subPackage = 'http://www.example.com/bug458723/subPackage/1.0'\n    {\n        class Element extends bug458723::Element\n        {\n\n            /*\n             * Error also occurs with Bag(OclAny) in signature without\n{!unique}\n             */\n            operation op() : ocl::OclAny[*] { !unique }\n            {\n                body: \n                Bag{};\n            }\n        }\n    }\n    abstract class Element\n    {\n        attribute name : String = '';\n    }\n}\n";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent(testFileStem, null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                ocl.dispose();
            }
        });
    }

    public void testBug458724() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "Bug458724";
                String testProjectName = "bug458724";
                String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore';\n\npackage bug458724 : bug458724 = 'http://www.example.com/bug458724/rootPackage/2.0'\n{\n    class Element\n    {\n        attribute name : String = '';\n        invariant\n        elementNameNotReservedWord: \n            let name: String = self.name.toLower() in\n            name <> 'reserved_1' and\n            name <> 'reserved_2' and\n            name <> 'reserved_3' and\n            name <> 'reserved_4' and\n            name <> 'reserved_5' and\n            name <> 'reserved_6' and\n            name <> 'reserved_7' and\n            name <> 'reserved_8' and\n            name <> 'reserved_9' and\n            name <> 'reserved_10' and\n            name <> 'reserved_11' and\n            name <> 'reserved_12' and\n            name <> 'reserved_13' and\n            name <> 'reserved_14' and\n            name <> 'reserved_15' and\n            name <> 'reserved_16' and\n            name <> 'reserved_17' and\n            name <> 'reserved_18' and\n            name <> 'reserved_19';\n    }\n}\n";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent(testFileStem, null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                ocl.dispose();
            }
        });
    }

    public void testBug567919() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "Bug567919";
                String testProjectName = "bug567919";
                String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage bug567919 : bug567919 = 'http://bug567919'\n{\n    class Backlog\n\t{\n\t\tproperty workItems : WorkItem[+|1] { ordered composes };\n\t}\n\tclass WorkItem\n\t{\n\t\tattribute effort : ecore::EInt[1];\n\t}\n\tclass Plan\n\t{\n\t\tproperty backlog : Backlog[1] { composes };\n\t\tattribute maxTeamVelocity : ecore::EInt[1];\n\t\tattribute derivedMinSprintCount : ecore::EInt[1] { derived readonly volatile }\n\t\t{\n\t\t\tinitial: self.backlog.workItems->collect(effort)->sum();\n\t\t}\n\t}\n}\n";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent(testFileStem, null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                File classFilePath = UsageTests.this.getTestProject().getOutputFolder("test-bin/").getFile();
                @NonNull List packagePaths = JavaFileUtil.gatherPackageNames((File)classFilePath, null);
                ExplicitClassLoader classLoader = new ExplicitClassLoader(classFilePath, packagePaths, this.getClass().getClassLoader());
                String qualifiedPackageName = String.valueOf(testProjectName) + ".Bug567919Package";
                EPackage ePackage = UsageTests.this.doLoadPackage(classLoader, qualifiedPackageName);
                EClass ePlanClass = (EClass)ePackage.getEClassifier("Plan");
                EReference ePlan_backlog = (EReference)ePlanClass.getEStructuralFeature("backlog");
                EAttribute ePlan_derivedMinSprintCount = (EAttribute)ePlanClass.getEStructuralFeature("derivedMinSprintCount");
                EClass eBacklogClass = (EClass)ePackage.getEClassifier("Backlog");
                EReference eBacklog_workItems = (EReference)eBacklogClass.getEStructuralFeature("workItems");
                EClass eWorkItemClass = (EClass)ePackage.getEClassifier("WorkItem");
                EAttribute eWorkItem_effort = (EAttribute)eWorkItemClass.getEStructuralFeature("effort");
                EFactory eFactory = ePackage.getEFactoryInstance();
                EObject plan = eFactory.create(ePlanClass);
                EObject backlog = eFactory.create(eBacklogClass);
                EObject workItem = eFactory.create(eWorkItemClass);
                workItem.eSet((EStructuralFeature)eWorkItem_effort, (Object)3);
                List castWorkItems = (List)backlog.eGet((EStructuralFeature)eBacklog_workItems);
                castWorkItems.add(workItem);
                plan.eSet((EStructuralFeature)ePlan_backlog, (Object)backlog);
                int count = (Integer)plan.eGet((EStructuralFeature)ePlan_derivedMinSprintCount);
                UsageTests.assertEquals((int)3, (int)count);
                ocl.dispose();
            }
        });
    }

    public void testBug570717_uml() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem;
                String testProjectName = testFileStem = "Bug570717";
                TestOCL ocl0 = UsageTests.this.createOCL();
                URI genModelURI = null;
                Resource umlProfileResource = null;
                try {
                    ResourceSet resourceSet0 = ocl0.getResourceSet();
                    TestFile umlProfileFile = UsageTests.this.getTestFile(String.valueOf(testFileStem) + ".profile.uml", (OCL)ocl0, UsageTests.getTestModelURI("models/uml/" + testFileStem + ".profile.uml"));
                    umlProfileResource = UsageTests.this.loadUmlProfile(resourceSet0, umlProfileFile.getURI());
                    String ecoreFileContent = UsageTests.this.createUMLEcoreModelContent(umlProfileResource);
                    String genmodelFileContent = UsageTests.this.createUMLGenModelContent(umlProfileResource, testFileStem, null);
                    UsageTests.this.createManifestFile();
                    UsageTests.this.createTestFileWithContent(UsageTests.this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".profile.ecore"), ecoreFileContent);
                    genModelURI = UsageTests.this.createTestFileWithContent(UsageTests.this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".profile.genmodel"), genmodelFileContent);
                    Path genModelPath = new Path("/" + UsageTests.this.getTestProject().getName() + "/" + testFileStem + ".profile.genmodel");
                    TestUMLImporter importer = new TestUMLImporter(resourceSet0.getPackageRegistry());
                    importer.reloadGenModel(genModelPath);
                }
                finally {
                    ocl0.dispose();
                }
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                try {
                    UsageTests.this.doUMLCompile(ocl, testProjectName);
                }
                finally {
                    ocl.dispose();
                }
            }
        });
    }

    public void testBug570717a_uml() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem;
                TestOCL ocl0 = UsageTests.this.createOCL();
                String testProjectName = testFileStem = "Bug570717a";
                TestFile umlProfileFile = UsageTests.this.getTestFile(String.valueOf(testFileStem) + ".profile.uml", (OCL)ocl0, UsageTests.getTestModelURI("models/uml/" + testFileStem + ".profile.uml"));
                Resource umlProfileResource = UsageTests.this.loadUmlProfile(ocl0.getResourceSet(), umlProfileFile.getURI());
                String ecoreFileContent = UsageTests.this.createUMLEcoreModelContent(umlProfileResource);
                String genmodelFileContent = UsageTests.this.createUMLGenModelContent(umlProfileResource, testFileStem, null);
                UsageTests.this.createManifestFile();
                UsageTests.this.createTestFileWithContent(UsageTests.this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".profile.ecore"), ecoreFileContent);
                URI genModelURI = UsageTests.this.createTestFileWithContent(UsageTests.this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".profile.genmodel"), genmodelFileContent);
                Path genModelPath = new Path("/" + UsageTests.this.getTestProject().getName() + "/" + testFileStem + ".profile.genmodel");
                TestUMLImporter importer = new TestUMLImporter(ocl0.getResourceSet().getPackageRegistry());
                importer.reloadGenModel(genModelPath);
                ocl0.dispose();
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doUMLCompile(ocl, testProjectName);
                ocl.dispose();
            }
        });
    }

    public void testBug570802() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "Bug570802";
                String testProjectName = "bug570802";
                String oclinecoreFile = "package bug570802 : bug570802 = 'http://Bug570802'\n{\n\tclass Bug570802\n\t{\n\t\tproperty generics : BaseGeneric(?)[*|1] { ordered composes };\n\t\tproperty genericsA : BaseGeneric(?)[*|1] { ordered derived readonly transient volatile }\n\t\t{\n\t\t\tinitial: self.generics;\n\t\t}\n\t}\n\tabstract class BaseGeneric(T);\n}";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent("Bug570802", null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                ocl.dispose();
            }
        });
    }

    public void testBug570891_uml() throws Throwable {
        if (OCLGenModelUtil.INSTANCE.hasDoubleOverrideBug547424()) {
            System.err.println(String.valueOf(this.getName()) + " has been disabled -see UML Bug 547424");
            return;
        }
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem;
                TestOCL ocl0 = UsageTests.this.createOCL();
                String testProjectName = testFileStem = "Bug570891";
                TestFile umlProfileFile = UsageTests.this.getTestFile(String.valueOf(testFileStem) + ".profile.uml", (OCL)ocl0, UsageTests.getTestModelURI("models/uml/" + testFileStem + ".profile.uml"));
                Resource umlProfileResource = UsageTests.this.loadUmlProfile(ocl0.getResourceSet(), umlProfileFile.getURI());
                String ecoreFileContent = UsageTests.this.createUMLEcoreModelContent(umlProfileResource);
                String genmodelFileContent = UsageTests.this.createUMLGenModelContent(umlProfileResource, testFileStem, null);
                UsageTests.this.createManifestFile();
                UsageTests.this.createTestFileWithContent(UsageTests.this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".profile.ecore"), ecoreFileContent);
                URI genModelURI = UsageTests.this.createTestFileWithContent(UsageTests.this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".profile.genmodel"), genmodelFileContent);
                Path genModelPath = new Path("/" + UsageTests.this.getTestProject().getName() + "/" + testFileStem + ".profile.genmodel");
                TestUMLImporter importer = new TestUMLImporter(ocl0.getResourceSet().getPackageRegistry());
                importer.reloadGenModel(genModelPath);
                ocl0.dispose();
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doUMLCompile(ocl, testProjectName);
                ocl.dispose();
            }
        });
    }

    public void testBug570892_uml() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem;
                TestOCL ocl1 = UsageTests.this.createOCL();
                String testProjectName = testFileStem = "Bug570892";
                TestFile umlModelFile = UsageTests.this.getTestFile(String.valueOf(testFileStem) + ".uml", (OCL)ocl1, UsageTests.getTestModelURI("models/uml/" + testFileStem + ".uml"));
                TestFile umlProfileFile = UsageTests.this.getTestFile(String.valueOf(testFileStem) + ".profile.uml", (OCL)ocl1, UsageTests.getTestModelURI("models/uml/" + testFileStem + ".profile.uml"));
                Resource umlProfileResource = UsageTests.this.loadUmlProfile(ocl1.getResourceSet(), umlProfileFile.getURI());
                String ecoreFileContent = UsageTests.this.createUMLEcoreModelContent(umlProfileResource);
                String genmodelFileContent = UsageTests.this.createUMLGenModelContent(umlProfileResource, testFileStem, null);
                UsageTests.this.createManifestFile();
                UsageTests.this.createTestFileWithContent(UsageTests.this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".profile.ecore"), ecoreFileContent);
                URI genModelURI = UsageTests.this.createTestFileWithContent(UsageTests.this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".profile.genmodel"), genmodelFileContent);
                Path genModelPath = new Path("/" + UsageTests.this.getTestProject().getName() + "/" + testFileStem + ".profile.genmodel");
                TestUMLImporter importer = new TestUMLImporter(ocl1.getResourceSet().getPackageRegistry());
                importer.reloadGenModel(genModelPath);
                ocl1.dispose();
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl2 = UsageTests.this.createOCL();
                UsageTests.this.doUMLCompile(ocl2, testProjectName);
                int oldAbstractEnvironmentFactory_CONSTRUCTION_COUNT = AbstractEnvironmentFactory.CONSTRUCTION_COUNT;
                int oldAbstractModelManager_CONSTRUCTION_COUNT = AbstractModelManager.CONSTRUCTION_COUNT;
                int oldExecutorManager_CONSTRUCTION_COUNT = ExecutorManager.CONSTRUCTION_COUNT;
                int oldAbstractExecutor_CONSTRUCTION_COUNT = AbstractExecutor.CONSTRUCTION_COUNT;
                String qualifiedPackageClassName = "Bug570892.validationproblem.ValidationProblemPackage";
                String pathMapName = "pathmap://VALIDATIONPROBLEM_PROFILE/";
                Resource umlModelResource = UsageTests.this.validateUmlModel(umlModelFile.getURI(), qualifiedPackageClassName, pathMapName, null);
                UsageTests.assertEquals((String)"AbstractEnvironmentFactory.CONSTRUCTION_COUNT", (int)0, (int)(AbstractEnvironmentFactory.CONSTRUCTION_COUNT - oldAbstractEnvironmentFactory_CONSTRUCTION_COUNT));
                UsageTests.assertEquals((String)"AbstractModelManager.CONSTRUCTION_COUNT", (int)1, (int)(AbstractModelManager.CONSTRUCTION_COUNT - oldAbstractModelManager_CONSTRUCTION_COUNT));
                UsageTests.assertEquals((String)"ExecutorManager.CONSTRUCTION_COUNT", (int)1, (int)(ExecutorManager.CONSTRUCTION_COUNT - oldExecutorManager_CONSTRUCTION_COUNT));
                UsageTests.assertEquals((String)"AbstractExecutor.CONSTRUCTION_COUNT", (int)0, (int)(AbstractExecutor.CONSTRUCTION_COUNT - oldAbstractExecutor_CONSTRUCTION_COUNT));
                ocl2.dispose();
            }
        });
    }

    public void testBug570894_uml() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem;
                TestOCL ocl1 = UsageTests.this.createOCL();
                String testProjectName = testFileStem = "Bug570894";
                TestFile umlModelFile = UsageTests.this.getTestFile(String.valueOf(testFileStem) + ".uml", (OCL)ocl1, UsageTests.getTestModelURI("models/uml/" + testFileStem + ".uml"));
                TestFile umlLibraryFile = UsageTests.this.getTestFile(String.valueOf(testFileStem) + ".library.uml", (OCL)ocl1, UsageTests.getTestModelURI("models/uml/" + testFileStem + ".library.uml"));
                TestFile umlProfileFile = UsageTests.this.getTestFile(String.valueOf(testFileStem) + ".profile.uml", (OCL)ocl1, UsageTests.getTestModelURI("models/uml/" + testFileStem + ".profile.uml"));
                Resource umlProfileResource = UsageTests.this.loadUmlProfile(ocl1.getResourceSet(), umlProfileFile.getURI());
                String ecoreFileContent = UsageTests.this.createUMLEcoreModelContent(umlProfileResource);
                String genmodelFileContent = UsageTests.this.createUMLGenModelContent(umlProfileResource, testFileStem, null);
                UsageTests.this.createManifestFile();
                UsageTests.this.createTestFileWithContent(UsageTests.this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".profile.ecore"), ecoreFileContent);
                URI genModelURI = UsageTests.this.createTestFileWithContent(UsageTests.this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".profile.genmodel"), genmodelFileContent);
                Path genModelPath = new Path("/" + UsageTests.this.getTestProject().getName() + "/" + testFileStem + ".profile.genmodel");
                TestUMLImporter importer = new TestUMLImporter(ocl1.getResourceSet().getPackageRegistry());
                importer.reloadGenModel(genModelPath);
                ocl1.dispose();
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl2 = UsageTests.this.createOCL();
                UsageTests.this.doUMLCompile(ocl2, testProjectName);
                int oldAbstractEnvironmentFactory_CONSTRUCTION_COUNT = AbstractEnvironmentFactory.CONSTRUCTION_COUNT;
                int oldAbstractModelManager_CONSTRUCTION_COUNT = AbstractModelManager.CONSTRUCTION_COUNT;
                int oldExecutorManager_CONSTRUCTION_COUNT = ExecutorManager.CONSTRUCTION_COUNT;
                int oldAbstractExecutor_CONSTRUCTION_COUNT = AbstractExecutor.CONSTRUCTION_COUNT;
                String qualifiedPackageClassName = "Bug570894.validationproblem.ValidationProblemPackage";
                String pathMapName = "pathmap://VALIDATIONPROBLEM_PROFILE/";
                HashMap<URI, URI> extraUriMap = new HashMap<URI, URI>();
                extraUriMap.put(URI.createURI((String)"pathmap://VALIDATIONPROBLEM_LIBRARY/ValidationProblem-Library.uml"), umlLibraryFile.getURI());
                extraUriMap.put(URI.createURI((String)"pathmap://VALIDATIONPROBLEM_PROFILE/ValidationProblem.profile.uml"), umlProfileFile.getURI());
                Resource umlModelResource = UsageTests.this.validateUmlModel(umlModelFile.getURI(), qualifiedPackageClassName, pathMapName, extraUriMap);
                UsageTests.assertEquals((String)"AbstractEnvironmentFactory.CONSTRUCTION_COUNT", (int)0, (int)(AbstractEnvironmentFactory.CONSTRUCTION_COUNT - oldAbstractEnvironmentFactory_CONSTRUCTION_COUNT));
                UsageTests.assertEquals((String)"AbstractModelManager.CONSTRUCTION_COUNT", (int)1, (int)(AbstractModelManager.CONSTRUCTION_COUNT - oldAbstractModelManager_CONSTRUCTION_COUNT));
                UsageTests.assertEquals((String)"ExecutorManager.CONSTRUCTION_COUNT", (int)1, (int)(ExecutorManager.CONSTRUCTION_COUNT - oldExecutorManager_CONSTRUCTION_COUNT));
                UsageTests.assertEquals((String)"AbstractExecutor.CONSTRUCTION_COUNT", (int)0, (int)(AbstractExecutor.CONSTRUCTION_COUNT - oldAbstractExecutor_CONSTRUCTION_COUNT));
                for (EObject eObject : umlModelResource.getContents()) {
                    EClass eClass = eObject.eClass();
                    if (!"Farm".equals(eClass.getName())) continue;
                    EStructuralFeature animalFeature = eClass.getEStructuralFeature("animal");
                    EStructuralFeature chickenFeature = eClass.getEStructuralFeature("chicken");
                    EStructuralFeature duckFeature = eClass.getEStructuralFeature("duck");
                    Object animals = eObject.eGet(animalFeature);
                    UsageTests.assertEquals((int)4, (int)((Collection)animals).size());
                    Object chicken = eObject.eGet(chickenFeature);
                    Object object = eObject.eGet(duckFeature);
                }
                ocl2.dispose();
            }
        });
    }

    public void testBug571407_uml() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem;
                TestOCL ocl1 = UsageTests.this.createOCL();
                String testProjectName = testFileStem = "Bug571407";
                TestFile umlProfileFile = UsageTests.this.getTestFile(String.valueOf(testFileStem) + ".profile.uml", (OCL)ocl1, UsageTests.getTestModelURI("models/uml/" + testFileStem + ".profile.uml"));
                Resource umlProfileResource = UsageTests.this.loadUmlProfile(ocl1.getResourceSet(), umlProfileFile.getURI());
                String ecoreFileContent = UsageTests.this.createUMLEcoreModelContent(umlProfileResource);
                String genmodelFileContent = UsageTests.this.createUMLGenModelContent(umlProfileResource, testFileStem, null);
                UsageTests.this.createManifestFile();
                UsageTests.this.createTestFileWithContent(UsageTests.this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".profile.ecore"), ecoreFileContent);
                URI genModelURI = UsageTests.this.createTestFileWithContent(UsageTests.this.getTestProject().getOutputFile(String.valueOf(testFileStem) + ".profile.genmodel"), genmodelFileContent);
                Path genModelPath = new Path("/" + UsageTests.this.getTestProject().getName() + "/" + testFileStem + ".profile.genmodel");
                TestUMLImporter importer = new TestUMLImporter(ocl1.getResourceSet().getPackageRegistry());
                importer.reloadGenModel(genModelPath);
                ocl1.dispose();
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl2 = UsageTests.this.createOCL();
                UsageTests.this.doUMLCompile(ocl2, testProjectName);
            }
        });
    }

    public void testCSE() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "CSEs";
                String testProjectName = "cses";
                String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage cses : cses = 'http://cses'\n{\n    class CSEs\n    {\n        operation test(a : ecore::EInt, b : ecore::EInt, c : ecore::EInt) : ecore::EInt { body: if a + b + c > 0 then a + b + c else a + b endif; }\n    }\n}\n";
                HashMap<@NonNull String, @Nullable String> genOptions = new HashMap<String, String>();
                genOptions.put("interfacePackageSuffix", "coreI");
                genOptions.put("metaDataPackageSuffix", "coreM");
                String genmodelFile = UsageTests.this.createEcoreGenModelContent(testFileStem, genOptions);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                String qualifiedPackageName = String.valueOf(testProjectName) + ".coreM." + testFileStem + "Package";
                File classFilePath = UsageTests.this.getTestProject().getOutputFolder("test-bin/").getFile();
                @NonNull List packagePaths = JavaFileUtil.gatherPackageNames((File)classFilePath, null);
                ExplicitClassLoader classLoader = new ExplicitClassLoader(classFilePath, packagePaths, this.getClass().getClassLoader());
                EPackage ePackage = UsageTests.this.doLoadPackage(classLoader, qualifiedPackageName);
                EClass eClass = (EClass)ePackage.getEClassifier("CSEs");
                EFactory eFactory = ePackage.getEFactoryInstance();
                EObject eObject = eFactory.create(eClass);
                ocl.assertQueryEquals(eObject, 6, "test(3, 2, 1)");
                ocl.assertQueryEquals(eObject, -5, "test(3, -8, 1)");
                ocl.dispose();
            }
        });
    }

    public void testCodegenCompany() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testProjectName = "org/eclipse/ocl/examples/xtext/tests/codegen/company";
                URI sourceGenModelURI = UsageTests.getTestModelURI("models/genmodel/CodeGenCompany.genmodel");
                URI targetGenModelURI = UsageTests.this.getTestURI("CodeGenCompany.genmodel");
                TestOCL ocl0 = UsageTests.this.createOCL();
                try {
                    Resource genModelResource = ocl0.getResourceSet().getResource(sourceGenModelURI, true);
                    GenModel genModel = (GenModel)genModelResource.getContents().get(0);
                    genModel.setModelDirectory(String.valueOf(UsageTests.this.getTestProject().getName()) + "/" + "test-src");
                    genModelResource.setURI(targetGenModelURI);
                    genModelResource.save(XMIUtil.createSaveOptions());
                    UsageTests.this.createManifestFile();
                }
                finally {
                    ocl0.dispose();
                }
                UsageTests.this.doGenModel(targetGenModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                try {
                    UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                }
                finally {
                    ocl.dispose();
                }
            }
        });
    }

    public void testEcoreLists570717() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "Bug570717";
                String testProjectName = "bug570717";
                String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage bug570717 : bug570717 = 'http://bug570717'\n{\n    datatype ENumber : 'java.lang.Number' { serializable };\n    class EcoreLists\n    {\n        attribute eBigDecimal : ecore::EBigDecimal { derived readonly volatile } { derivation: negEBigDecimal(1); }\n        attribute eBigDecimals : ecore::EBigDecimal[*] { derived readonly volatile } { derivation: negEBigDecimals(Set{1}); }\n        attribute eBigInteger : ecore::EBigInteger { derived readonly volatile } { derivation: negEBigInteger(1); }\n        attribute eBigIntegers : ecore::EBigInteger[*] { derived readonly volatile } { derivation: negEBigIntegers(Set{1}); }\n        attribute eBoolean : ecore::EBoolean { derived readonly volatile } { derivation: notEBoolean(true); }\n        attribute eBooleans : ecore::EBoolean[*] { derived readonly volatile } { derivation: notEBooleans(Set{true}); }\n        attribute eBooleanObject : ecore::EBooleanObject { derived readonly volatile } { derivation: notEBooleanObject(true); }\n        attribute eBooleanObjects : ecore::EBooleanObject[*] { derived readonly volatile } { derivation: notEBooleanObjects(Set{true}); }\n        attribute eChar : ecore::EChar { derived readonly volatile } { derivation: negEChar(1); }\n        attribute eChars : ecore::EChar[*] { derived readonly volatile } { derivation: negEChars(Set{1}); }\n        attribute eCharacterObject : ecore::ECharacterObject { derived readonly volatile } { derivation: negECharacterObject(1); }\n        attribute eCharacterObjects : ecore::ECharacterObject[*] { derived readonly volatile } { derivation: negECharacterObjects(Set{1}); }\n        attribute eDouble : ecore::EDouble { derived readonly volatile } { derivation: negEDouble(1); }\n        attribute eDoubles : ecore::EDouble[*] { derived readonly volatile } { derivation: negEDoubles(Set{1}); }\n        attribute eDoubleObject : ecore::EDoubleObject { derived readonly volatile } { derivation: negEDoubleObject(1); }\n        attribute eDoubleObjects : ecore::EDoubleObject[*] { derived readonly volatile } { derivation: negEDoubleObjects(Set{1}); }\n        attribute eFloat : ecore::EFloat { derived readonly volatile } { derivation: negEFloat(1); }\n        attribute eFloats : ecore::EFloat[*] { derived readonly volatile } { derivation: negEFloats(Set{1}); }\n        attribute eFloatObject : ecore::EFloatObject { derived readonly volatile } { derivation: negEFloatObject(1); }\n        attribute eFloatObjects : ecore::EFloatObject[*] { derived readonly volatile } { derivation: negEFloatObjects(Set{1}); }\n        attribute eInt : ecore::EInt { derived readonly volatile } { derivation: negEInt(1); }\n        attribute eInts : ecore::EInt[*] { derived readonly volatile } { derivation: negEInts(Set{1}); }\n        attribute eIntegerObject : ecore::EIntegerObject { derived readonly volatile } { derivation: negEIntegerObject(1); }\n        attribute eIntegerObjects : ecore::EIntegerObject[*] { derived readonly volatile } { derivation: negEIntegerObjects(Set{1}); }\n        attribute eLong : ecore::ELong { derived readonly volatile } { derivation: negELong(1); }\n        attribute eLongs : ecore::ELong[*] { derived readonly volatile } { derivation: negELongs(Set{1}); }\n        attribute eLongObject : ecore::ELongObject { derived readonly volatile } { derivation: negELongObject(1); }\n        attribute eLongObjects : ecore::ELongObject[*] { derived readonly volatile } { derivation: negELongObjects(Set{1}); }\n        attribute eShort : ecore::EShort { derived readonly volatile } { derivation: negEShort(1); }\n        attribute eShorts : ecore::EShort[*] { derived readonly volatile } { derivation: negEShorts(Set{1}); }\n        attribute eShortObject : ecore::EShortObject { derived readonly volatile } { derivation: negEShortObject(1); }\n        attribute eShortObjects : ecore::EShortObject[*] { derived readonly volatile } { derivation: negEShortObjects(Set{1}); }\n        attribute eString : ecore::EString { derived readonly volatile } { derivation: upCase('abc'); }\n        attribute eStrings : ecore::EString[*] { derived readonly volatile } { derivation: upCases(Set{'abc'}); }\n        operation negEBigDecimal(b : ecore::EBigDecimal) : ecore::EBigDecimal { body: -b; }\n        operation negEBigDecimals(b : ecore::EBigDecimal[*]) : ecore::EBigDecimal[*] { body: b->collect(e | -e)->asSet(); }\n        operation negEBigInteger(b : ecore::EBigInteger) : ecore::EBigInteger { body: -b; }\n        operation negEBigIntegers(b : ecore::EBigInteger[*]) : ecore::EBigInteger[*] { body: b->collect(e | -e)->asSet(); }\n        operation notEBoolean(b : ecore::EBoolean) : ecore::EBoolean { body: not b; }\n        operation notEBooleans(b : ecore::EBoolean[*]) : ecore::EBoolean[*] { body: b->collect(e | not e)->asSet(); }\n        operation notEBooleanObject(b : ecore::EBooleanObject) : ecore::EBooleanObject { body: not b; }\n        operation notEBooleanObjects(b : ecore::EBooleanObject[*]) : ecore::EBooleanObject[*] { body: b->collect(e | not e)->asSet(); }\n        operation negEChar(b : ecore::EChar) : ecore::EChar { body: -b; }\n        operation negEChars(b : ecore::EChar[*]) : ecore::EChar[*] { body: b->collect(e | (-e).oclAsType(ecore::EChar))->asSet(); }\n        operation negECharacterObject(b : ecore::ECharacterObject) : ecore::ECharacterObject { body: -b; }\n        operation negECharacterObjects(b : ecore::ECharacterObject[*]) : ecore::ECharacterObject[*] { body: b->collect(e | -e)->asSet(); }\n        operation negEDouble(b : ecore::EDouble) : ecore::EDouble { body: -b; }\n        operation negEDoubles(b : ecore::EDouble[*]) : ecore::EDouble[*] { body: b->collect(e | -e)->asSet(); }\n        operation negEDoubleObject(b : ecore::EDoubleObject) : ecore::EDoubleObject { body: -b; }\n        operation negEDoubleObjects(b : ecore::EDoubleObject[*]) : ecore::EDoubleObject[*] { body: b->collect(e | -e)->asSet(); }\n        operation negEFloat(b : ecore::EFloat) : ecore::EFloat { body: -b; }\n        operation negEFloats(b : ecore::EFloat[*]) : ecore::EFloat[*] { body: b->collect(e | -e)->asSet(); }\n        operation negEFloatObject(b : ecore::EFloatObject) : ecore::EFloatObject { body: -b; }\n        operation negEFloatObjects(b : ecore::EFloatObject[*]) : ecore::EFloatObject[*] { body: b->collect(e | -e)->asSet(); }\n        operation negEInt(b : ecore::EInt) : ecore::EInt { body: -b; }\n        operation negEInts(b : ecore::EInt[*]) : ecore::EInt[*] { body: b->collect(e | -e)->asSet(); }\n        operation negEIntegerObject(b : ecore::EIntegerObject) : ecore::EIntegerObject { body: -b; }\n        operation negEIntegerObjects(b : ecore::EIntegerObject[*]) : ecore::EIntegerObject[*] { body: b->collect(e | -e)->asSet(); }\n        operation negELong(b : ecore::ELong) : ecore::ELong { body: -b; }\n        operation negELongs(b : ecore::ELong[*]) : ecore::ELong[*] { body: b->collect(e | -e)->asSet(); }\n        operation negELongObject(b : ecore::ELongObject) : ecore::ELongObject { body: -b; }\n        operation negELongObjects(b : ecore::ELongObject[*]) : ecore::ELongObject[*] { body: b->collect(e | -e)->asSet(); }\n        operation negEShort(b : ecore::EShort) : ecore::EShort { body: -b; }\n        operation negEShorts(b : ecore::EShort[*]) : ecore::EShort[*] { body: b->collect(e | -e)->asSet(); }\n        operation negEShortObject(b : ecore::EShortObject) : ecore::EShortObject { body: -b; }\n        operation negEShortObjects(b : ecore::EShortObject[*]) : ecore::EShortObject[*] { body: b->collect(e | -e)->asSet(); }\n        operation upCase(b : ecore::EString) : ecore::EString { body: b.toUpper(); }\n        operation upCases(b : ecore::EString[*]) : ecore::EString[*] { body: b->collect(e | e.toUpper())->asSet(); }\n    }\n}\n";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent("Bug570717", null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                try {
                    UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                    String qualifiedPackageName = String.valueOf(testProjectName) + "." + testFileStem + "Package";
                    File classFilePath = UsageTests.this.getTestProject().getOutputFolder("test-bin/").getFile();
                    @NonNull List packagePaths = JavaFileUtil.gatherPackageNames((File)classFilePath, null);
                    ExplicitClassLoader classLoader = new ExplicitClassLoader(classFilePath, packagePaths, this.getClass().getClassLoader());
                    EPackage ePackage = UsageTests.this.doLoadPackage(classLoader, qualifiedPackageName);
                    EClass eClass = (EClass)ePackage.getEClassifier("EcoreLists");
                    EFactory eFactory = ePackage.getEFactoryInstance();
                    EObject eObject = eFactory.create(eClass);
                    ocl.assertQueryTrue(eObject, "eBigDecimals = Set{eBigDecimal}");
                    ocl.assertQueryTrue(eObject, "negEBigDecimals(eBigDecimals) = Set{negEBigDecimal(eBigDecimal)}");
                    ocl.assertQueryTrue(eObject, "eBigIntegers = Set{eBigInteger}");
                    ocl.assertQueryTrue(eObject, "negEBigIntegers(eBigIntegers) = Set{negEBigInteger(eBigInteger)}");
                    ocl.assertQueryTrue(eObject, "eBoolean = eBooleanObject");
                    ocl.assertQueryTrue(eObject, "eBooleans = eBooleanObjects");
                    ocl.assertQueryTrue(eObject, "notEBooleans(eBooleans) = Set{notEBoolean(eBoolean)}");
                    ocl.assertQueryTrue(eObject, "eBooleanObjects = Set{eBooleanObject}");
                    ocl.assertQueryTrue(eObject, "notEBooleanObjects(eBooleanObjects) = Set{notEBooleanObject(eBooleanObject)}");
                    ocl.assertQueryTrue(eObject, "eDoubles = Set{eDouble}");
                    ocl.assertQueryTrue(eObject, "negEDoubles(eDoubles) = Set{negEDouble(eDouble)}");
                    ocl.assertQueryTrue(eObject, "eDoubleObjects = Set{eDoubleObject}");
                    ocl.assertQueryTrue(eObject, "negEDoubleObjects(eDoubleObjects) = Set{negEDoubleObject(eDoubleObject)}");
                    ocl.assertQueryTrue(eObject, "eFloats = Set{eFloat}");
                    ocl.assertQueryTrue(eObject, "negEFloats(eFloats) = Set{negEFloat(eFloat)}");
                    ocl.assertQueryTrue(eObject, "eFloatObjects = Set{eFloatObject}");
                    ocl.assertQueryTrue(eObject, "negEFloatObjects(eFloatObjects) = Set{negEFloatObject(eFloatObject)}");
                    ocl.assertQueryTrue(eObject, "eInts = Set{eInt}");
                    ocl.assertQueryTrue(eObject, "negEInts(eInts) = Set{negEInt(eInt)}");
                    ocl.assertQueryTrue(eObject, "eIntegerObjects = Set{eIntegerObject}");
                    ocl.assertQueryTrue(eObject, "negEIntegerObjects(eIntegerObjects) = Set{negEIntegerObject(eIntegerObject)}");
                    ocl.assertQueryTrue(eObject, "eLongs = Set{eLong}");
                    ocl.assertQueryTrue(eObject, "negELongs(eLongs) = Set{negELong(eLong)}");
                    ocl.assertQueryTrue(eObject, "eLongObjects = Set{eLongObject}");
                    ocl.assertQueryTrue(eObject, "negELongObjects(eLongObjects) = Set{negELongObject(eLongObject)}");
                    ocl.assertQueryTrue(eObject, "eShorts = Set{eShort}");
                    ocl.assertQueryTrue(eObject, "negEShorts(eShorts) = Set{negEShort(eShort)}");
                    ocl.assertQueryTrue(eObject, "eShortObjects = Set{eShortObject}");
                    ocl.assertQueryTrue(eObject, "negEShortObjects(eShortObjects) = Set{negEShortObject(eShortObject)}");
                    ocl.assertQueryTrue(eObject, "eBigInteger = eBigDecimal");
                    ocl.assertQueryTrue(eObject, "eString = 'ABC'");
                    ocl.assertQueryTrue(eObject, "eStrings = Set{eString}");
                }
                finally {
                    ocl.dispose();
                }
            }
        });
    }

    public void testEcoreTypes412736() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "Bug412736";
                String testProjectName = "bug412736";
                String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage bug412736 : bug412736 = 'http://bug412736'\n{\n    datatype ENumber : 'java.lang.Number' { serializable };\n    class EcoreDataTypes\n    {\n        attribute eBigDecimal : ecore::EBigDecimal { derived readonly volatile } { derivation: negEBigDecimal(1); }\n        attribute eBigInteger : ecore::EBigInteger { derived readonly volatile } { derivation: negEBigInteger(1); }\n        attribute eBooleanObject : ecore::EBooleanObject { derived readonly volatile } { derivation: notEBooleanObject(true); }\n        attribute eBoolean : ecore::EBoolean { derived readonly volatile } { derivation: notEBoolean(true); }\n        attribute eCharacterObject : ecore::ECharacterObject { derived readonly volatile } { derivation: negECharacterObject(1); }\n        attribute eChar : ecore::EChar { derived readonly volatile } { derivation: negEChar(1); }\n        attribute eDoubleObject : ecore::EDoubleObject { derived readonly volatile } { derivation: negEDoubleObject(1); }\n        attribute eDouble : ecore::EDouble { derived readonly volatile } { derivation: negEDouble(1); }\n        attribute eFloatObject : ecore::EFloatObject { derived readonly volatile } { derivation: negEFloatObject(1); }\n        attribute eFloat : ecore::EFloat { derived readonly volatile } { derivation: negEFloat(1); }\n        attribute eIntegerObject : ecore::EIntegerObject { derived readonly volatile } { derivation: negEIntegerObject(1); }\n        attribute eInt : ecore::EInt { derived readonly volatile } { derivation: negEInt(1); }\n        attribute eLongObject : ecore::ELongObject { derived readonly volatile } { derivation: negELongObject(1); }\n        attribute eLong : ecore::ELong { derived readonly volatile } { derivation: negELong(1); }\n        attribute eShortObject : ecore::EShortObject { derived readonly volatile } { derivation: negEShortObject(1); }\n        attribute eShort : ecore::EShort { derived readonly volatile } { derivation: negEShort(1); }\n        attribute eString : ecore::EString { derived readonly volatile } { derivation: upCase('abc'); }\n        operation negEBigDecimal(b : ecore::EBigDecimal) : ecore::EBigDecimal { body: -b; }\n        operation negEBigInteger(b : ecore::EBigInteger) : ecore::EBigInteger { body: -b; }\n        operation negEChar(b : ecore::EChar) : ecore::EChar { body: -b; }\n        operation negECharacterObject(b : ecore::ECharacterObject) : ecore::ECharacterObject { body: -b; }\n        operation negEDouble(b : ecore::EDouble) : ecore::EDouble { body: -b; }\n        operation negEDoubleObject(b : ecore::EDoubleObject) : ecore::EDoubleObject { body: -b; }\n        operation negEFloat(b : ecore::EFloat) : ecore::EFloat { body: -b; }\n        operation negEFloatObject(b : ecore::EFloatObject) : ecore::EFloatObject { body: -b; }\n        operation negEInt(b : ecore::EInt) : ecore::EInt { body: -b; }\n        operation negEIntegerObject(b : ecore::EIntegerObject) : ecore::EIntegerObject { body: -b; }\n        operation negELong(b : ecore::ELong) : ecore::ELong { body: -b; }\n        operation negELongObject(b : ecore::ELongObject) : ecore::ELongObject { body: -b; }\n        operation negEShort(b : ecore::EShort) : ecore::EShort { body: -b; }\n        operation negEShortObject(b : ecore::EShortObject) : ecore::EShortObject { body: -b; }\n        operation notEBoolean(b : ecore::EBoolean) : ecore::EBoolean { body: not b; }\n        operation notEBooleanObject(b : ecore::EBooleanObject) : ecore::EBooleanObject { body: not b; }\n        operation upCase(b : ecore::EString) : ecore::EString { body: b.toUpper(); }\n    }\n}\n";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent("Bug412736", null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                String qualifiedPackageName = String.valueOf(testProjectName) + "." + testFileStem + "Package";
                File classFilePath = UsageTests.this.getTestProject().getOutputFolder("test-bin/").getFile();
                @NonNull List packagePaths = JavaFileUtil.gatherPackageNames((File)classFilePath, null);
                ExplicitClassLoader classLoader = new ExplicitClassLoader(classFilePath, packagePaths, this.getClass().getClassLoader());
                EPackage ePackage = UsageTests.this.doLoadPackage(classLoader, qualifiedPackageName);
                EClass eClass = (EClass)ePackage.getEClassifier("EcoreDataTypes");
                EFactory eFactory = ePackage.getEFactoryInstance();
                EObject eObject = eFactory.create(eClass);
                ocl.assertQueryTrue(eObject, "eBigInteger = eBigDecimal");
                ocl.assertQueryTrue(eObject, "eChar = eCharacterObject");
                ocl.assertQueryTrue(eObject, "eBoolean = eBooleanObject");
                ocl.assertQueryTrue(eObject, "eDouble = eDoubleObject");
                ocl.assertQueryTrue(eObject, "eFloat = eFloatObject");
                ocl.assertQueryTrue(eObject, "eInt = eIntegerObject");
                ocl.assertQueryTrue(eObject, "eLong = eLongObject");
                ocl.assertQueryTrue(eObject, "eShort = eShortObject");
                ocl.assertQueryTrue(eObject, "eString = 'ABC'");
                ocl.dispose();
            }
        });
    }

    public void testEnumTypes412685() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public void runWithThrowable() throws Exception {
                EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ocl/2015/Library", (Object)OCLstdlibPackage.eINSTANCE);
                String testFileStem = "Bug412685";
                String testProjectName = "bug412685";
                String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage bug412685 : bug412685 = 'http://bug412685'\n{\n    enum Color { serializable } {\n    \tliteral BLACK;\n    \tliteral WHITE;\n    }\n    class EnumTypes\n    {\n        attribute eBlack : Color = 'BLACK' { readonly };\n        attribute eWhite : Color = 'WHITE' { readonly };\n        attribute eColor : Color { derived readonly volatile } { derivation: otherColor(Color::BLACK); }\n        operation opaqueColor(eColor : Color) : OclAny { body: eColor; }\n        operation otherColor(eColor : Color) : Color { body: if eColor = Color::BLACK then Color::WHITE else Color::BLACK endif; }\n    }\n}\n";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent(testFileStem, null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                String qualifiedPackageName = String.valueOf(testProjectName) + "." + testFileStem + "Package";
                File classFilePath = UsageTests.this.getTestProject().getOutputFolder("test-bin/").getFile();
                @NonNull List packagePaths = JavaFileUtil.gatherPackageNames((File)classFilePath, null);
                ExplicitClassLoader classLoader = new ExplicitClassLoader(classFilePath, packagePaths, this.getClass().getClassLoader());
                EPackage ePackage = UsageTests.this.doLoadPackage(classLoader, qualifiedPackageName);
                EClass eClass = (EClass)ePackage.getEClassifier("EnumTypes");
                EFactory eFactory = ePackage.getEFactoryInstance();
                EObject eObject = eFactory.create(eClass);
                ocl.assertQueryTrue(eObject, "let aWhite : OclAny = opaqueColor(eWhite) in eColor = aWhite");
                ocl.assertQueryTrue(eObject, "let aWhite : OclAny = eWhite.oclAsType(OclAny) in eColor = aWhite");
                ocl.assertQueryTrue(eObject, "eColor = eWhite");
                ocl.assertQueryTrue(eObject, "eColor = Color::WHITE");
                ocl.dispose();
            }
        });
    }

    public void testEvaluators() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "Evaluators";
                String testProjectName = "evaluators";
                String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage evaluators : evaluators = 'http://evaluators'\n{\n    class Evaluators\n    {\n        attribute name : String[?];\n        operation test() : String { body: \n        let severity : String[1] = 'testString'.replaceFirst('xx', 'yy') \n        in if severity = '' \n        then '' \n        else \n        'testString'.replaceAll('z1','z2') \n        endif; }\n    }\n}\n";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent(testFileStem, null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                String qualifiedPackageName = String.valueOf(testProjectName) + "." + testFileStem + "Package";
                File classFilePath = UsageTests.this.getTestProject().getOutputFolder("test-bin/").getFile();
                @NonNull List packagePaths = JavaFileUtil.gatherPackageNames((File)classFilePath, null);
                ExplicitClassLoader classLoader = new ExplicitClassLoader(classFilePath, packagePaths, this.getClass().getClassLoader());
                EPackage ePackage = UsageTests.this.doLoadPackage(classLoader, qualifiedPackageName);
                EClass eClass = (EClass)ePackage.getEClassifier("Evaluators");
                EFactory eFactory = ePackage.getEFactoryInstance();
                EObject eObject = eFactory.create(eClass);
                ocl.assertQueryEquals(eObject, "testString", "test()");
                ocl.dispose();
            }
        });
    }

    public void testSysML_QUDV() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public void runWithThrowable() throws Exception {
                String testProjectName = "SysML_ValueTypes_QUDV";
                URI targetGenModelURI = UsageTests.this.getTestURI("SysML_ValueTypes_QUDV.genmodel");
                TestOCL ocl0 = UsageTests.this.createOCL();
                try {
                    UsageTests.this.createManifestFile();
                    URI sourceGenModelURI = UsageTests.getTestModelURI("models/genmodel/SysML_ValueTypes_QUDV.genmodel");
                    Resource genModelResource = ocl0.getResourceSet().getResource(sourceGenModelURI, true);
                    GenModel genModel = (GenModel)genModelResource.getContents().get(0);
                    genModel.setModelDirectory(String.valueOf(UsageTests.this.getTestProject().getName()) + "/" + "test-src");
                    genModelResource.setURI(targetGenModelURI);
                    genModelResource.save(XMIUtil.createSaveOptions());
                }
                finally {
                    ocl0.dispose();
                }
                UsageTests.this.doGenModel(targetGenModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                try {
                    UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                    File classFilePath = UsageTests.this.getTestProject().getOutputFolder("test-bin/").getFile();
                    @NonNull List packagePaths = JavaFileUtil.gatherPackageNames((File)classFilePath, null);
                    ExplicitClassLoader classLoader = new ExplicitClassLoader(classFilePath, packagePaths, this.getClass().getClassLoader());
                    String qualifiedPackageName1 = String.valueOf(testProjectName) + ".QUDV.QUDVPackage";
                    EPackage ePackage1 = UsageTests.this.doLoadPackage(classLoader, qualifiedPackageName1);
                    EClass eClass1 = (EClass)ePackage1.getEClassifier("DerivedQuantityKind");
                    EFactory eFactory1 = ePackage1.getEFactoryInstance();
                    EObject eObject1 = eFactory1.create(eClass1);
                    ocl.assertQueryTrue(eObject1, "dependsOnQuantityKinds() <> null");
                    String qualifiedPackageName2 = String.valueOf(testProjectName) + ".PrimitiveValueTypes.PrimitiveValueTypesPackage";
                    EPackage ePackage2 = UsageTests.this.doLoadPackage(classLoader, qualifiedPackageName2);
                    EClass eClass2 = (EClass)ePackage2.getEClassifier("Complex");
                    EFactory eFactory2 = ePackage2.getEFactoryInstance();
                    EObject eObject2 = eFactory2.create(eClass2);
                    ocl.assertQueryTrue(eObject2, "imaginaryPart = realPart");
                    ocl.assertQueryTrue(eObject2, "oclType() <> null");
                    ocl.assertQueryTrue(eObject2, "oclType().oclIsKindOf(OclAny)");
                }
                finally {
                    ocl.dispose();
                }
            }
        });
    }

    public void testInitStatics() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                UsageTests.assertTrue((boolean)ValueUtil.initAllStatics());
                UsageTests.assertFalse((boolean)ValueUtil.initAllStatics());
            }
        });
    }

    public void testOpen_Pivot_oclas() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                TestOCL ocl = UsageTests.this.createOCL();
                if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                    TestCaseAppender.INSTANCE.uninstall();
                    TestUIUtil.suppressGitPrefixPopUp();
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IIntroManager introManager = workbench.getIntroManager();
                    introManager.closeIntro(introManager.getIntro());
                    TestUIUtil.flushEvents();
                    String testProjectName = "Open_Pivot";
                    ResourceSetImpl resourceSet1 = new ResourceSetImpl();
                    Resource resource = resourceSet1.getResource(URI.createURI((String)"http://www.eclipse.org/ocl/2015/Pivot", (boolean)true), true);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    resource.setURI(URI.createPlatformResourceURI((String)(String.valueOf(testProjectName) + "/" + "Pivot.oclas"), (boolean)true));
                    resource.save((OutputStream)outputStream, XMIUtil.createSaveOptions());
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IProject project = workspace.getRoot().getProject(testProjectName);
                    if (!project.exists()) {
                        project.create(null);
                    }
                    project.open(null);
                    IFile file = project.getFile("Pivot.oclas");
                    file.create((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), true, null);
                    IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
                    EcoreEditor openEditor = (EcoreEditor)IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (String)"org.eclipse.emf.ecore.presentation.ReflectiveEditorID", (boolean)true);
                    TestUIUtil.flushEvents();
                    ResourceSet resourceSet = openEditor.getEditingDomain().getResourceSet();
                    EList resources = resourceSet.getResources();
                    UsageTests.assertEquals((int)1, (int)resources.size());
                    Resource resource2 = (Resource)ClassUtil.nonNullState((Object)((Resource)resources.get(0)));
                    UsageTests.assertNoResourceErrors("Load", resource2);
                    UsageTests.assertNoValidationErrors("Validate", resource2);
                    openEditor.dispose();
                }
                ocl.dispose();
            }
        });
    }

    public void testOpen_Bug469251_uml() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                TestOCL ocl = UsageTests.this.createOCL();
                if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                    TestCaseAppender.INSTANCE.uninstall();
                    TestUIUtil.suppressGitPrefixPopUp();
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    TestUIUtil.closeIntro();
                    TestUIUtil.flushEvents();
                    UsageTests.this.getTestFile("Bug469251.profile.uml", (OCL)ocl, UsageTests.getTestModelURI("models/uml/Bug469251.profile.uml"));
                    UsageTests.this.getTestFile("Bug469251.uml", (OCL)ocl, UsageTests.getTestModelURI("models/uml/Bug469251.uml"));
                    IProject iProject = UsageTests.this.getTestProject().getIProject();
                    IFile modelFile = iProject.getFile("Bug469251.uml");
                    IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
                    UMLEditor umlEditor = (UMLEditor)IDE.openEditor((IWorkbenchPage)activePage, (IFile)modelFile, (String)"org.eclipse.uml2.uml.editor.presentation.UMLEditorID", (boolean)true);
                    TestUIUtil.flushEvents();
                    ResourceSet resourceSet = umlEditor.getEditingDomain().getResourceSet();
                    EList resources = resourceSet.getResources();
                    UsageTests.assertEquals((int)2, (int)resources.size());
                    Resource umlResource = (Resource)ClassUtil.nonNullState((Object)((Resource)resources.get(0)));
                    Model model = (Model)umlResource.getContents().get(0);
                    Type xx = model.getOwnedType("Class1");
                    UsageTests.assertNoResourceErrors("Load", umlResource);
                    UsageTests.assertValidationDiagnostics("Validate", umlResource, UsageTests.getMessages(EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"Constraint1", "\u00abStereotype1\u00bb" + LabelUtil.getLabel((Object)xx)})));
                    umlEditor.dispose();
                }
                ocl.dispose();
            }
        });
    }

    public void testPivotMetamodelImport414855() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                String testFileStem = "Bug414855";
                String testProjectName = "bug414855";
                String oclinecoreFile = "import pivot : 'http://www.eclipse.org/ocl/2015/Pivot#/';\npackage bug414855 : bug414855 = 'http://bug414855'\n{\n    datatype MyString : 'java.lang.String' { serializable };\n    class ClassExtension extends pivot::Class {}\n}\n";
                HashMap<@NonNull String, @Nullable String> genOptions = new HashMap<String, String>();
                genOptions.put("dynamicTemplates", "false");
                genOptions.put("templateDirectory", "/org.eclipse.ocl.examples.codegen/templates");
                genOptions.put("usedGenPackages", "platform:/plugin/org.eclipse.ocl.pivot/model/Pivot.genmodel#//pivot");
                String genmodelFile = UsageTests.this.createEcoreGenModelContent(testFileStem, genOptions);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                ocl.dispose();
            }
        });
    }

    public void testTemplateTypes471201() throws Throwable {
        this.doTestRunnable(new PivotTestCase.TestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ocl/2015/Library", (Object)OCLstdlibPackage.eINSTANCE);
                String testFileStem = "Bug471201";
                String testProjectName = "bug471201";
                String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage bug471201 : bug471201 = 'http://bug471201'\n{\n    class NamedElement {}\n    class LookupEnvironment\n    {\n\t\toperation(NE extends NamedElement) addElements(elements : NE[*] { ordered }) : LookupEnvironment[1]\n\t\t{\n\t\t\tbody: if elements->notEmpty() then addElements(OrderedSet(NamedElement){}) else self endif;\n\t\t}\n    }\n}\n";
                String genmodelFile = UsageTests.this.createEcoreGenModelContent(testFileStem, null);
                UsageTests.this.createManifestFile();
                URI genModelURI = UsageTests.this.createModels(testFileStem, oclinecoreFile, genmodelFile);
                UsageTests.this.doGenModel(genModelURI);
                TestOCL ocl = UsageTests.this.createOCL();
                UsageTests.this.doEcoreCompile((OCL)ocl, testProjectName);
                ocl.dispose();
            }
        });
    }

    private static final class TestUMLImporter
    extends UMLImporter {
        protected final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull EPackage.Registry packageRegistry;

        public TestUMLImporter(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull EPackage.Registry packageRegistry) {
            this.packageRegistry = packageRegistry;
        }

        public ResourceSet createResourceSet() {
            ResourceSet umlResourceSet = super.createResourceSet();
            UMLResourcesUtil.init((ResourceSet)umlResourceSet);
            umlResourceSet.getPackageRegistry().putAll((Map)this.packageRegistry);
            return umlResourceSet;
        }

        public void reloadGenModel(@NonNull Path genModelPath) throws Exception {
            this.defineOriginalGenModelPath((IPath)genModelPath);
            BasicMonitor monitor = new BasicMonitor();
            Diagnostic diagnostic = this.computeEPackages((Monitor)monitor);
            if (diagnostic.getSeverity() != 0) {
                String s = PivotUtil.formatDiagnostics((Diagnostic)diagnostic, (String)"\n");
                UsageTests.fail((String)("Reload failure" + s));
            }
            this.prepareGenModelAndEPackages((Monitor)monitor);
            Map saveOptions = this.getGenModelSaveOptions();
            for (Resource resource : this.computeResourcesToBeSaved()) {
                resource.save(saveOptions);
            }
        }
    }
}

