/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.console.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ocl.examples.xtext.console.OCLConsolePage;
import org.eclipse.ocl.examples.xtext.console.OCLResource;
import org.eclipse.ocl.examples.xtext.console.messages.ConsoleMessages;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LoadExpressionAction
extends Action {
    protected final OCLConsolePage consolePage;
    private final String tip;

    public LoadExpressionAction(OCLConsolePage consolePage) {
        super(ConsoleMessages.LoadAction_Label, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.consolePage = consolePage;
        this.tip = ConsoleMessages.LoadAction_Tip;
    }

    public String getToolTipText() {
        return this.tip;
    }

    public void run() {
        Shell shell = this.consolePage.getControl().getShell();
        FileDialog dlg = new FileDialog(shell, 4096);
        dlg.setFilterExtensions(new String[]{"*.xmi"});
        dlg.setText(ConsoleMessages.LoadAction_Title);
        String file = dlg.open();
        if (file != null) {
            try {
                String text = OCLResource.load(file);
                if (text != null) {
                    this.consolePage.getEditorDocument().set(text);
                } else {
                    MessageDialog.openWarning((Shell)shell, (String)ConsoleMessages.LoadActionWarning_Title, (String)ConsoleMessages.LoadActionWarning_NoExpression);
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)shell, (String)ConsoleMessages.LoadActionError_Title, (String)e.getLocalizedMessage());
            }
        }
    }
}

