/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidityPackage;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityViewRefreshJob;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class IDEValidityManager
extends ValidityManager {
    public static final int FAST_REFRESH_DELAY = 250;
    public static final int SLOW_REFRESH_DELAY = 2500;
    private static final @NonNull List<@NonNull Job> validityJobs = new ArrayList<Job>();
    private final @NonNull AbstractNodeAdapter nodeAdapter = new AbstractNodeAdapter();
    private final @NonNull ResultAdapter resultAdapter = new ResultAdapter();
    private @Nullable ValidityViewRefreshJob refreshJob = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopValidation() {
        while (!validityJobs.isEmpty()) {
            ArrayList<Job> jobs;
            List<Job> list = validityJobs;
            synchronized (list) {
                jobs = new ArrayList<Job>(validityJobs);
            }
            for (Job job : jobs) {
                job.cancel();
            }
        }
    }

    protected @NonNull ValidityModel createModel(@NonNull Collection<@NonNull Resource> newResources) {
        IDEValidityModel contents = new IDEValidityModel(this, newResources);
        RootNode rootNode = contents.getRootNode();
        this.installAdapters((List<? extends AbstractNode>)ClassUtil.nullFree((EList)rootNode.getConstrainingNodes()));
        this.installAdapters((List<? extends AbstractNode>)ClassUtil.nullFree((EList)rootNode.getValidatableNodes()));
        return contents;
    }

    public @NonNull String getConstrainingLabel(@NonNull EObject eObject) {
        if (eObject instanceof Model) {
            return ILabelGenerator.Registry.INSTANCE.labelFor((Object)eObject, LABEL_OPTIONS);
        }
        return super.getConstrainingLabel(eObject);
    }

    private void installAdapters(@NonNull List<@NonNull ? extends AbstractNode> nodes) {
        for (AbstractNode abstractNode : nodes) {
            abstractNode.eAdapters().add((Object)this.nodeAdapter);
            this.installAdapters((List<? extends AbstractNode>)ClassUtil.nullFree((EList)abstractNode.getChildren()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runValidation(@NonNull ValidityView validityView, @Nullable Set<ResultConstrainingNode> selectedNodes) {
        ValidityViewJob validationJob = new ValidityViewJob(validityView, selectedNodes);
        List<Job> list = validityJobs;
        synchronized (list) {
            validityJobs.add(validationJob);
        }
        validationJob.schedule();
    }

    public void redraw() {
        ValidityViewRefreshJob refreshJob2 = this.refreshJob;
        if (refreshJob2 != null) {
            refreshJob2.add(null);
        }
    }

    public void setRefreshJob(@NonNull ValidityViewRefreshJob refreshJob) {
        this.refreshJob = refreshJob;
    }

    public class AbstractNodeAdapter
    extends AdapterImpl {
        public void notifyChanged(Notification notification) {
            Object target;
            ValidityViewRefreshJob refreshJob2 = IDEValidityManager.this.refreshJob;
            if (refreshJob2 != null && (target = notification.getNotifier()) instanceof AbstractNode) {
                int event = notification.getEventType();
                Object feature = notification.getFeature();
                if (event == 1) {
                    if (feature == ValidityPackage.Literals.ABSTRACT_NODE__ENABLED) {
                        refreshJob2.add((AbstractNode)target);
                    } else if (feature == ValidityPackage.Literals.ABSTRACT_NODE__GRAYED) {
                        refreshJob2.add((AbstractNode)target);
                    } else if (feature == ValidityPackage.Literals.ABSTRACT_NODE__WORST_RESULT) {
                        refreshJob2.add((AbstractNode)target);
                    } else if (feature == ValidityPackage.Literals.ABSTRACT_NODE__LABEL) {
                        refreshJob2.add((AbstractNode)target);
                    }
                }
            }
        }
    }

    protected class IDEValidityModel
    extends ValidityModel {
        public IDEValidityModel(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NonNull @NonNull IDEValidityManager validityManager, Collection<Resource> newResources) {
            super((ValidityManager)validityManager, newResources);
        }

        protected @Nullable Result createResult(@Nullable IProgressMonitor monitor) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            Result result = super.createResult(monitor);
            if (result == null) {
                return null;
            }
            result.eAdapters().add((Object)IDEValidityManager.this.resultAdapter);
            return result;
        }
    }

    public class ResultAdapter
    extends AdapterImpl {
        public void notifyChanged(Notification notification) {
            Object target;
            ValidityViewRefreshJob refreshJob2 = IDEValidityManager.this.refreshJob;
            if (refreshJob2 != null && (target = notification.getNotifier()) instanceof Result) {
                Result result = (Result)target;
                int event = notification.getEventType();
                Object feature = notification.getFeature();
                if (event == 1 && feature == ValidityPackage.Literals.RESULT__SEVERITY) {
                    ResultValidatableNode resultValidatableNode;
                    ResultConstrainingNode resultConstrainingNode = result.getResultConstrainingNode();
                    if (resultConstrainingNode != null) {
                        refreshJob2.add((AbstractNode)resultConstrainingNode);
                        ConstrainingNode parent = resultConstrainingNode.getParent();
                        if (parent != null) {
                            refreshJob2.add((AbstractNode)parent);
                        }
                    }
                    if ((resultValidatableNode = result.getResultValidatableNode()) != null) {
                        refreshJob2.add((AbstractNode)resultValidatableNode);
                        ValidatableNode parent = resultValidatableNode.getParent();
                        if (parent != null) {
                            refreshJob2.add((AbstractNode)parent);
                        }
                    }
                }
            }
        }
    }

    private class ValidityViewJob
    extends Job {
        protected final @NonNull ValidityView validityView;
        protected final @Nullable Set<@NonNull ResultConstrainingNode> selectedNodes;

        private ValidityViewJob(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @NonNull ValidityView validityView, Set<ResultConstrainingNode> selectedNodes) {
            super("Validity View Validation");
            this.validityView = validityView;
            this.selectedNodes = selectedNodes;
        }

        protected IStatus run(IProgressMonitor monitor) {
            assert (monitor != null);
            IStatus status = IDEValidityManager.this.runValidation(this.selectedNodes, monitor);
            this.validityView.redraw();
            return status;
        }
    }
}

