/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.utilities.CGUtil;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.xtext.tests.ClasspathURIHandler;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.DebugTimestamp;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.ocl.xtext.base.BaseStandaloneSetup;
import org.eclipse.ocl.xtext.base.serializer.DeclarativeFormatter;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLStandaloneSetup;
import org.eclipse.ocl.xtext.idioms.IdiomsStandaloneSetup;
import org.eclipse.ocl.xtext.oclinecore.OCLinEcoreStandaloneSetup;
import org.eclipse.ocl.xtext.oclstdlib.OCLstdlibStandaloneSetup;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class IdiomsLoadTests
extends XtextTestCase {
    protected static final @NonNull String @NonNull [] NO_MESSAGES = new String[0];

    public @NonNull String readFile(@NonNull InputStream inputStream) throws IOException {
        int len;
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuilder s = new StringBuilder();
        char[] buf = new char[16384];
        while ((len = reader.read(buf)) >= 0) {
            s.append(buf, 0, len);
        }
        ((Reader)reader).close();
        return s.toString();
    }

    public @NonNull TestOCL createOCL() {
        return new TestOCL(this.getTestFileSystem(), "LoadTests", this.getName(), OCL.NO_PROJECTS, null);
    }

    public @NonNull TestOCL createOCLWithProjectMap() {
        return new TestOCL(this.getTestFileSystem(), "LoadTests", this.getName(), (ProjectManager)IdiomsLoadTests.getProjectMap(), null);
    }

    public Resource doLoad_Idioms(@NonNull OCL ocl, URI inputURI) throws IOException {
        ResourceSet resourceSet = this.doReformatInit(ocl);
        String oldText = this.doReformatReference(resourceSet, inputURI);
        String extension = inputURI.fileExtension();
        String stem = inputURI.trimFileExtension().lastSegment();
        String outputName = String.valueOf(stem) + "." + extension + ".xmi";
        String output2Name = String.valueOf(stem) + ".saved." + extension;
        URI outputURI = this.getTestFileURI(outputName);
        URI output2URI = this.getTestFileURI(output2Name);
        Resource xtextResource = null;
        xtextResource = resourceSet.getResource(inputURI, true);
        IdiomsLoadTests.assertNoResourceErrors("Load failed", xtextResource);
        IdiomsLoadTests.assertNoUnresolvedProxies("Unresolved proxies", xtextResource);
        IdiomsLoadTests.assertNoValidationErrors("Validation errors", (EObject)xtextResource.getContents().get(0));
        xtextResource.setURI(output2URI);
        DebugTimestamp debugTimestamp = new DebugTimestamp(xtextResource.getURI().toString());
        xtextResource.save(XMIUtil.createSaveOptions());
        debugTimestamp.log("Serialization save done");
        IdiomsLoadTests.assertNoResourceErrors("Save failed", xtextResource);
        InputStream newStream = resourceSet.getURIConverter().createInputStream(xtextResource.getURI(), null);
        String newText = this.readFile(newStream);
        IdiomsLoadTests.assertEquals((String)oldText, (String)newText);
        Resource xmiResource = resourceSet.createResource(outputURI);
        xmiResource.getContents().addAll((Collection)xtextResource.getContents());
        return xmiResource;
    }

    protected void doReformat(@NonNull OCL ocl, @NonNull DeclarativeFormatter declarativeFormatter, @NonNull URI inputURI, @NonNull URI referenceURI) throws IOException {
        ResourceSet resourceSet = this.doReformatInit(ocl);
        String referenceText = this.doReformatReference(resourceSet, referenceURI);
        EObject rootEObject = this.doReformatLoad(resourceSet, inputURI);
        ICompositeNode rootNode = NodeModelUtils.getNode((EObject)rootEObject);
        assert (rootNode != null);
        int rootOffset = rootNode.getOffset();
        int rootLength = rootNode.getLength();
        int totalOffset = rootNode.getTotalOffset();
        int totalLength = rootNode.getTotalLength();
        int selectOffset = rootOffset + rootLength / 4;
        int selectLength = rootLength / 2;
        this.doReformatText(declarativeFormatter, rootNode, selectOffset, selectLength, referenceText);
    }

    protected @NonNull ResourceSet doReformatInit(@NonNull OCL ocl) {
        ResourceSet resourceSet = ocl.getResourceSet();
        IdiomsLoadTests.getProjectMap().initializeResourceSet(resourceSet);
        return resourceSet;
    }

    private @NonNull EObject doReformatLoad(@NonNull ResourceSet resourceSet, @NonNull URI inputURI) {
        String extension = inputURI.fileExtension();
        String stem = inputURI.trimFileExtension().lastSegment();
        String outputName = String.valueOf(stem) + "." + extension + ".xmi";
        String output2Name = String.valueOf(stem) + ".saved." + extension;
        URI outputURI = this.getTestFileURI(outputName);
        URI output2URI = this.getTestFileURI(output2Name);
        Resource xtextResource = resourceSet.getResource(inputURI, true);
        IdiomsLoadTests.assertNoResourceErrors("Load failed", xtextResource);
        IdiomsLoadTests.assertNoUnresolvedProxies("Unresolved proxies", xtextResource);
        IdiomsLoadTests.assertNoValidationErrors("Validation errors", (EObject)xtextResource.getContents().get(0));
        xtextResource.setURI(output2URI);
        EObject rootEObject = (EObject)xtextResource.getContents().get(0);
        return rootEObject;
    }

    protected @NonNull String doReformatReference(@NonNull ResourceSet resourceSet, @NonNull URI referenceURI) throws IOException {
        InputStream referenceStream = resourceSet.getURIConverter().createInputStream(referenceURI, null);
        String referenceText = this.readFile(referenceStream);
        return referenceText;
    }

    protected void doReformatText(@NonNull DeclarativeFormatter declarativeFormatter, @NonNull ICompositeNode rootNode, int selectOffset, int selectLength, String referenceText) {
        String text = rootNode.getText();
        int selectEnd = selectOffset + selectLength;
        String unformattedText = text.substring(selectOffset, selectEnd);
        INodeModelFormatter.IFormattedRegion region = declarativeFormatter.format(rootNode, selectOffset, selectLength);
        String formattedText = String.valueOf(text.substring(0, selectOffset)) + region.getFormattedText() + text.substring(selectEnd);
        IdiomsLoadTests.assertEquals((String)referenceText, (String)formattedText);
    }

    protected @NonNull String replace(@NonNull LazyLinkingResource xtextResource, @NonNull ICompositeNode rootNode, @NonNull String oldString, @NonNull String newString) {
        String xtextContent = rootNode.getText();
        int index = xtextContent.indexOf(oldString);
        assert (index >= 0);
        xtextResource.update(index, oldString.length(), newString);
        return rootNode.getText();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IdiomsStandaloneSetup.doSetup();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIdiomsLoad_Base_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("Base.idioms", BaseStandaloneSetup.class.getResourceAsStream("Base.idioms"));
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_CompleteOCL_idioms() throws IOException, InterruptedException {
        if (CGUtil.isMavenSurefire() || CGUtil.isTychoSurefire()) {
            System.err.println(String.valueOf(this.getName()) + " has been disabled -see Bug 569138");
            return;
        }
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("CompleteOCL.idioms", CompleteOCLStandaloneSetup.class.getResourceAsStream("CompleteOCL.idioms"));
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_DebugTest_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/models/idioms/DebugTest.idioms", (boolean)true);
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Reformat_DebugTest_idioms() throws IOException, InterruptedException {
        DeclarativeFormatter declarativeFormatter = (DeclarativeFormatter)new IdiomsStandaloneSetup().createInjector().getInstance(DeclarativeFormatter.class);
        TestOCL ocl = this.createOCL();
        URI idiomsURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/models/idioms/DebugTest.idioms", (boolean)true);
        this.doReformat((OCL)ocl, declarativeFormatter, idiomsURI, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_EssentialOCL_idioms() throws IOException, InterruptedException {
        if (CGUtil.isMavenSurefire() || CGUtil.isTychoSurefire()) {
            System.err.println(String.valueOf(this.getName()) + " has been disabled -see Bug 569138");
            return;
        }
        TestUtil.doEssentialOCLSetup();
        TestUtil.doXtextSetup();
        TestOCL ocl = this.createOCL();
        ClasspathURIHandler.init(ocl.getResourceSet());
        URI idiomsURI = this.getTestFileURI("EssentialOCL.idioms", EssentialOCLStandaloneSetup.class.getResourceAsStream("EssentialOCL.idioms"));
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Idioms_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("Idioms.idioms", IdiomsStandaloneSetup.class.getResourceAsStream("Idioms.idioms"));
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Reformat_Idioms_idioms() throws IOException, InterruptedException {
        DeclarativeFormatter declarativeFormatter = (DeclarativeFormatter)new IdiomsStandaloneSetup().createInjector().getInstance(DeclarativeFormatter.class);
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("Idioms.idioms", IdiomsStandaloneSetup.class.getResourceAsStream("Idioms.idioms"));
        ResourceSet resourceSet = this.doReformatInit((OCL)ocl);
        String referenceText = this.doReformatReference(resourceSet, idiomsURI);
        EObject rootEObject = this.doReformatLoad(resourceSet, idiomsURI);
        ICompositeNode rootNode = NodeModelUtils.getNode((EObject)rootEObject);
        assert (rootNode != null);
        this.doReformatText(declarativeFormatter, rootNode, 0, referenceText.length(), referenceText);
        int i = 0;
        while (i <= 5) {
            this.doReformatText(declarativeFormatter, rootNode, i, referenceText.length() - i, referenceText);
            this.doReformatText(declarativeFormatter, rootNode, 0, referenceText.length() - i, referenceText);
            ++i;
        }
        int endHeaderOffset = referenceText.indexOf("*******/") - 8;
        assert (endHeaderOffset >= 0);
        this.doReformatText(declarativeFormatter, rootNode, endHeaderOffset, 0, referenceText);
        int i2 = endHeaderOffset - 5;
        while (i2 < endHeaderOffset + 5) {
            this.doReformatText(declarativeFormatter, rootNode, endHeaderOffset, 0, referenceText);
            ++i2;
        }
        i2 = endHeaderOffset - 15;
        while (i2 < endHeaderOffset + 5) {
            this.doReformatText(declarativeFormatter, rootNode, endHeaderOffset, 10, referenceText);
            ++i2;
        }
        String key = "//mixin idiom COMMENTS at final do PRE_COMMENT value POST_COMMENT;";
        int keyOffset = referenceText.indexOf(key);
        assert (100 < keyOffset && keyOffset + 100 < referenceText.length());
        int keyLength = key.length();
        this.doReformatText(declarativeFormatter, rootNode, keyOffset + 32, 100, referenceText);
        int i3 = -5;
        while (i3 < keyLength + 5) {
            this.doReformatText(declarativeFormatter, rootNode, keyOffset + i3, 100, referenceText);
            ++i3;
        }
        String indentedKey = "\tat \"{\"";
        String deficientIndentedKey = "at \"{\"";
        String replacedText = this.replace((LazyLinkingResource)rootEObject.eResource(), rootNode, indentedKey, deficientIndentedKey);
        int indentedOffset = referenceText.indexOf(indentedKey);
        int indentedWindow = 15;
        assert (rootNode == NodeModelUtils.getNode((EObject)rootEObject));
        int i1 = -indentedWindow - 2;
        this.doReformatText(declarativeFormatter, rootNode, indentedOffset + i1, indentedWindow, replacedText);
        int i22 = -indentedWindow - 1;
        this.doReformatText(declarativeFormatter, rootNode, indentedOffset + i22, indentedWindow, replacedText);
        int i4 = -indentedWindow - 2;
        while (i4 < -indentedWindow) {
            this.doReformatText(declarativeFormatter, rootNode, indentedOffset + i4, indentedWindow, replacedText);
            ++i4;
        }
        i4 = -indentedWindow;
        while (i4 < 0) {
            this.doReformatText(declarativeFormatter, rootNode, indentedOffset + i4, indentedWindow, referenceText);
            ++i4;
        }
        i4 = 0;
        while (i4 < indentedWindow) {
            this.doReformatText(declarativeFormatter, rootNode, indentedOffset + i4, indentedWindow, replacedText);
            ++i4;
        }
        this.replace((LazyLinkingResource)rootEObject.eResource(), rootNode, deficientIndentedKey, indentedKey);
        indentedKey = "at \"{\"";
        String excessIndentedKey = "\tat \"{\"";
        replacedText = this.replace((LazyLinkingResource)rootEObject.eResource(), rootNode, indentedKey, excessIndentedKey);
        indentedOffset = referenceText.indexOf(indentedKey);
        indentedWindow = 15;
        assert (rootNode == NodeModelUtils.getNode((EObject)rootEObject));
        int i5 = -indentedWindow - 2;
        while (i5 < -indentedWindow) {
            this.doReformatText(declarativeFormatter, rootNode, indentedOffset + i5, indentedWindow, replacedText);
            ++i5;
        }
        i5 = -indentedWindow;
        while (i5 < 0) {
            this.doReformatText(declarativeFormatter, rootNode, indentedOffset + i5, indentedWindow, referenceText);
            ++i5;
        }
        i5 = 0;
        while (i5 < indentedWindow) {
            this.doReformatText(declarativeFormatter, rootNode, indentedOffset + i5, indentedWindow, replacedText);
            ++i5;
        }
        this.replace((LazyLinkingResource)rootEObject.eResource(), rootNode, excessIndentedKey, indentedKey);
        ocl.dispose();
    }

    public void zztestIdiomsLoad_Reformat_Idioms_idioms1() throws IOException, InterruptedException {
        DeclarativeFormatter declarativeFormatter = (DeclarativeFormatter)new IdiomsStandaloneSetup().createInjector().getInstance(DeclarativeFormatter.class);
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("Idioms.idioms", IdiomsStandaloneSetup.class.getResourceAsStream("Idioms.idioms"));
        ResourceSet resourceSet = this.doReformatInit((OCL)ocl);
        String referenceText = this.doReformatReference(resourceSet, idiomsURI);
        EObject rootEObject = this.doReformatLoad(resourceSet, idiomsURI);
        ICompositeNode rootNode = NodeModelUtils.getNode((EObject)rootEObject);
        assert (rootNode != null);
        String indentedKey = "\tat \"{\"";
        String deficientIndentedKey = "at \"{\"";
        String replacedText = this.replace((LazyLinkingResource)rootEObject.eResource(), rootNode, indentedKey, deficientIndentedKey);
        int indentedOffset = referenceText.indexOf(indentedKey);
        int indentedWindow = 15;
        assert (rootNode == NodeModelUtils.getNode((EObject)rootEObject));
        int i1 = -indentedWindow - 2;
        int i2 = -indentedWindow - 1;
        System.out.println(String.valueOf(i2) + " " + (indentedOffset + i2));
        this.doReformatText(declarativeFormatter, rootNode, indentedOffset + i2, indentedWindow, replacedText);
        ocl.dispose();
    }

    public void zztestIdiomsLoad_Reformat_Idioms_idioms2() throws IOException, InterruptedException {
        DeclarativeFormatter declarativeFormatter = (DeclarativeFormatter)new IdiomsStandaloneSetup().createInjector().getInstance(DeclarativeFormatter.class);
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("Idioms.idioms", IdiomsStandaloneSetup.class.getResourceAsStream("Idioms.idioms"));
        ResourceSet resourceSet = this.doReformatInit((OCL)ocl);
        String referenceText = this.doReformatReference(resourceSet, idiomsURI);
        EObject rootEObject = this.doReformatLoad(resourceSet, idiomsURI);
        ICompositeNode rootNode = NodeModelUtils.getNode((EObject)rootEObject);
        assert (rootNode != null);
        String key = "//mixin idiom COMMENTS at final do PRE_COMMENT value POST_COMMENT;";
        int keyOffset = referenceText.indexOf(key);
        assert (100 < keyOffset && keyOffset + 100 < referenceText.length());
        int keyLength = key.length();
        this.doReformatText(declarativeFormatter, rootNode, keyOffset + 32, 100, referenceText);
        ocl.dispose();
    }

    public void zztestIdiomsLoad_Reformat_Idioms_idioms3() throws IOException, InterruptedException {
        DeclarativeFormatter declarativeFormatter = (DeclarativeFormatter)new IdiomsStandaloneSetup().createInjector().getInstance(DeclarativeFormatter.class);
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("Idioms.idioms", IdiomsStandaloneSetup.class.getResourceAsStream("Idioms.idioms"));
        ResourceSet resourceSet = this.doReformatInit((OCL)ocl);
        String referenceText = this.doReformatReference(resourceSet, idiomsURI);
        EObject rootEObject = this.doReformatLoad(resourceSet, idiomsURI);
        ICompositeNode rootNode = NodeModelUtils.getNode((EObject)rootEObject);
        assert (rootNode != null);
        String key = "//mixin idiom COMMENTS at final do PRE_COMMENT value POST_COMMENT;";
        int keyOffset = referenceText.indexOf(key);
        assert (100 < keyOffset && keyOffset + 100 < referenceText.length());
        int i = -2;
        System.out.println(i);
        this.doReformatText(declarativeFormatter, rootNode, keyOffset + i, 100, referenceText);
        ocl.dispose();
    }

    public void testIdiomsLoad_OCLinEcore_idioms() throws IOException, InterruptedException {
        if (CGUtil.isMavenSurefire() || CGUtil.isTychoSurefire()) {
            System.err.println(String.valueOf(this.getName()) + " has been disabled -see Bug 569138");
            return;
        }
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("OCLinEcore.idioms", OCLinEcoreStandaloneSetup.class.getResourceAsStream("OCLinEcore.idioms"));
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_OCLstdlib_idioms() throws IOException, InterruptedException {
        if (CGUtil.isMavenSurefire() || CGUtil.isTychoSurefire()) {
            System.err.println(String.valueOf(this.getName()) + " has been disabled -see Bug 569138");
            return;
        }
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("OCLstdlib.idioms", OCLstdlibStandaloneSetup.class.getResourceAsStream("OCLstdlib.idioms"));
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Test_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/models/idioms/Test.idioms", (boolean)true);
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Xtext_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/models/idioms/Xtext.idioms", (boolean)true);
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Reformat_Tutorial_oclinecore() throws IOException, InterruptedException {
        DeclarativeFormatter declarativeFormatter = (DeclarativeFormatter)new OCLinEcoreStandaloneSetup().createInjector().getInstance(DeclarativeFormatter.class);
        TestOCL ocl = this.createOCL();
        URI inputURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/models/documentation/Tutorial.oclinecore", (boolean)true);
        URI referenceURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/models/documentation/Tutorial.reformatted.oclinecore", (boolean)true);
        this.doReformat((OCL)ocl, declarativeFormatter, inputURI, referenceURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Reformat_Xtext_idioms() throws IOException, InterruptedException {
        DeclarativeFormatter declarativeFormatter = (DeclarativeFormatter)new IdiomsStandaloneSetup().createInjector().getInstance(DeclarativeFormatter.class);
        TestOCL ocl = this.createOCL();
        URI idiomsURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/models/idioms/Xtext.idioms", (boolean)true);
        this.doReformat((OCL)ocl, declarativeFormatter, idiomsURI, idiomsURI);
        ocl.dispose();
    }
}

