/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.test.xtext.LoadTests;
import org.eclipse.ocl.examples.uml25.XMI252UMLResourceFactoryImpl;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.internal.utilities.GlobalEnvironmentFactory;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.util.PivotValidator;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;

public class UML25LoadTests
extends LoadTests {
    protected @Nullable Map<URI, URI> extraURImap = null;

    public @NonNull TestOCL createOCL(@Nullable URI modelFolderURI) {
        if (modelFolderURI == null) {
            return super.createOCL();
        }
        UMLStandaloneSetup.init();
        TestOCL ocl = new TestOCL(this.getTestFileSystem(), "UML25LoadTests", this.getName(), OCL.NO_PROJECTS);
        ResourceSet resourceSet = ocl.getResourceSet();
        this.extraURImap = XMI252UMLResourceFactoryImpl.install((ResourceSet)resourceSet, (URI)modelFolderURI);
        this.initializeExtraURIMappings(resourceSet);
        return ocl;
    }

    @Override
    public @NonNull TestOCL createOCLWithProjectMap() {
        UMLStandaloneSetup.init();
        TestOCL ocl = new TestOCL(this.getTestFileSystem(), "UML25LoadTests", this.getName(), (ProjectManager)UML25LoadTests.getProjectMap());
        ResourceSet resourceSet = ocl.getResourceSet();
        return ocl;
    }

    @Override
    protected void initializeExtraURIMappings(@NonNull ResourceSet resourceSet) {
        if (this.extraURImap != null) {
            resourceSet.getURIConverter().getURIMap().putAll(this.extraURImap);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.extraURImap = null;
        EValidator.Registry.INSTANCE.put((Object)PivotPackage.eINSTANCE, (Object)PivotValidator.INSTANCE);
        super.tearDown();
    }

    public void testLoad_UML_2_5_Final_PrimitiveTypes() throws IOException, InterruptedException, ParserException {
        URI modelFolderURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/", (boolean)true);
        URI modelURI = modelFolderURI.trimSegments(1).appendSegment("PrimitiveTypes.xmi");
        TestOCL ocl = this.createOCL(modelFolderURI);
        this.doLoadUML((OCL)ocl, modelURI, false, true, NO_MESSAGES, null);
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_DC() throws IOException, InterruptedException, ParserException {
        URI modelFolderURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/", (boolean)true);
        URI modelURI = modelFolderURI.trimSegments(1).appendSegment("DC.xmi");
        TestOCL ocl = this.createOCL(modelFolderURI);
        this.doLoadUML((OCL)ocl, modelURI, false, true, NO_MESSAGES, null);
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_DI() throws IOException, InterruptedException, ParserException {
        URI modelFolderURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/", (boolean)true);
        URI modelURI = modelFolderURI.trimSegments(1).appendSegment("DI.xmi");
        TestOCL ocl = this.createOCL(modelFolderURI);
        this.doLoadUML((OCL)ocl, modelURI, false, true, NO_MESSAGES, null);
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_DG() throws IOException, InterruptedException, ParserException {
        URI modelFolderURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/", (boolean)true);
        URI modelURI = modelFolderURI.trimSegments(1).appendSegment("DG.xmi");
        TestOCL ocl = this.createOCL(modelFolderURI);
        this.doLoadUML((OCL)ocl, modelURI, false, true, NO_MESSAGES, new String[]{"The 'Class::NameIsNotNull' constraint is violated for 'DG::null'"});
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_UML() throws IOException, InterruptedException, ParserException {
        URI modelFolderURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/", (boolean)true);
        URI modelURI = modelFolderURI.trimSegments(1).appendSegment("UML.xmi");
        TestOCL ocl = this.createOCL(modelFolderURI);
        GlobalEnvironmentFactory.getInstance().setSafeNavigationValidationSeverity(StatusCodes.Severity.IGNORE);
        this.doLoadUML((OCL)ocl, modelURI, false, true, null, null);
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_UMLDI() throws IOException, InterruptedException, ParserException {
        URI modelFolderURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/", (boolean)true);
        URI modelURI = modelFolderURI.trimSegments(1).appendSegment("DI.xmi");
        TestOCL ocl = this.createOCL(modelFolderURI);
        GlobalEnvironmentFactory.getInstance().setSafeNavigationValidationSeverity(StatusCodes.Severity.IGNORE);
        this.doLoadUML((OCL)ocl, modelURI, false, true, NO_MESSAGES, null);
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_StandardProfile() throws IOException, InterruptedException, ParserException {
        URI modelFolderURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/", (boolean)true);
        URI modelURI = modelFolderURI.trimSegments(1).appendSegment("StandardProfile.xmi");
        TestOCL ocl = this.createOCL(modelFolderURI);
        this.doLoadUML((OCL)ocl, modelURI, false, true, NO_MESSAGES, null);
        ocl.dispose();
    }
}

