/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.generic;

import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;

public abstract class GenericParserBacktrackingTest
extends PivotTestSuite {
    public void test_reservedKeywordAsIdentifier() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: package endpackage", "\"<simpleName>\" expected instead of \"package\"");
    }

    public void test_reservedKeywordAsPropertyName() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: self.endif endpackage", "\"<simpleName>\" expected instead of \"endif\"");
    }

    public void test_reservedKeywordAsOperationName() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: self.else() endpackage", "\"<simpleName>\" expected instead of \"else\"");
    }

    public void test_reservedKeywordAsPathNamePrefix() {
        this.checkDocumentWithParseFailure("package ecore context if::xx inv: true endpackage", "\"<simpleName>\" expected instead of \"if\"");
    }

    public void test_reservedKeywordAsPathNameMidfix() {
        this.checkDocumentWithParseFailure("package ecore context xx::if::yy inv: true endpackage", "\"<simpleName>\" expected instead of \"if\"");
    }

    public void test_reservedKeywordAsPathNameSuffix() {
        this.checkDocumentWithParseFailure("package ecore context xx::if inv: true endpackage", "\"<simpleName>\" expected instead of \"if\"");
    }

    public void test_punctuationAsOperationName() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: self. .. () endpackage", "\"<simpleName>\" expected instead of \"..\"");
    }

    public void test_missingEndPackage() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: true", "\"endpackage\" expected after \"true\"");
    }

    public void test_ifMissingCondition() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: if then else false endif endpackage", "\"then <expr> else <expr>\" expected instead of \"endif\"");
    }

    public void test_ifMissingThen() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: if true true else false endif endpackage", "\"then <expr> else <expr> endif\" expected instead of \"true else false endif\"");
    }

    public void test_ifMissingThenExpression() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: if true then else false endif endpackage", "\"<simpleName>\" expected after \"then\"");
    }

    public void test_ifMissingElse() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: if true then true false endif endpackage", "\"else <expr> endif\" expected instead of \"false endif\"");
    }

    public void test_ifMissingElseExpression() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: if true then true else endif endpackage", "\"<simpleName>\" expected after \"else\"");
    }

    public void test_ifMissingEndif() {
        this.checkDocumentWithParseFailure("package ecore context EClass inv: if true then true else false endpackage", "\"endif\" expected after \"false\"");
    }

    private void checkDocumentWithParseFailure(String oclText, String failure) {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".checkDocumentWithParseFailure");
    }
}

