/*******************************************************************************
 * Copyright (c) 2006 - 2012 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.cpp.codegen.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.Activator;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.EnumStyle;
import org.eclipse.uml2.uml.Enumeration;

/**
 * Utility class that returns the preference values (eventually taking
 * stereotypes into account)
 */
public class CppCodeGenUtils {

	protected static IPreferenceStore preferenceStore = null;

	public static String getHeaderSuffix() {
		initPreferenceStore();
		return preferenceStore.getString(CppCodeGenConstants.P_HEADER_SUFFIX);
	}

	public static String getBodySuffix() {
		initPreferenceStore();
		return preferenceStore.getString(CppCodeGenConstants.P_IMPLEM_SUFFIX);
	}

	public static String getOutInoutOp() {
		initPreferenceStore();
		return preferenceStore.getString(CppCodeGenConstants.P_OUT_INOUT_OP);
	}

	public static String getCommentHeader() {
		initPreferenceStore();
		return preferenceStore.getString(CppCodeGenConstants.P_COMMENT_HEADER);
	}

	public static boolean getFormatCode() {
		initPreferenceStore();
		return preferenceStore.getBoolean(CppCodeGenConstants.P_FORMAT_CODE);
	}

	public static void initPreferenceStore() {
		if (preferenceStore == null) {
			preferenceStore = Activator.getDefault().getPreferenceStore();
		}
	}

	public static boolean getUsingNamespaces() {
		initPreferenceStore();
		return preferenceStore.getBoolean(CppCodeGenConstants.P_USING_NAMESPACES);
	}

	public static boolean getC11ClassEnum(Enumeration enumeration) {
		EnumStyle enumStyle = GenUtils.getApplicationTree(enumeration, EnumStyle.class);
		if (enumStyle != null) {
			return enumStyle.isClassEnum();
		}
		initPreferenceStore();
		return preferenceStore.getBoolean(CppCodeGenConstants.P_CPP11_CLASS_ENUM);
	}
}
