package org.eclipse.papyrus.designer.languages.c.codegen.doxygen;

import org.eclipse.papyrus.designer.languages.c.codegen.lib.CommonScript;
import org.eclipse.uml2.uml.Model;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class DoxyfileScript {
  public static CharSequence doxyfileScript(final Model model) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// This template is called by the main module file ");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# Project related configuration options");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("PROJECT_NAME           = ");
    CharSequence _genName = CommonScript.genName(model);
    _builder.append(_genName);
    _builder.newLineIfNotEmpty();
    _builder.append("PROJECT_NUMBER         = ");
    _builder.newLine();
    _builder.append("OUTPUT_DIRECTORY       = ./docs/");
    _builder.newLine();
    _builder.append("CREATE_SUBDIRS         = NO");
    _builder.newLine();
    _builder.append("OUTPUT_LANGUAGE        = English");
    _builder.newLine();
    _builder.append("USE_WINDOWS_ENCODING   = NO");
    _builder.newLine();
    _builder.append("BRIEF_MEMBER_DESC      = YES");
    _builder.newLine();
    _builder.append("REPEAT_BRIEF           = YES");
    _builder.newLine();
    _builder.append("ABBREVIATE_BRIEF       = ");
    _builder.newLine();
    _builder.append("ALWAYS_DETAILED_SEC    = NO");
    _builder.newLine();
    _builder.append("INLINE_INHERITED_MEMB  = NO");
    _builder.newLine();
    _builder.append("FULL_PATH_NAMES        = NO");
    _builder.newLine();
    _builder.append("STRIP_FROM_PATH        = ");
    _builder.newLine();
    _builder.append("STRIP_FROM_INC_PATH    = ");
    _builder.newLine();
    _builder.append("SHORT_NAMES            = NO");
    _builder.newLine();
    _builder.append("JAVADOC_AUTOBRIEF      = NO");
    _builder.newLine();
    _builder.append("MULTILINE_CPP_IS_BRIEF = NO");
    _builder.newLine();
    _builder.append("DETAILS_AT_TOP         = NO");
    _builder.newLine();
    _builder.append("INHERIT_DOCS           = YES");
    _builder.newLine();
    _builder.append("SEPARATE_MEMBER_PAGES  = NO");
    _builder.newLine();
    _builder.append("TAB_SIZE               = 4");
    _builder.newLine();
    _builder.append("ALIASES                = ");
    _builder.newLine();
    _builder.append("OPTIMIZE_OUTPUT_FOR_C  = YES");
    _builder.newLine();
    _builder.append("OPTIMIZE_OUTPUT_JAVA   = NO");
    _builder.newLine();
    _builder.append("BUILTIN_STL_SUPPORT    = NO");
    _builder.newLine();
    _builder.append("DISTRIBUTE_GROUP_DOC   = NO");
    _builder.newLine();
    _builder.append("SUBGROUPING            = YES");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# Build related configuration options");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("EXTRACT_ALL            = YES");
    _builder.newLine();
    _builder.append("EXTRACT_PRIVATE        = NO");
    _builder.newLine();
    _builder.append("EXTRACT_STATIC         = NO");
    _builder.newLine();
    _builder.append("EXTRACT_LOCAL_CLASSES  = YES");
    _builder.newLine();
    _builder.append("EXTRACT_LOCAL_METHODS  = NO");
    _builder.newLine();
    _builder.append("HIDE_UNDOC_MEMBERS     = YES");
    _builder.newLine();
    _builder.append("HIDE_UNDOC_CLASSES     = YES");
    _builder.newLine();
    _builder.append("HIDE_FRIEND_COMPOUNDS  = NO");
    _builder.newLine();
    _builder.append("HIDE_IN_BODY_DOCS      = NO");
    _builder.newLine();
    _builder.append("INTERNAL_DOCS          = NO");
    _builder.newLine();
    _builder.append("CASE_SENSE_NAMES       = YES");
    _builder.newLine();
    _builder.append("HIDE_SCOPE_NAMES       = NO");
    _builder.newLine();
    _builder.append("SHOW_INCLUDE_FILES     = YES");
    _builder.newLine();
    _builder.append("INLINE_INFO            = YES");
    _builder.newLine();
    _builder.append("SORT_MEMBER_DOCS       = YES");
    _builder.newLine();
    _builder.append("SORT_BRIEF_DOCS        = NO");
    _builder.newLine();
    _builder.append("SORT_BY_SCOPE_NAME     = NO");
    _builder.newLine();
    _builder.append("GENERATE_TODOLIST      = YES");
    _builder.newLine();
    _builder.append("GENERATE_TESTLIST      = YES");
    _builder.newLine();
    _builder.append("GENERATE_BUGLIST       = YES");
    _builder.newLine();
    _builder.append("GENERATE_DEPRECATEDLIST= YES");
    _builder.newLine();
    _builder.append("ENABLED_SECTIONS       = ");
    _builder.newLine();
    _builder.append("MAX_INITIALIZER_LINES  = 30");
    _builder.newLine();
    _builder.append("SHOW_USED_FILES        = YES");
    _builder.newLine();
    _builder.append("SHOW_DIRECTORIES       = YES");
    _builder.newLine();
    _builder.append("FILE_VERSION_FILTER    = ");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# configuration options related to warning and progress messages");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("QUIET                  = NO");
    _builder.newLine();
    _builder.append("WARNINGS               = YES");
    _builder.newLine();
    _builder.append("WARN_IF_UNDOCUMENTED   = YES");
    _builder.newLine();
    _builder.append("WARN_IF_DOC_ERROR      = YES");
    _builder.newLine();
    _builder.append("WARN_NO_PARAMDOC       = NO");
    _builder.newLine();
    _builder.append("WARN_FORMAT            = \"$file:$line: $text\"");
    _builder.newLine();
    _builder.append("WARN_LOGFILE           = ");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# configuration options related to the input files");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("INPUT                  = ");
    CharSequence _genPackagePaths = DoxyfileScript.genPackagePaths(model);
    _builder.append(_genPackagePaths);
    _builder.newLineIfNotEmpty();
    _builder.append("FILE_PATTERNS          = *.c \\");
    _builder.newLine();
    _builder.append("                         ");
    _builder.append("*.h");
    _builder.newLine();
    _builder.append("RECURSIVE              = YES");
    _builder.newLine();
    _builder.append("EXCLUDE                = ");
    _builder.newLine();
    _builder.append("EXCLUDE_SYMLINKS       = NO");
    _builder.newLine();
    _builder.append("EXCLUDE_PATTERNS       = ");
    _builder.newLine();
    _builder.append("EXAMPLE_PATH           = ");
    _builder.newLine();
    _builder.append("EXAMPLE_PATTERNS       = ");
    _builder.newLine();
    _builder.append("EXAMPLE_RECURSIVE      = NO");
    _builder.newLine();
    _builder.append("IMAGE_PATH             = ./docs/pictures/");
    _builder.newLine();
    _builder.append("INPUT_FILTER           = ");
    _builder.newLine();
    _builder.append("FILTER_PATTERNS        = ");
    _builder.newLine();
    _builder.append("FILTER_SOURCE_FILES    = NO");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# configuration options related to source browsing");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("SOURCE_BROWSER         = YES");
    _builder.newLine();
    _builder.append("INLINE_SOURCES         = YES");
    _builder.newLine();
    _builder.append("STRIP_CODE_COMMENTS    = YES");
    _builder.newLine();
    _builder.append("REFERENCED_BY_RELATION = YES");
    _builder.newLine();
    _builder.append("REFERENCES_RELATION    = YES");
    _builder.newLine();
    _builder.append("REFERENCES_LINK_SOURCE = YES");
    _builder.newLine();
    _builder.append("USE_HTAGS              = NO");
    _builder.newLine();
    _builder.append("VERBATIM_HEADERS       = YES");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# configuration options related to the alphabetical class index");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("ALPHABETICAL_INDEX     = YES");
    _builder.newLine();
    _builder.append("COLS_IN_ALPHA_INDEX    = 5");
    _builder.newLine();
    _builder.append("IGNORE_PREFIX          = ");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# configuration options related to the HTML output");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("GENERATE_HTML          = YES");
    _builder.newLine();
    _builder.append("HTML_OUTPUT            = html");
    _builder.newLine();
    _builder.append("HTML_FILE_EXTENSION    = .html");
    _builder.newLine();
    _builder.append("HTML_HEADER            = ");
    _builder.newLine();
    _builder.append("HTML_FOOTER            = ");
    _builder.newLine();
    _builder.append("HTML_STYLESHEET        = ");
    _builder.newLine();
    _builder.append("HTML_ALIGN_MEMBERS     = YES");
    _builder.newLine();
    _builder.append("GENERATE_HTMLHELP      = NO");
    _builder.newLine();
    _builder.append("CHM_FILE               = ");
    _builder.newLine();
    _builder.append("HHC_LOCATION           = ");
    _builder.newLine();
    _builder.append("GENERATE_CHI           = NO");
    _builder.newLine();
    _builder.append("BINARY_TOC             = NO");
    _builder.newLine();
    _builder.append("TOC_EXPAND             = NO");
    _builder.newLine();
    _builder.append("DISABLE_INDEX          = NO");
    _builder.newLine();
    _builder.append("ENUM_VALUES_PER_LINE   = 4");
    _builder.newLine();
    _builder.append("GENERATE_TREEVIEW      = YES");
    _builder.newLine();
    _builder.append("TREEVIEW_WIDTH         = 250");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# configuration options related to the LaTeX output");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("GENERATE_LATEX         = NO");
    _builder.newLine();
    _builder.append("LATEX_OUTPUT           = latex");
    _builder.newLine();
    _builder.append("LATEX_CMD_NAME         = latex");
    _builder.newLine();
    _builder.append("MAKEINDEX_CMD_NAME     = makeindex");
    _builder.newLine();
    _builder.append("COMPACT_LATEX          = NO");
    _builder.newLine();
    _builder.append("PAPER_TYPE             = a4wide");
    _builder.newLine();
    _builder.append("EXTRA_PACKAGES         = ");
    _builder.newLine();
    _builder.append("LATEX_HEADER           = ");
    _builder.newLine();
    _builder.append("PDF_HYPERLINKS         = NO");
    _builder.newLine();
    _builder.append("USE_PDFLATEX           = NO");
    _builder.newLine();
    _builder.append("LATEX_BATCHMODE        = NO");
    _builder.newLine();
    _builder.append("LATEX_HIDE_INDICES     = NO");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# configuration options related to the RTF output");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("GENERATE_RTF           = NO");
    _builder.newLine();
    _builder.append("RTF_OUTPUT             = rtf");
    _builder.newLine();
    _builder.append("COMPACT_RTF            = NO");
    _builder.newLine();
    _builder.append("RTF_HYPERLINKS         = NO");
    _builder.newLine();
    _builder.append("RTF_STYLESHEET_FILE    = ");
    _builder.newLine();
    _builder.append("RTF_EXTENSIONS_FILE    = ");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# configuration options related to the man page output");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("GENERATE_MAN           = NO");
    _builder.newLine();
    _builder.append("MAN_OUTPUT             = man");
    _builder.newLine();
    _builder.append("MAN_EXTENSION          = .3");
    _builder.newLine();
    _builder.append("MAN_LINKS              = NO");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# configuration options related to the XML output");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("GENERATE_XML           = NO");
    _builder.newLine();
    _builder.append("XML_OUTPUT             = xml");
    _builder.newLine();
    _builder.append("XML_SCHEMA             = ");
    _builder.newLine();
    _builder.append("XML_DTD                = ");
    _builder.newLine();
    _builder.append("XML_PROGRAMLISTING     = YES");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# configuration options for the AutoGen Definitions output");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("GENERATE_AUTOGEN_DEF   = NO");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# configuration options related to the Perl module output");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("GENERATE_PERLMOD       = NO");
    _builder.newLine();
    _builder.append("PERLMOD_LATEX          = NO");
    _builder.newLine();
    _builder.append("PERLMOD_PRETTY         = YES");
    _builder.newLine();
    _builder.append("PERLMOD_MAKEVAR_PREFIX = ");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# Configuration options related to the preprocessor   ");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("ENABLE_PREPROCESSING   = YES");
    _builder.newLine();
    _builder.append("MACRO_EXPANSION        = NO");
    _builder.newLine();
    _builder.append("EXPAND_ONLY_PREDEF     = NO");
    _builder.newLine();
    _builder.append("SEARCH_INCLUDES        = YES");
    _builder.newLine();
    _builder.append("INCLUDE_PATH           = ");
    _builder.newLine();
    _builder.append("INCLUDE_FILE_PATTERNS  = ");
    _builder.newLine();
    _builder.append("PREDEFINED             = ");
    _builder.newLine();
    _builder.append("EXPAND_AS_DEFINED      = ");
    _builder.newLine();
    _builder.append("SKIP_FUNCTION_MACROS   = YES");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# Configuration.additions related to external references   ");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("TAGFILES               = ");
    _builder.newLine();
    _builder.append("GENERATE_TAGFILE       = ");
    _builder.newLine();
    _builder.append("ALLEXTERNALS           = NO");
    _builder.newLine();
    _builder.append("EXTERNAL_GROUPS        = YES");
    _builder.newLine();
    _builder.append("PERL_PATH              = /usr/bin/perl");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# Configuration options related to the dot tool   ");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("CLASS_DIAGRAMS         = YES");
    _builder.newLine();
    _builder.append("HIDE_UNDOC_RELATIONS   = YES");
    _builder.newLine();
    _builder.append("HAVE_DOT               = YES");
    _builder.newLine();
    _builder.append("CLASS_GRAPH            = YES");
    _builder.newLine();
    _builder.append("COLLABORATION_GRAPH    = YES");
    _builder.newLine();
    _builder.append("GROUP_GRAPHS           = YES");
    _builder.newLine();
    _builder.append("UML_LOOK               = YES");
    _builder.newLine();
    _builder.append("TEMPLATE_RELATIONS     = YES");
    _builder.newLine();
    _builder.append("INCLUDE_GRAPH          = YES");
    _builder.newLine();
    _builder.append("INCLUDED_BY_GRAPH      = YES");
    _builder.newLine();
    _builder.append("CALL_GRAPH             = YES");
    _builder.newLine();
    _builder.append("CALLER_GRAPH           = YES");
    _builder.newLine();
    _builder.append("GRAPHICAL_HIERARCHY    = YES");
    _builder.newLine();
    _builder.append("DIRECTORY_GRAPH        = YES");
    _builder.newLine();
    _builder.append("DOT_IMAGE_FORMAT       = png");
    _builder.newLine();
    _builder.append("DOT_PATH               = ");
    _builder.newLine();
    _builder.append("DOTFILE_DIRS           = ");
    _builder.newLine();
    _builder.append("MAX_DOT_GRAPH_WIDTH    = 1024");
    _builder.newLine();
    _builder.append("MAX_DOT_GRAPH_HEIGHT   = 1024");
    _builder.newLine();
    _builder.append("MAX_DOT_GRAPH_DEPTH    = 0");
    _builder.newLine();
    _builder.append("DOT_TRANSPARENT        = NO");
    _builder.newLine();
    _builder.append("DOT_MULTI_TARGETS      = NO");
    _builder.newLine();
    _builder.append("GENERATE_LEGEND        = YES");
    _builder.newLine();
    _builder.append("DOT_CLEANUP            = YES");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("# Configuration.additions related to the search engine   ");
    _builder.newLine();
    _builder.append("#---------------------------------------------------------------------------");
    _builder.newLine();
    _builder.append("SEARCHENGINE           = NO");
    _builder.newLine();
    return _builder;
  }
  
  public static CharSequence genPackagePaths(final org.eclipse.uml2.uml.Package pkg) {
    StringConcatenation _builder = new StringConcatenation();
    String _replace = pkg.getQualifiedName().replace(".", "/");
    _builder.append(_replace);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
