/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.c.codegen.services;

import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.TypedElement;

public class StringServices {
    private static final String NAME_SEP = "::";

    public String getRelativePath(NamedElement src, NamedElement dest) throws ArrayIndexOutOfBoundsException {
        try {
            String[] qualifiedNameSrcParts = src.getQualifiedName().split(NAME_SEP);
            String[] qualifiedNameDestParts = dest.getQualifiedName().split(NAME_SEP);
            String tmp_src = src.getQualifiedName();
            String tmp_dest = dest.getQualifiedName();
            String relativePath = "";
            int i = 0;
            while (i < Math.min(qualifiedNameSrcParts.length, qualifiedNameDestParts.length)) {
                if (qualifiedNameSrcParts[i].equalsIgnoreCase(qualifiedNameDestParts[i])) {
                    tmp_src = tmp_src.replaceFirst(String.valueOf(qualifiedNameDestParts[i]) + NAME_SEP, "");
                    tmp_dest = tmp_dest.replaceFirst(String.valueOf(qualifiedNameDestParts[i]) + NAME_SEP, "");
                }
                ++i;
            }
            qualifiedNameSrcParts = tmp_src.split(NAME_SEP);
            qualifiedNameDestParts = tmp_dest.split(NAME_SEP);
            if (qualifiedNameSrcParts.length < 2 && qualifiedNameDestParts.length > 1) {
                relativePath = String.valueOf(relativePath) + "./";
            } else {
                i = 0;
                while (i < qualifiedNameSrcParts.length - 1) {
                    relativePath = String.valueOf(relativePath) + "../";
                    ++i;
                }
            }
            i = 0;
            while (i < qualifiedNameDestParts.length - 1) {
                relativePath = String.valueOf(relativePath) + qualifiedNameDestParts[i] + "/";
                ++i;
            }
            return relativePath;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "";
        }
    }

    public String LiteralStringValue(LiteralString lst) {
        TypedElement tmp;
        if (lst.getOwner() instanceof Property || lst.getOwner() instanceof Parameter) {
            tmp = (TypedElement)lst.getOwner();
            if (tmp.getType() == null) {
                return "\" \"";
            }
            if (tmp.getType().getName().equalsIgnoreCase("char")) {
                if (lst.getValue().toString().equalsIgnoreCase("")) {
                    return "' '";
                }
                return this.withSimpleQuote(lst.getValue().toString());
            }
            if (tmp.getType().getName().equalsIgnoreCase("String")) {
                if (lst.getValue().toString().equalsIgnoreCase("")) {
                    return "\" \"";
                }
                return this.withDoubleQuote(lst.getValue().toString());
            }
        }
        if (lst.getOwner().eClass().getName().equalsIgnoreCase("Slot")) {
            tmp = (Slot)lst.getOwner();
            if (tmp.getDefiningFeature() == null || tmp.getDefiningFeature().getType() == null) {
                return " ";
            }
            if (tmp.getDefiningFeature().getName().equalsIgnoreCase("char")) {
                if (lst.getValue().toString().equalsIgnoreCase("")) {
                    return "' '";
                }
                return this.withSimpleQuote(lst.getValue().toString());
            }
            if (tmp.getDefiningFeature().getType().getName().equalsIgnoreCase("String")) {
                if (lst.getValue().toString().equalsIgnoreCase("")) {
                    return "\" \"";
                }
                return this.withDoubleQuote(lst.getValue().toString());
            }
        }
        return lst.getValue();
    }

    public String toPath(String packageName) {
        return packageName.trim().replaceAll("\\.", "/");
    }

    public String withDoubleQuote(String value) {
        if (value.endsWith("'") && value.startsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        if (value.endsWith("\"") && value.startsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return "\"" + value.trim().replaceAll("\"", "\\\\\\\"") + "\"";
    }

    public String withSimpleQuote(String value) {
        if (value.endsWith("'") && value.startsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        if (value.endsWith("\"") && value.startsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        if (value.equalsIgnoreCase("null")) {
            return value;
        }
        return "'" + value.trim() + "'";
    }
}

