/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.IncludeUtils;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.PThreadTypes;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class TimeEventTransformation {
    @Extension
    protected CDefinitions cdefs;
    private SM2ClassesTransformationCore core;
    private PThreadTypes ptTypes;
    private Class superContext;

    public TimeEventTransformation(SM2ClassesTransformationCore core) {
        this.core = core;
        this.superContext = core.superContext;
        this.ptTypes = core.ptTypes;
        this.cdefs = core.cdefs;
    }

    public void createTimeEvents() {
        boolean _isEmpty = this.core.timeEvents.isEmpty();
        if (_isEmpty) {
            return;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"time.h\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("#include \"sys/time.h\"");
        IncludeUtils.appendIncludeHeader(this.superContext, _builder.toString());
        Property timeEventTable = this.superContext.createOwnedAttribute("timeEventTable", this.core.fptr);
        StereotypeUtil.apply((Element)timeEventTable, Array.class);
        Array _stereotypeApplication = (Array)UMLUtil.getStereotypeApplication((Element)timeEventTable, Array.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("[");
        int _size = this.core.timeEvents.size();
        _builder_1.append((Object)_size);
        _builder_1.append("]");
        _stereotypeApplication.setDefinition(_builder_1.toString());
        Property threads = this.superContext.createOwnedAttribute("timeEventThreads", this.ptTypes.getPthread());
        StereotypeUtil.apply((Element)threads, Array.class);
        Array _stereotypeApplication_1 = (Array)UMLUtil.getStereotypeApplication((Element)threads, Array.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("[");
        int _size_1 = this.core.timeEvents.size();
        _builder_2.append((Object)_size_1);
        _builder_2.append("]");
        _stereotypeApplication_1.setDefinition(_builder_2.toString());
        Property timeEventFlags = this.superContext.createOwnedAttribute("timeEventFlags", this.core.boolType);
        StereotypeUtil.apply((Element)timeEventFlags, Array.class);
        Array _stereotypeApplication_2 = (Array)UMLUtil.getStereotypeApplication((Element)timeEventFlags, Array.class);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("[");
        int _size_2 = this.core.timeEvents.size();
        _builder_3.append((Object)_size_2);
        _builder_3.append("]");
        _stereotypeApplication_2.setDefinition(_builder_3.toString());
        StringConcatenation _builder_4 = new StringConcatenation();
        boolean _hasElements = false;
        for (TimeEvent timeEvent : this.core.timeEvents) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder_4.appendImmediate((Object)", ", "");
            }
            _builder_4.append("false");
            _builder_4.newLine();
        }
        String body = _builder_4.toString();
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append("{");
        _builder_5.append(body);
        _builder_5.append("}");
        this.core.createOpaqueExpressionDefaultValue(timeEventFlags, "defaultTimeEventFlags", _builder_5.toString());
        Property timeEvnetConds = this.superContext.createOwnedAttribute("timeEventConds", this.ptTypes.getPthreadCond());
        StereotypeUtil.apply((Element)timeEvnetConds, Array.class);
        Array _stereotypeApplication_3 = (Array)UMLUtil.getStereotypeApplication((Element)timeEvnetConds, Array.class);
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("[");
        int _size_3 = this.core.timeEvents.size();
        _builder_6.append((Object)_size_3);
        _builder_6.append("]");
        _stereotypeApplication_3.setDefinition(_builder_6.toString());
        Property timeEventMutexes = this.superContext.createOwnedAttribute("timeEventMutexes", this.ptTypes.getPthreadMutex());
        StereotypeUtil.apply((Element)timeEventMutexes, Array.class);
        Array _stereotypeApplication_4 = (Array)UMLUtil.getStereotypeApplication((Element)timeEventMutexes, Array.class);
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append("[");
        int _size_4 = this.core.timeEvents.size();
        _builder_7.append((Object)_size_4);
        _builder_7.append("]");
        _stereotypeApplication_4.setDefinition(_builder_7.toString());
        Property threadStructs = this.superContext.createOwnedAttribute("timeEventThreadStructs", this.core.concurrency.threadStructType);
        StereotypeUtil.apply((Element)threadStructs, Array.class);
        Array _stereotypeApplication_5 = (Array)UMLUtil.getStereotypeApplication((Element)threadStructs, Array.class);
        StringConcatenation _builder_8 = new StringConcatenation();
        _builder_8.append("[");
        int _size_5 = this.core.timeEvents.size();
        _builder_8.append((Object)_size_5);
        _builder_8.append("]");
        _stereotypeApplication_5.setDefinition(_builder_8.toString());
        Operation timeEventOp = this.superContext.createOwnedOperation("listenTimeEvent", null, null);
        timeEventOp.createOwnedParameter("id", this.core.intType);
        timeEventOp.createOwnedParameter("duration", this.core.intType);
        StringConcatenation _builder_9 = new StringConcatenation();
        _builder_9.append("struct timeval tv;");
        _builder_9.newLine();
        _builder_9.append("struct timespec ts;");
        _builder_9.newLine();
        _builder_9.append("int timedWaitResult;");
        _builder_9.newLine();
        _builder_9.append("while(true) {");
        _builder_9.newLine();
        _builder_9.append("\t");
        _builder_9.append("pthread_mutex_lock(&");
        _builder_9.append("timeEventMutexes", "\t");
        _builder_9.append("[id]);");
        _builder_9.newLineIfNotEmpty();
        _builder_9.append("\t");
        _builder_9.append("while(!");
        _builder_9.append("timeEventFlags", "\t");
        _builder_9.append("[id]) {");
        _builder_9.newLineIfNotEmpty();
        _builder_9.append("\t\t");
        _builder_9.append("pthread_cond_wait(&");
        _builder_9.append("timeEventConds", "\t\t");
        _builder_9.append("[id], &");
        _builder_9.append("timeEventMutexes", "\t\t");
        _builder_9.append("[id]);");
        _builder_9.newLineIfNotEmpty();
        _builder_9.append("\t");
        _builder_9.append("}");
        _builder_9.newLine();
        _builder_9.append("\t");
        _builder_9.newLine();
        _builder_9.append("\t");
        _builder_9.append("gettimeofday(&tv, NULL);");
        _builder_9.newLine();
        _builder_9.append("\t");
        _builder_9.append("ts.tv_sec = time(NULL) + duration / 1000;");
        _builder_9.newLine();
        _builder_9.append("\t");
        _builder_9.append("ts.tv_nsec = tv.tv_usec * 1000 + 1000 * 1000 * (duration % 1000);");
        _builder_9.newLine();
        _builder_9.append("\t");
        _builder_9.append("ts.tv_sec += ts.tv_nsec / (1000 * 1000 * 1000);");
        _builder_9.newLine();
        _builder_9.append("\t");
        _builder_9.append("ts.tv_nsec %= (1000 * 1000 * 1000);");
        _builder_9.newLine();
        _builder_9.append("\t");
        _builder_9.newLine();
        _builder_9.append("\t");
        _builder_9.append("timedWaitResult = pthread_cond_timedwait(&");
        _builder_9.append("timeEventConds", "\t");
        _builder_9.append("[id], &");
        _builder_9.append("timeEventMutexes", "\t");
        _builder_9.append("[id], &ts);");
        _builder_9.newLineIfNotEmpty();
        _builder_9.append("\t");
        _builder_9.newLine();
        _builder_9.append("  \t");
        _builder_9.append("bool commitEvent = false;");
        _builder_9.newLine();
        _builder_9.append("  \t");
        _builder_9.append("if (timedWaitResult != 0) {");
        _builder_9.newLine();
        _builder_9.append("  \t\t");
        _builder_9.append("//timeout");
        _builder_9.newLine();
        _builder_9.append("  \t\t");
        _builder_9.append("commitEvent = true;");
        _builder_9.newLine();
        _builder_9.append("  \t");
        _builder_9.append("}");
        _builder_9.newLine();
        _builder_9.append("\t");
        _builder_9.append("timeEventFlags", "\t");
        _builder_9.append("[id] = false;");
        _builder_9.newLineIfNotEmpty();
        _builder_9.append("\t");
        _builder_9.append("pthread_cond_signal(&");
        _builder_9.append("timeEventConds", "\t");
        _builder_9.append("[id]);");
        _builder_9.newLineIfNotEmpty();
        _builder_9.append("\t");
        _builder_9.append("pthread_mutex_unlock(&");
        _builder_9.append("timeEventMutexes", "\t");
        _builder_9.append("[id]);");
        _builder_9.newLineIfNotEmpty();
        _builder_9.append("\t");
        _builder_9.append("if (commitEvent) {");
        _builder_9.newLine();
        _builder_9.append("\t\t");
        _builder_9.append("//the state does not change, push time event to the queue");
        _builder_9.newLine();
        _builder_9.append("\t\t");
        _builder_9.append("eventQueue", "\t\t");
        _builder_9.append(".push(statemachine::EventPriority_t::PRIORITY_2, NULL, id, statemachine::EventType_t::TIME_EVENT, id);");
        _builder_9.newLineIfNotEmpty();
        _builder_9.append("\t");
        _builder_9.append("}");
        _builder_9.newLine();
        _builder_9.append("}");
        this.core.createOpaqueBehavior(this.superContext, timeEventOp, _builder_9.toString());
    }
}

