/**
 * Copyright (c) 2016, 2021 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *  Van Cam Pham        <VanCam.PHAM@cea.fr>
 */
package org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine;

import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.SMJavaCodeGeneratorConstants;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.TimeEventTransformation;
import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCodeGeneratorConstants;
import org.eclipse.papyrus.designer.transformation.library.statemachine.TransformationUtil;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Java variant of concurrent execution. Incomplete
 */
@SuppressWarnings("all")
public class ConcurrencyGenerator {
  @Extension
  protected CDefinitions cdefs;
  
  private SM2ClassesTransformationCore core;
  
  public Type threadStructType;
  
  private org.eclipse.uml2.uml.Class superContext;
  
  public ConcurrencyGenerator(final SM2ClassesTransformationCore core) {
    this.core = core;
    this.superContext = core.superContext;
    this.cdefs = core.cdefs;
  }
  
  public Object createThreadBasedParallelism() {
    Object _xblockexpression = null;
    {
      Operation doCallActivity = this.superContext.createOwnedOperation(SMCodeGeneratorConstants.DO_CALL_ACTIVITY, null, null);
      doCallActivity.createOwnedParameter("id", this.core.intType);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(SMCodeGeneratorConstants.FLAGS_ACTIVITY);
      _builder.append("[id] = false;");
      _builder.newLineIfNotEmpty();
      _builder.append("boolean exit = false;");
      _builder.newLine();
      _builder.append("while (!Thread.currentThread().isInterrupted()) {");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("synchronized(this) {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("while (!flags[id]) {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("try {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("wait();");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("} catch (InterruptedException e) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("// interruption, exit loop");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("exit = true;");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("break;");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("if (exit) {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("break;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("states[id].doActivity.run();");
      _builder.newLine();
      _builder.append("\t");
      final Function1<State, Boolean> _function = new Function1<State, Boolean>() {
        @Override
        public Boolean apply(final State it) {
          return Boolean.valueOf(((!it.isComposite()) && TransformationUtil.hasTriggerlessTransition(it)));
        }
      };
      int _size = IterableExtensions.size(IterableExtensions.<State>filter(this.core.states, _function));
      final boolean hasTriggerlessTrans = (_size > 0);
      _builder.newLineIfNotEmpty();
      {
        if (hasTriggerlessTrans) {
          _builder.append("\t");
          _builder.append("bool commitEvent = false;");
          _builder.newLine();
        }
      }
      _builder.append("\t");
      _builder.append("if (flags[id]) {");
      _builder.newLine();
      {
        if (hasTriggerlessTrans) {
          _builder.append("\t\t");
          _builder.append("commitEvent = true;");
          _builder.newLine();
        }
      }
      _builder.append("\t\t");
      _builder.append("flags[id] = false;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("notifyAll();");
      _builder.newLine();
      {
        if (hasTriggerlessTrans) {
          _builder.append("\t");
          _builder.append("if (commitEvent) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("if(");
          {
            final Function1<State, Boolean> _function_1 = new Function1<State, Boolean>() {
              @Override
              public Boolean apply(final State it) {
                return Boolean.valueOf(((!it.isComposite()) && TransformationUtil.hasTriggerlessTransition(it)));
              }
            };
            Iterable<State> _filter = IterableExtensions.<State>filter(this.core.states, _function_1);
            boolean _hasElements = false;
            for(final State s : _filter) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(" || ", "\t\t");
              }
              _builder.append("id == ");
              String _upperCase = s.getName().toUpperCase();
              _builder.append(_upperCase, "\t\t");
              _builder.append("_ID");
            }
          }
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("//processCompletionEvent();");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t\t\t");
          _builder.append(".push(EventPriority_t.PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine.COMPLETION_EVENT, id);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("}}");
      _builder.newLine();
      this.core.createOpaqueBehavior(this.superContext, doCallActivity, _builder.toString());
      Operation setFlag = this.superContext.createOwnedOperation(SMCodeGeneratorConstants.SET_FLAG, null, null);
      setFlag.createOwnedParameter("id", this.core.intType);
      setFlag.createOwnedParameter("func_type", this.core.threadFuncEnum);
      setFlag.createOwnedParameter("value", this.core.boolType);
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("//value = true => start activity");
      _builder_1.newLine();
      _builder_1.append("//value = false => stop activity");
      _builder_1.newLine();
      {
        int _size_1 = this.core.timeEvents.size();
        boolean _greaterThan = (_size_1 > 0);
        if (_greaterThan) {
          _builder_1.append("if (func_type == ");
          _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_TIMEEVENT_TYPE);
          _builder_1.append(") {");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("\t");
          _builder_1.append("synchronized (this) {");
          _builder_1.newLine();
          _builder_1.append("\t\t");
          _builder_1.newLine();
          _builder_1.append("\t\t");
          _builder_1.append("timeEventFlags[");
          String _TE_INDEX = this.cdefs.TE_INDEX();
          _builder_1.append(_TE_INDEX, "\t\t");
          _builder_1.append("(id)] = value;");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("\t\t");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("}");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("return;");
          _builder_1.newLine();
          _builder_1.append("}");
          _builder_1.newLine();
        }
      }
      _builder_1.append("if (func_type == ");
      _builder_1.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
      _builder_1.append(") {");
      _builder_1.newLineIfNotEmpty();
      {
        int _size_2 = this.core.doActivityList.size();
        boolean _greaterThan_1 = (_size_2 > 0);
        if (_greaterThan_1) {
          _builder_1.append("\t");
          _builder_1.append("if (");
          _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
          _builder_1.append("[id].doActivity != doActivity_dft) {");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("\t");
          _builder_1.append("\t");
          _builder_1.append("// state has doActivity => if value = true => should");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t");
          _builder_1.append("synchronized (this) {");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t");
          _builder_1.append("if (value) {");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t\t");
          _builder_1.append("flags[id] = true;");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t");
          _builder_1.append("} else {");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t\t");
          _builder_1.append("// wait until doActivity exits");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t\t");
          _builder_1.append("while (flags[id]) {");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t\t\t");
          _builder_1.append("try {");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t\t\t\t");
          _builder_1.append("wait();");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t\t\t");
          _builder_1.append("} catch (InterruptedException e) {");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t\t\t\t");
          _builder_1.append("// TODO Auto-generated catch block");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t\t\t\t");
          _builder_1.append("e.printStackTrace();");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t\t\t");
          _builder_1.append("}");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t\t");
          _builder_1.append("}");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t");
          _builder_1.append("}");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t\t");
          _builder_1.append("notifyAll();");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("\t");
          _builder_1.append("}");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("}");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("else {");
          _builder_1.newLine();
          {
            final Function1<State, Boolean> _function_2 = new Function1<State, Boolean>() {
              @Override
              public Boolean apply(final State it) {
                return Boolean.valueOf(((!it.isComposite()) && TransformationUtil.hasTriggerlessTransition(it)));
              }
            };
            int _size_3 = IterableExtensions.size(IterableExtensions.<State>filter(this.core.states, _function_2));
            boolean _greaterThan_2 = (_size_3 > 0);
            if (_greaterThan_2) {
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append("// push completion event");
              _builder_1.newLine();
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append("if (value) {");
              _builder_1.newLine();
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append("if(");
              {
                final Function1<State, Boolean> _function_3 = new Function1<State, Boolean>() {
                  @Override
                  public Boolean apply(final State it) {
                    return Boolean.valueOf(((!it.isComposite()) && TransformationUtil.hasTriggerlessTransition(it)));
                  }
                };
                Iterable<State> _filter_1 = IterableExtensions.<State>filter(this.core.states, _function_3);
                boolean _hasElements_1 = false;
                for(final State s_1 : _filter_1) {
                  if (!_hasElements_1) {
                    _hasElements_1 = true;
                  } else {
                    _builder_1.appendImmediate(" || ", "\t\t\t");
                  }
                  _builder_1.append("id == ");
                  String _upperCase_1 = s_1.getName().toUpperCase();
                  _builder_1.append(_upperCase_1, "\t\t\t");
                  _builder_1.append("_ID");
                }
              }
              _builder_1.append(") {");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append("\t\t");
              _builder_1.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t\t\t\t");
              _builder_1.append(".push(statemachineEventPriority_t.PRIORITY_1, Ne::EventPriority_t.PRIORITY_TIONEVENT_ID, statemachine::COMPLETION_EVENT, id);");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append("}");
              _builder_1.newLine();
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append("}");
              _builder_1.newLine();
            }
          }
          _builder_1.append("\t");
          _builder_1.append("}");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("return;");
          _builder_1.newLine();
        } else {
          {
            final Function1<State, Boolean> _function_4 = new Function1<State, Boolean>() {
              @Override
              public Boolean apply(final State it) {
                return Boolean.valueOf(((!it.isComposite()) && TransformationUtil.hasTriggerlessTransition(it)));
              }
            };
            int _size_4 = IterableExtensions.size(IterableExtensions.<State>filter(this.core.states, _function_4));
            boolean _greaterThan_3 = (_size_4 > 0);
            if (_greaterThan_3) {
              _builder_1.append("\t");
              _builder_1.append("// push completion event");
              _builder_1.newLine();
              _builder_1.append("\t");
              _builder_1.append("if (value) {");
              _builder_1.newLine();
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append("if (");
              {
                final Function1<State, Boolean> _function_5 = new Function1<State, Boolean>() {
                  @Override
                  public Boolean apply(final State it) {
                    return Boolean.valueOf(((!it.isComposite()) && TransformationUtil.hasTriggerlessTransition(it)));
                  }
                };
                Iterable<State> _filter_2 = IterableExtensions.<State>filter(this.core.states, _function_5);
                boolean _hasElements_2 = false;
                for(final State s_2 : _filter_2) {
                  if (!_hasElements_2) {
                    _hasElements_2 = true;
                  } else {
                    _builder_1.appendImmediate(" || ", "\t\t");
                  }
                  _builder_1.append("id == ");
                  String _upperCase_2 = s_2.getName().toUpperCase();
                  _builder_1.append(_upperCase_2, "\t\t");
                  _builder_1.append("_ID");
                }
              }
              _builder_1.append(") {");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("\t");
              _builder_1.append("\t\t");
              _builder_1.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t\t\t");
              _builder_1.append(".push(statemachineEventPriority_t.PRIORITY_1, NULL, COMPLETIONEVENT_ID, COMPLETION_EVENT, id);");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append("}");
              _builder_1.newLine();
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append("return;");
              _builder_1.newLine();
              _builder_1.append("\t");
              _builder_1.append("}");
              _builder_1.newLine();
            }
          }
        }
      }
      _builder_1.append("}");
      _builder_1.newLine();
      this.core.createOpaqueBehavior(this.superContext, setFlag, _builder_1.toString());
      new TimeEventTransformation(this.core).createTimeEvents();
      _xblockexpression = this.createRegionParallel();
    }
    return _xblockexpression;
  }
  
  public Object createRegionParallel() {
    return null;
  }
  
  public Object createConcurrencyForTransitions() {
    return null;
  }
  
  public String parallelTransitionMethodName(final Transition t) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("paralleTransition");
    int _indexOf = this.core.parallelTransitions.indexOf(t);
    _builder.append(_indexOf);
    return _builder.toString();
  }
  
  public String parallelTransitionId(final Transition t) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("PARALLEL_TRANSITION_ID_");
    int _indexOf = this.core.parallelTransitions.indexOf(t);
    _builder.append(_indexOf);
    return _builder.toString();
  }
  
  public String generateForkCall(final Region r, final boolean isEnter, final String enteringMode) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = r.getState().getName();
    _builder.append(_name);
    _builder.append("_");
    String _name_1 = r.getName();
    _builder.append(_name_1);
    _builder.append("_enter_thread");
    String paramThreadName = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    String _name_2 = r.getState().getName();
    _builder_1.append(_name_2);
    _builder_1.append("_");
    String _name_3 = r.getName();
    _builder_1.append(_name_3);
    _builder_1.append("_enter_thread_struct");
    String threadStructParam = _builder_1.toString();
    if ((!isEnter)) {
      StringConcatenation _builder_2 = new StringConcatenation();
      String _name_4 = r.getState().getName();
      _builder_2.append(_name_4);
      _builder_2.append("_");
      String _name_5 = r.getName();
      _builder_2.append(_name_5);
      _builder_2.append("_exit_thread");
      paramThreadName = _builder_2.toString();
      StringConcatenation _builder_3 = new StringConcatenation();
      String _name_6 = r.getState().getName();
      _builder_3.append(_name_6);
      _builder_3.append("_");
      String _name_7 = r.getName();
      _builder_3.append(_name_7);
      _builder_3.append("_exit_thread_struct");
      threadStructParam = _builder_3.toString();
    }
    StringConcatenation _builder_4 = new StringConcatenation();
    _builder_4.append("pthread_t ");
    _builder_4.append(paramThreadName);
    _builder_4.append(";");
    _builder_4.newLineIfNotEmpty();
    _builder_4.append(SMJavaCodeGeneratorConstants.STRUCT_FOR_THREAD);
    _builder_4.append(" ");
    _builder_4.append(threadStructParam);
    _builder_4.append("(this, ");
    String _regionMacroId = this.core.getRegionMacroId(r);
    _builder_4.append(_regionMacroId);
    _builder_4.append(", ");
    _builder_4.append(enteringMode);
    _builder_4.append(", ");
    {
      if (isEnter) {
        _builder_4.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_ENTER_REGION_TYPE);
      } else {
        _builder_4.append(SMJavaCodeGeneratorConstants.THREAD_FUNC_EXIT_REGION_TYPE);
      }
    }
    _builder_4.append(", 0);");
    _builder_4.newLineIfNotEmpty();
    String _name_8 = this.superContext.getName();
    _builder_4.append(_name_8);
    _builder_4.append("_THREAD_CREATE(");
    _builder_4.append(paramThreadName);
    _builder_4.append(", ");
    _builder_4.append(threadStructParam);
    _builder_4.append(")");
    _builder_4.newLineIfNotEmpty();
    return _builder_4.toString();
  }
  
  public String generateJoinCall(final Region r, final boolean isEnter) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = r.getState().getName();
    _builder.append(_name);
    _builder.append("_");
    String _name_1 = r.getName();
    _builder.append(_name_1);
    _builder.append("_enter_thread");
    String paramThreadName = _builder.toString();
    if ((!isEnter)) {
      StringConcatenation _builder_1 = new StringConcatenation();
      String _name_2 = r.getState().getName();
      _builder_1.append(_name_2);
      _builder_1.append("_");
      String _name_3 = r.getName();
      _builder_1.append(_name_3);
      _builder_1.append("_exit_thread");
      paramThreadName = _builder_1.toString();
    }
    StringConcatenation _builder_2 = new StringConcatenation();
    _builder_2.append(SMCodeGeneratorConstants.JOIN_NAME);
    _builder_2.append("(");
    _builder_2.append(paramThreadName);
    _builder_2.append(", NULL);");
    return _builder_2.toString();
  }
}
