/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.papyrus.designer.components.FCM.InterceptionRule;
import org.eclipse.papyrus.designer.components.transformation.ui.dialogs.PortLabelProvider;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.uml.profile.ui.dialogs.AlphabeticalViewerSorter;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ChooseSetAssistedDialog;
import org.eclipse.papyrus.uml.profile.ui.dialogs.IChooseDialog;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.StereotypeQualifiedLabelProvider;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class ChoosePorts
extends ChooseSetAssistedDialog
implements IChooseDialog {
    protected EList<Package> visitedPackages;
    private final StereotypeQualifiedLabelProvider qualifiedLabelProvider = new StereotypeQualifiedLabelProvider();

    public ChoosePorts(Shell parentShell, Class component, InterceptionRule rule) {
        super(parentShell, "Available features", "Intercepted features");
        this.labelProvider = new PortLabelProvider();
        this.decoratedContentProposalProvider = new ConfigOptContentProposalProvider();
        for (Feature feature : rule.getInterceptionSet()) {
            this.selectedElementList.addElement((Object)feature);
        }
        this.visitedPackages = new BasicEList();
        if (component != null) {
            for (Property current : component.getOwnedAttributes()) {
                if (this.selectedElementList.contains((Object)current)) continue;
                this.possibleElementList.addElement((Object)current);
            }
            for (Property current : ElementUtils.getAllElementsOfType((Element)component, Feature.class)) {
                if (this.selectedElementList.contains((Object)current)) continue;
                this.possibleElementList.addElement((Object)current);
            }
        } else {
            Package top = PackageUtil.getRootPackage((Element)rule.getBase_Property());
            for (Feature current : ElementUtils.getAllElementsOfType((Element)top, Feature.class)) {
                if (this.selectedElementList.contains((Object)current)) continue;
                this.possibleElementList.addElement((Object)current);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Control composite = super.createDialogArea(parent);
        this.possibleElementsTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.possibleElementsTable, 0x1000000, 0);
        column.setText("Port");
        column.setWidth(60);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChoosePorts.this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(0));
            }
        });
        column = new TableColumn(this.possibleElementsTable, 16384, 1);
        column.setText("Type");
        column.setWidth(100);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChoosePorts.this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(1));
            }
        });
        this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(0));
        return composite;
    }

    protected void runAddElement(String name) {
        Port port = null;
        for (Object possibleElement : this.possibleElementList.getElements()) {
            Port element = (Port)possibleElement;
            if (!name.equalsIgnoreCase(element.getName()) && !name.equalsIgnoreCase(element.getQualifiedName())) continue;
            port = element;
        }
        if (port != null) {
            this.runActionAdd(port);
        }
    }

    protected boolean isSelectableElement(String text) {
        for (Object possibleElement : this.possibleElementList.getElements()) {
            Port element = (Port)possibleElement;
            if (!text.equalsIgnoreCase(element.getName()) && !text.equalsIgnoreCase(element.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public class ConfigOptContentProposalProvider
    extends ChooseSetAssistedDialog.DecoratedContentProposalProvider {
        public ConfigOptContentProposalProvider() {
            super((ChooseSetAssistedDialog)ChoosePorts.this);
        }

        public ChooseSetAssistedDialog.DecoratedContentProposal[] getProposals(String contents, int position) {
            ArrayList<ChooseSetAssistedDialog.DecoratedContentProposal> proposals = new ArrayList<ChooseSetAssistedDialog.DecoratedContentProposal>();
            if (ChoosePorts.this.possibleElementList != null) {
                for (Object portObj : ChoosePorts.this.possibleElementList.getElements()) {
                    Port port = (Port)portObj;
                    String simpleName = port.getName();
                    String qualifiedName = port.getQualifiedName();
                    if (position < simpleName.length() && contents.substring(0, position).equalsIgnoreCase(simpleName.substring(0, position))) {
                        proposals.add(new ChooseSetAssistedDialog.DecoratedContentProposal((ChooseSetAssistedDialog)ChoosePorts.this, (Object)port, ChoosePorts.this.labelProvider));
                    }
                    if (position >= qualifiedName.length() || !contents.substring(0, position).equalsIgnoreCase(qualifiedName.substring(0, position))) continue;
                    proposals.add(new ChooseSetAssistedDialog.DecoratedContentProposal((ChooseSetAssistedDialog)ChoosePorts.this, (Object)port, (LabelProvider)ChoosePorts.this.qualifiedLabelProvider));
                }
            }
            Collections.sort(proposals);
            return proposals.toArray(new ChooseSetAssistedDialog.DecoratedContentProposal[proposals.size()]);
        }
    }
}

