/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.codegen.ui;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.GeneratorSelectionDialog;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.Messages;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.GeneratorHint;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.Language;
import org.eclipse.papyrus.designer.languages.common.profile.CommonProfileResource;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ChooseGenerator {
    public static final String LANGUAGES_PKG = "languages";
    protected static ILangCodegen codeGen;

    public static ILangCodegen choose(final Pattern languagePattern, final PackageableElement pe) {
        final List eligibleGenerators = LanguageCodegen.getEligibleGeneratorList((Pattern)languagePattern, (Element)pe);
        if (eligibleGenerators.size() == 0) {
            eligibleGenerators.addAll(LanguageCodegen.getCodegenList((Pattern)languagePattern));
        }
        if (eligibleGenerators.size() == 1) {
            return (ILangCodegen)eligibleGenerators.get(0);
        }
        if (eligibleGenerators.size() > 1) {
            codeGen = null;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = Display.getCurrent().getActiveShell();
                    GeneratorSelectionDialog dialog = new GeneratorSelectionDialog(shell, eligibleGenerators);
                    if (dialog.open() == 0) {
                        codeGen = (ILangCodegen)dialog.getResult()[0];
                        Boolean storeResult = (Boolean)dialog.getResult()[1];
                        if (storeResult.booleanValue()) {
                            ChooseGenerator.storeGeneratorID(pe, LanguageCodegen.getLanguage((ILangCodegen)codeGen), LanguageCodegen.getID((ILangCodegen)codeGen));
                        }
                    }
                }
            });
            return codeGen;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getCurrent().getActiveShell();
                String pattern = languagePattern.pattern().replace("\\", "");
                MessageDialog.openError((Shell)shell, (String)Messages.LanguageCodegen_NoGeneratorsFound, (String)String.format(Messages.LanguageCodegen_NoGeneratorsFoundLong, pattern));
            }
        });
        return null;
    }

    public static void storeGeneratorID(final PackageableElement pe, final String languageName, final String generatorID) {
        final Package root = PackageUtil.getRootPackage((Element)pe);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)pe);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain, Messages.ChooseGenerator_CHOOSE_GENERATOR){

            public void doExecute() {
                Package commonProfile = PackageUtil.loadPackage((URI)CommonProfileResource.PROFILE_PATH_URI, (ResourceSet)pe.eResource().getResourceSet());
                root.applyProfile((Profile)commonProfile);
                NamedElement languageNE = ElementUtils.getQualifiedElementFromRS((Element)pe, (String)("languages::" + languageName));
                if (languageNE == null) {
                    PackageUtil.loadPackage((URI)CommonProfileResource.LANGUAGES_PATH_URI, (ResourceSet)pe.eResource().getResourceSet());
                    languageNE = ElementUtils.getQualifiedElementFromRS((Element)pe, (String)("languages::" + languageName));
                }
                Language language = languageNE != null ? (Language)UMLUtil.getStereotypeApplication((Element)languageNE, Language.class) : null;
                GeneratorHint hint = (GeneratorHint)StereotypeUtil.applyApp((Element)root, GeneratorHint.class);
                hint.setLanguage(language);
                hint.setGeneratorID(generatorID);
            }
        });
    }
}

