/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.umlparser;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.JavaParser;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ParseException;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.CompilationUnit;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.CompilationUnitAnalyser;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.ModelManager;

public class UmlParser {
    protected CompilationUnitAnalyser visitor;

    public void parseResource(File file) throws ParseException, IOException {
        if (file.isDirectory()) {
            System.out.println("  '" + file.getAbsolutePath() + " is a directory");
            this.parsePackage(file);
        } else if (file.isFile()) {
            System.out.println("  '" + file.getAbsolutePath() + " is a file");
            if (file.getName().endsWith(".java")) {
                this.parseFile(file);
            } else {
                System.out.println("skip non java file '" + file.getAbsolutePath() + "'");
            }
        } else {
            System.out.println("  '" + file.getAbsolutePath() + " can't be identified - " + file);
        }
    }

    public void parsePackage(File file) throws ParseException, IOException {
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            this.parseResource(f);
            ++n2;
        }
    }

    protected void parseFile(File file) throws ParseException, IOException {
        CompilationUnit cu = JavaParser.parse(file);
        this.visitor.processCompilationUnit(cu);
    }

    public void parseResource(String resourceName) throws ParseException, IOException {
        File file = new File(resourceName);
        this.parseResource(file);
    }

    public void execute(String resourcePath, String outputModelName) throws ParseException, IOException {
        System.out.println("resource=" + resourcePath);
        ModelManager modelManager = new ModelManager();
        modelManager.createModel(outputModelName);
        this.visitor = new CompilationUnitAnalyser(modelManager.getModel());
        this.parseResource(resourcePath);
        modelManager.save();
    }

    public void executeTest(String resourcePath, String outputModelName) throws ParseException, IOException {
        System.out.println("resource=" + resourcePath);
        ModelManager modelManager = new ModelManager();
        modelManager.createModel(outputModelName);
        String javaccDir = "H:/temp/papyrus/papyrus-gmf-head2/org.eclipse.papyrus.designer.languages.java.reverse/src/japa/parser";
        String javagenDir = "H:/temp/papyrus/papyrus-gmf-head2/org.eclipse.papyrus.designer.languages.java.reverse/src/javagen/umlparser";
        String[] paths = new String[]{"javagen", "javacc"};
        this.visitor = new CompilationUnitAnalyser(modelManager.getModel(), "javacc", null, null);
        this.parseResource(javaccDir);
        this.visitor = new CompilationUnitAnalyser(modelManager.getModel(), "javagen", Arrays.asList(paths), null);
        this.parseResource(javagenDir);
        modelManager.save();
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                UmlParser p = new UmlParser();
                p.execute(args[0], "myfile.uml");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                System.out.println("Problems encountered during parsing.");
                e.printStackTrace();
            }
        } else {
            System.out.println("Please select a file or directory to parse");
            return;
        }
    }
}

