/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.uml.tools.utils;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;

public class ElementUtils {
    public static NamedElement getNamedElementFromList(EList<? extends EObject> elementList, String name) {
        for (EObject element : elementList) {
            NamedElement namedElement;
            if (!(element instanceof NamedElement) || (namedElement = (NamedElement)element).getName() == null || !namedElement.getName().equals(name)) continue;
            return namedElement;
        }
        return null;
    }

    public static Package getRoot(Element element, String subfolder) {
        Package root = PackageUtil.getRootPackage(element);
        if (root.getNestedPackage(subfolder) != null) {
            return root.getNestedPackage(subfolder);
        }
        return root.createNestedPackage(subfolder);
    }

    public static Class componentType(Class clazz) {
        if (clazz.isAbstract()) {
            return clazz;
        }
        for (Class superclass : clazz.getSuperClasses()) {
            if (!superclass.isAbstract()) continue;
            return superclass;
        }
        return null;
    }

    public static boolean isComposite(InstanceSpecification is) {
        return is.getSlots().size() > 0;
    }

    public static NamedElement getQualifiedElementFromRS(Element element, String qualifiedName) {
        return ElementUtils.getQualifiedElementFromRS(element.eResource().getResourceSet(), qualifiedName);
    }

    public static NamedElement getQualifiedElementFromRS(Element element, URI uri, String qualifiedName) {
        URI[] uriList = new URI[]{uri};
        return ElementUtils.getQualifiedElementFromRS(element, uriList, qualifiedName);
    }

    public static NamedElement getQualifiedElementFromRS(Element element, URI[] uriList, String qualifiedName) {
        ResourceSet set = element.eResource().getResourceSet();
        URI[] uRIArray = uriList;
        int n = uriList.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            set.getResource(uri, true);
            ++n2;
        }
        NamedElement ne = ElementUtils.getQualifiedElementFromRS(set, qualifiedName);
        return ne;
    }

    public static Package loadPackage(URI uri, Element element) {
        return ElementUtils.loadPackage(uri, element.eResource().getResourceSet());
    }

    public static Package loadPackage(final URI uri, final ResourceSet set) {
        if (set.getResource(uri, false) == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    set.getResource(uri, true);
                }
            });
        }
        return PackageUtil.loadPackage(uri, set);
    }

    public static NamedElement getQualifiedElementFromRS(ResourceSet rs, String qualifiedName) {
        ArrayList rsList = new ArrayList();
        rsList.addAll(rs.getResources());
        for (Resource resource : rsList) {
            NamedElement ne;
            EObject topLevelElem;
            if (!(resource instanceof UMLResource) || resource.getContents().size() <= 0 || !((topLevelElem = (EObject)resource.getContents().get(0)) instanceof Package) || (ne = ElementUtils.getQualifiedElement((Package)topLevelElem, qualifiedName)) == null) continue;
            return ne;
        }
        return null;
    }

    public static NamedElement getQualifiedElement(Package root, String qualifiedName) {
        String[] path = qualifiedName.split("::");
        if (path[0].equals(root.getName()) || "*".equals(path[0])) {
            return ElementUtils.getQualifiedElement((Namespace)root, path, 1);
        }
        return null;
    }

    public static NamedElement getQualifiedElement(Namespace root, String[] path, int pos) {
        if (root == null) {
            return null;
        }
        if (pos == path.length) {
            return root;
        }
        if (pos < path.length) {
            for (NamedElement segmentElem : root.getMembers()) {
                NamedElement foundElement;
                if (!path[pos].equals(segmentElem.getName()) && !"*".equals(path[pos])) continue;
                if (pos == path.length - 1) {
                    return segmentElem;
                }
                if (!(segmentElem instanceof Namespace) || (foundElement = ElementUtils.getQualifiedElement((Namespace)segmentElem, path, pos + 1)) == null) continue;
                return foundElement;
            }
        }
        return null;
    }

    public static boolean isElementInDifferentModel(Package model, NamedElement namedElement) {
        return model != PackageUtil.getRootPackage((Element)namedElement);
    }

    public static <T extends EObject> EList<T> getAllElementsOfType(Element examineElement, java.lang.Class<T> clazz) {
        BasicEList visitedPackages = new BasicEList();
        return ElementUtils.getAllElementsOfType(examineElement, clazz, (EList<Element>)visitedPackages);
    }

    public static <T extends EObject> EList<T> getAllElementsOfType(Element examineElement, java.lang.Class<T> clazz, EList<Element> visitedPackages) {
        UniqueEList list = new UniqueEList();
        for (Element element : examineElement.allOwnedElements()) {
            if (element instanceof Package) {
                if (visitedPackages.contains((Object)element)) continue;
                visitedPackages.add((Object)element);
                list.addAll(ElementUtils.getAllElementsOfType(element, clazz, visitedPackages));
                continue;
            }
            if (!clazz.isInstance(element)) continue;
            list.add((Object)element);
        }
        return list;
    }

    public static void declareDependency(Type source, Type dest) {
        for (Relationship dependency : source.getRelationships(UMLPackage.eINSTANCE.getDependency())) {
            if (!((Dependency)dependency).getSuppliers().contains((Object)dest)) continue;
            return;
        }
        source.createDependency((NamedElement)dest);
    }

    public static EList<Classifier> getReferencedClassifiers(Classifier classifier) {
        UniqueEList list = new UniqueEList();
        list.addAll((Collection)classifier.parents());
        if (classifier instanceof Class) {
            for (Operation operation : ((Class)classifier).getOwnedOperations()) {
                for (Parameter parameter : operation.getOwnedParameters()) {
                    Type type = parameter.getType();
                    if (!(type instanceof Classifier)) continue;
                    list.add((Object)((Classifier)type));
                }
            }
            for (Property attribute : ((Class)classifier).getOwnedAttributes()) {
                Type type = attribute.getType();
                if (!(type instanceof Classifier)) continue;
                list.add((Object)((Classifier)type));
            }
        }
        return list;
    }

    public static EList<Namespace> usedNamespaces(NamedElement element) {
        BasicEList list = new BasicEList((Collection)element.allNamespaces());
        if (list.size() < 1) {
            return null;
        }
        list.remove(list.size() - 1);
        return list;
    }

    public static String varName(NamedElement element) {
        return StringUtils.varName((String)element.getName());
    }

    public static String xmlID(Element element) {
        Resource resource = element.eResource();
        if (resource instanceof XMLResource) {
            XMLResource xmlResource = (XMLResource)resource;
            return xmlResource.getID((EObject)element);
        }
        return null;
    }
}

