/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.destroy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.destroy.IDestroyerDependencyCollector;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.CollaborationHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.DurationConstraintHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.DurationObservationHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.OccurrenceSpecificationHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.TimeConstraintHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.TimeObservationHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.UMLService;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PartDecomposition;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDependencyCollector
implements IDestroyerDependencyCollector {
    private final ECrossReferenceAdapter crossReferenceAdapter;

    public ElementDependencyCollector(ECrossReferenceAdapter theCrossReferenceAdapter) {
        this.crossReferenceAdapter = theCrossReferenceAdapter;
    }

    @Override
    public Set<EObject> collectDependencies(EObject source) {
        DestroyDependencyCollectorSwitch collector = new DestroyDependencyCollectorSwitch(this.crossReferenceAdapter);
        collector.doSwitch(source);
        return collector.getDependentsToRemove();
    }

    static class DestroyDependencyCollectorSwitch
    extends UMLSwitch<Void> {
        private final ECrossReferenceAdapter crossReferenceAdapter;
        private final Set<EObject> dependentsToRemove = new HashSet<EObject>();

        DestroyDependencyCollectorSwitch(ECrossReferenceAdapter crossReferenceAdapter) {
            this.crossReferenceAdapter = crossReferenceAdapter;
        }

        public Void caseNamedElement(NamedElement namedElementToDelete) {
            for (DirectedRelationship directedRelationship : namedElementToDelete.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getDependency())) {
                if (!directedRelationship.getSources().contains((Object)namedElementToDelete)) continue;
                this.dependentsToRemove.add((EObject)directedRelationship);
            }
            for (DirectedRelationship directedRelationship : namedElementToDelete.getTargetDirectedRelationships(UMLPackage.eINSTANCE.getDependency())) {
                if (!directedRelationship.getTargets().contains((Object)namedElementToDelete)) continue;
                this.dependentsToRemove.add((EObject)directedRelationship);
            }
            return (Void)super.caseNamedElement(namedElementToDelete);
        }

        public Void caseActivityNode(ActivityNode activityNodeToDelete) {
            this.dependentsToRemove.addAll((Collection<EObject>)activityNodeToDelete.getOutgoings());
            this.dependentsToRemove.addAll((Collection<EObject>)activityNodeToDelete.getIncomings());
            return (Void)super.caseActivityNode(activityNodeToDelete);
        }

        public Void caseConnectorEnd(ConnectorEnd connectorEndToDelete) {
            Connector connector = (Connector)connectorEndToDelete.getOwner();
            if (connector.getEnds().size() <= 2) {
                this.dependentsToRemove.add((EObject)connector);
            }
            return (Void)super.caseConnectorEnd(connectorEndToDelete);
        }

        public Void caseProperty(Property propertyToDelete) {
            EReference[] refs = null;
            refs = new EReference[]{UMLPackage.eINSTANCE.getConnectorEnd_Role(), UMLPackage.eINSTANCE.getConnectorEnd_PartWithPort()};
            Collection<EObject> connectorEndRefs = UMLService.getReferencers((EObject)propertyToDelete, refs, this.crossReferenceAdapter);
            this.dependentsToRemove.addAll(connectorEndRefs);
            refs = new EReference[]{UMLPackage.eINSTANCE.getAssociation_MemberEnd()};
            Collection<EObject> associationRefs = UMLService.getReferencers((EObject)propertyToDelete, refs, this.crossReferenceAdapter);
            for (EObject association : associationRefs) {
                ArrayList remainingMembers = new ArrayList();
                remainingMembers.addAll(((Association)association).getMemberEnds());
                if (remainingMembers.size() > 2) continue;
                this.dependentsToRemove.add(association);
            }
            return (Void)super.caseProperty(propertyToDelete);
        }

        public Void caseMessage(Message messageToDelete) {
            MessageEnd receiveEvent;
            MessageEnd sendEvent = messageToDelete.getSendEvent();
            if (sendEvent != null && !this.isSharedEvent(sendEvent, messageToDelete)) {
                this.dependentsToRemove.add((EObject)sendEvent);
            }
            if ((receiveEvent = messageToDelete.getReceiveEvent()) != null && !this.isSharedEvent(receiveEvent, messageToDelete)) {
                this.dependentsToRemove.add((EObject)receiveEvent);
            }
            return (Void)super.caseMessage(messageToDelete);
        }

        public Void caseElement(Element object) {
            object.getStereotypeApplications().stream().filter(EObject.class::isInstance).map(EObject.class::cast).forEach(this.dependentsToRemove::add);
            return (Void)super.caseElement(object);
        }

        private boolean isSharedEvent(MessageEnd messageEnd, Message knownReferencer) {
            EPackage mmPackage = messageEnd.eClass().getEPackage();
            HashSet<EObject> crossReferences = new HashSet<EObject>();
            for (EStructuralFeature.Setting setting : this.crossReferenceAdapter.getInverseReferences((EObject)messageEnd)) {
                EObject eObject = setting.getEObject();
                if (setting.getEStructuralFeature().equals(UMLPackage.eINSTANCE.getLifeline_CoveredBy()) || !eObject.eClass().getEPackage().equals(mmPackage)) continue;
                crossReferences.add(eObject);
            }
            crossReferences.remove(messageEnd.eContainer());
            crossReferences.remove(knownReferencer);
            return !crossReferences.isEmpty();
        }

        public Void caseClassifier(Classifier classifierToDelete) {
            this.dependentsToRemove.addAll((Collection<EObject>)classifierToDelete.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getGeneralization()));
            this.dependentsToRemove.addAll((Collection<EObject>)classifierToDelete.getTargetDirectedRelationships(UMLPackage.eINSTANCE.getGeneralization()));
            for (Association association : classifierToDelete.getAssociations()) {
                for (Property end : association.getMemberEnds()) {
                    if (end.getType() != classifierToDelete) continue;
                    this.dependentsToRemove.add((EObject)association);
                }
            }
            return (Void)super.caseClassifier(classifierToDelete);
        }

        public Void casePackage(Package object) {
            this.crossReferenceAdapter.getInverseReferences((EObject)object, true).stream().filter(s -> s.getEStructuralFeature() == UMLPackage.eINSTANCE.getPackageImport_ImportedPackage() || s.getEStructuralFeature() == UMLPackage.eINSTANCE.getPackageMerge_MergedPackage()).map(s -> s.getEObject()).forEach(this.dependentsToRemove::add);
            return (Void)super.casePackage(object);
        }

        public Void caseCollaboration(Collaboration collaborationToDelete) {
            this.dependentsToRemove.addAll(CollaborationHelper.getRelatedRoleBindings(collaborationToDelete, null, this.crossReferenceAdapter));
            return (Void)super.caseCollaboration(collaborationToDelete);
        }

        public Void caseDestructionOccurrenceSpecification(DestructionOccurrenceSpecification destructionToDelete) {
            Interaction interaction = OccurrenceSpecificationHelper.getInteraction((Element)destructionToDelete);
            Stream<TimeConstraint> timeConstraints = OccurrenceSpecificationHelper.getTimeConstraints(interaction, (Element)destructionToDelete);
            Stream<TimeObservation> timeObservations = OccurrenceSpecificationHelper.getTimeObservations(interaction, (Element)destructionToDelete);
            this.dependentsToRemove.addAll(Stream.concat(timeConstraints, timeObservations).collect(Collectors.toList()));
            return (Void)super.caseDestructionOccurrenceSpecification(destructionToDelete);
        }

        public Void caseExecutionSpecification(ExecutionSpecification esToDelete) {
            OccurrenceSpecification osFinish;
            OccurrenceSpecification osStart = esToDelete.getStart();
            if (OccurrenceSpecificationHelper.shouldDestroyOccurrenceSpecification(esToDelete, osStart, this.crossReferenceAdapter) && !(osStart instanceof MessageEnd)) {
                this.dependentsToRemove.add((EObject)osStart);
            }
            if (OccurrenceSpecificationHelper.shouldDestroyOccurrenceSpecification(esToDelete, osFinish = esToDelete.getFinish(), this.crossReferenceAdapter) && !(osFinish instanceof MessageEnd)) {
                this.dependentsToRemove.add((EObject)osFinish);
            }
            return (Void)super.caseExecutionSpecification(esToDelete);
        }

        public Void caseLifeline(Lifeline lifelineToDelete) {
            for (InteractionFragment ift : lifelineToDelete.getCoveredBys()) {
                if (ift instanceof ExecutionSpecification) {
                    this.dependentsToRemove.add((EObject)ift);
                }
                if (ift instanceof MessageOccurrenceSpecification && ((MessageOccurrenceSpecification)ift).getMessage() != null) {
                    this.dependentsToRemove.add((EObject)((MessageOccurrenceSpecification)ift).getMessage());
                }
                if (!(ift instanceof OccurrenceSpecification)) continue;
                this.dependentsToRemove.add((EObject)ift);
            }
            PartDecomposition decomposition = lifelineToDelete.getDecomposedAs();
            if (decomposition != null && UMLService.isOnlyUsage((EObject)decomposition, (EObject)lifelineToDelete, this.crossReferenceAdapter)) {
                this.dependentsToRemove.add((EObject)decomposition);
            }
            return (Void)super.caseLifeline(lifelineToDelete);
        }

        public Void caseOccurrenceSpecification(OccurrenceSpecification osToDelete) {
            InteractionFragment containerPackage = (InteractionFragment)osToDelete.getOwner();
            if (containerPackage != null) {
                TreeIterator contentIterator = containerPackage.eAllContents();
                while (contentIterator.hasNext()) {
                    EObject currentEObject = (EObject)contentIterator.next();
                    if (currentEObject instanceof Message) {
                        Message m = (Message)currentEObject;
                        if (osToDelete.equals(m.getSendEvent())) {
                            this.dependentsToRemove.add((EObject)m);
                            if (m.getReceiveEvent() != null) {
                                this.dependentsToRemove.add((EObject)m.getReceiveEvent());
                            }
                        }
                        if (osToDelete.equals(m.getReceiveEvent())) {
                            this.dependentsToRemove.add((EObject)m);
                            if (m.getSendEvent() != null) {
                                this.dependentsToRemove.add((EObject)m.getSendEvent());
                            }
                        }
                    }
                    if (!(currentEObject instanceof ExecutionSpecification)) continue;
                    ExecutionSpecification exec = (ExecutionSpecification)currentEObject;
                    if (osToDelete.equals(exec.getStart())) {
                        this.dependentsToRemove.add((EObject)exec);
                        if (exec.getFinish() != null && !(exec.getFinish() instanceof MessageEnd)) {
                            this.dependentsToRemove.add((EObject)exec.getFinish());
                        }
                    }
                    if (!osToDelete.equals(exec.getFinish())) continue;
                    this.dependentsToRemove.add((EObject)exec);
                    if (exec.getStart() == null || exec.getStart() instanceof MessageEnd) continue;
                    this.dependentsToRemove.add((EObject)exec.getStart());
                }
            }
            this.dependentsToRemove.addAll(TimeObservationHelper.getTimeObservations((NamedElement)osToDelete, this.crossReferenceAdapter));
            this.dependentsToRemove.addAll(TimeConstraintHelper.getTimeConstraintsOn((NamedElement)osToDelete, this.crossReferenceAdapter));
            this.dependentsToRemove.addAll(DurationObservationHelper.getDurationObservationsOn((NamedElement)osToDelete, this.crossReferenceAdapter));
            this.dependentsToRemove.addAll(DurationConstraintHelper.getDurationConstraintsOn((NamedElement)osToDelete, this.crossReferenceAdapter));
            this.dependentsToRemove.addAll((Collection<EObject>)osToDelete.getToBefores());
            this.dependentsToRemove.addAll((Collection<EObject>)osToDelete.getToAfters());
            return (Void)super.caseOccurrenceSpecification(osToDelete);
        }

        public Void caseVertex(Vertex vertex) {
            this.dependentsToRemove.addAll((Collection<EObject>)vertex.getIncomings());
            this.dependentsToRemove.addAll((Collection<EObject>)vertex.getOutgoings());
            return (Void)super.caseVertex(vertex);
        }

        public Void caseAssociation(Association association) {
            EList ownedEnds = association.getOwnedEnds();
            for (Property end : association.getMemberEnds()) {
                if (ownedEnds.contains((Object)end)) {
                    this.dependentsToRemove.add((EObject)end);
                    continue;
                }
                if (end.getType() == null) continue;
                this.dependentsToRemove.add((EObject)end);
            }
            return (Void)super.caseAssociation(association);
        }

        public Void caseUseCase(UseCase useCase) {
            this.dependentsToRemove.addAll((Collection<EObject>)useCase.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getInclude()));
            this.dependentsToRemove.addAll((Collection<EObject>)useCase.getTargetDirectedRelationships(UMLPackage.eINSTANCE.getInclude()));
            this.dependentsToRemove.addAll((Collection<EObject>)useCase.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getExtend()));
            this.dependentsToRemove.addAll((Collection<EObject>)useCase.getTargetDirectedRelationships(UMLPackage.eINSTANCE.getExtend()));
            return (Void)super.caseUseCase(useCase);
        }

        public Set<EObject> getDependentsToRemove() {
            return this.dependentsToRemove;
        }

        public Void caseInteractionOperand(InteractionOperand interactionOperand) {
            CombinedFragment combinedFragment;
            if (interactionOperand.getOwner() instanceof CombinedFragment && (combinedFragment = (CombinedFragment)interactionOperand.getOwner()).getOperands().size() == 1 && combinedFragment.getOperands().contains((Object)interactionOperand)) {
                this.dependentsToRemove.add((EObject)combinedFragment);
            }
            return (Void)super.caseInteractionOperand(interactionOperand);
        }
    }
}

