/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.destroy;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.uml.domain.services.EMFUtils;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.destroy.DestroyerStatus;
import org.eclipse.papyrus.uml.domain.services.destroy.ElementDependencyCollector;
import org.eclipse.papyrus.uml.domain.services.destroy.ElementDestroyerChecker;
import org.eclipse.papyrus.uml.domain.services.destroy.IDestroyer;
import org.eclipse.papyrus.uml.domain.services.destroy.IDestroyerChecker;
import org.eclipse.papyrus.uml.domain.services.destroy.IDestroyerDependencyCollector;
import org.eclipse.papyrus.uml.domain.services.status.State;

public class ElementDestroyer
implements IDestroyer {
    private IDestroyerDependencyCollector dependencyCollector;
    private final ECrossReferenceAdapter crossReferenceAdapter;
    private final IDestroyerChecker destroyerChecker;

    public ElementDestroyer(ECrossReferenceAdapter theCrossReferenceAdapter, IDestroyerChecker destroyerChecker, IDestroyerDependencyCollector dependencyCollector) {
        this.dependencyCollector = dependencyCollector;
        this.crossReferenceAdapter = theCrossReferenceAdapter;
        this.destroyerChecker = destroyerChecker;
    }

    public static ElementDestroyer buildDefault(ECrossReferenceAdapter theCrossReferenceAdapter, IEditableChecker editableChecker) {
        return new ElementDestroyer(theCrossReferenceAdapter, new ElementDestroyerChecker(theCrossReferenceAdapter, editableChecker), new ElementDependencyCollector(theCrossReferenceAdapter));
    }

    @Override
    public DestroyerStatus destroy(EObject semanticElement) {
        if (semanticElement == null) {
            return DestroyerStatus.createFailingStatus("The semantic object to destroy is null", Set.of());
        }
        return this.genericDelete(semanticElement);
    }

    private DestroyerStatus genericDelete(EObject semanticElement) {
        Set<EObject> toDeletes = this.computeElementToDelete(semanticElement);
        DestroyerStatus canDestroyStatus = this.destroyerChecker.canDestroy(toDeletes);
        if (canDestroyStatus.getState().equals((Object)State.DONE)) {
            for (EObject toDelete : toDeletes) {
                this.tearDownIncomingReferences(toDelete);
                this.tearDownOutgoingReferences(toDelete);
                EcoreUtil.remove((EObject)toDelete);
            }
        }
        return canDestroyStatus;
    }

    private Set<EObject> computeElementToDelete(EObject semanticElement) {
        LinkedHashSet<EObject> toDeletes = new LinkedHashSet<EObject>();
        LinkedHashSet<EObject> notComputedDependencies = new LinkedHashSet<EObject>();
        notComputedDependencies.add(semanticElement);
        while (!notComputedDependencies.isEmpty()) {
            Iterator iterator = notComputedDependencies.iterator();
            EObject toAnalyse = (EObject)iterator.next();
            iterator.remove();
            EMFUtils.eAllContentStreamWithSelf(toAnalyse).filter(e -> !toDeletes.contains(e)).forEach(e -> {
                Set<EObject> itemDependencies = this.dependencyCollector.collectDependencies((EObject)e);
                for (EObject o : itemDependencies) {
                    if (toDeletes.contains(o)) continue;
                    notComputedDependencies.add(o);
                }
                toDeletes.add((EObject)e);
            });
        }
        return toDeletes;
    }

    private void tearDownIncomingReferences(EObject destructee) {
        int size;
        Collection inverseReferences;
        if (this.crossReferenceAdapter != null && (inverseReferences = this.crossReferenceAdapter.getInverseReferences(destructee)) != null && (size = inverseReferences.size()) > 0) {
            EStructuralFeature.Setting[] settings = inverseReferences.toArray(new EStructuralFeature.Setting[size]);
            int i = 0;
            while (i < size) {
                EStructuralFeature.Setting setting = settings[i];
                EReference eRef = (EReference)setting.getEStructuralFeature();
                if (eRef.isChangeable() && !eRef.isDerived() && !eRef.isContainment() && !eRef.isContainer()) {
                    EcoreUtil.remove((EObject)setting.getEObject(), (EStructuralFeature)eRef, (Object)destructee);
                }
                ++i;
            }
        }
    }

    private void tearDownOutgoingReferences(EObject destructee) {
        for (EReference reference : destructee.eClass().getEAllReferences()) {
            if (!this.shouldUnset(reference) || !destructee.eIsSet((EStructuralFeature)reference)) continue;
            destructee.eUnset((EStructuralFeature)reference);
        }
    }

    private boolean shouldUnset(EReference reference) {
        return reference.isChangeable() && !reference.isDerived() && !reference.isContainer() && !reference.isContainment() && reference.getEOpposite() == null;
    }
}

