/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels;

import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.labels.IDomainBasedEdgeEndLabelProvider;
import org.eclipse.papyrus.uml.domain.services.labels.INamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.LabelUtils;
import org.eclipse.papyrus.uml.domain.services.labels.domains.DefaultNamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.domains.MultiplicityLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.VisibilityLabelHelper;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDomainBasedEdgeTargetLabelProvider
implements IDomainBasedEdgeEndLabelProvider {
    private INamedElementNameProvider namedElementNameProvider;

    public ElementDomainBasedEdgeTargetLabelProvider(INamedElementNameProvider namedElementNameProvider) {
        this.namedElementNameProvider = namedElementNameProvider;
    }

    public static ElementDomainBasedEdgeTargetLabelProvider buildDefault() {
        return new ElementDomainBasedEdgeTargetLabelProvider(new DefaultNamedElementNameProvider());
    }

    @Override
    public String getLabel(EObject element, EObject semanticTarget) {
        String label = (String)new ElementDomainBasedEdgeSourceLabelProviderSwitch(semanticTarget, this.namedElementNameProvider).doSwitch(element);
        if (label == null) {
            label = "";
        }
        return label;
    }

    public static final class ElementDomainBasedEdgeSourceLabelProviderSwitch
    extends UMLSwitch<String> {
        private static final String DECISION_INPUT_FLOW = "decisionInputFlow";
        private final EObject semanticTarget;
        private MultiplicityLabelHelper multiplicityLabelHelper;
        private VisibilityLabelHelper visibilityLabelHelper;

        public ElementDomainBasedEdgeSourceLabelProviderSwitch(EObject semanticTarget, INamedElementNameProvider namedElementNameProvider) {
            this.semanticTarget = semanticTarget;
            this.multiplicityLabelHelper = new MultiplicityLabelHelper(namedElementNameProvider);
            this.visibilityLabelHelper = new VisibilityLabelHelper();
        }

        public String caseAssociation(Association association) {
            EList memberEnds = association.getMemberEnds();
            if (memberEnds.size() > 0) {
                StringBuilder associationSourceLabel = new StringBuilder();
                Property property = (Property)memberEnds.get(0);
                associationSourceLabel.append(LabelUtils.getNonNullString(this.visibilityLabelHelper.getVisibilityAsSign((NamedElement)property)));
                associationSourceLabel.append(" ");
                associationSourceLabel.append(property.getName());
                associationSourceLabel.append(" ");
                associationSourceLabel.append(this.multiplicityLabelHelper.formatMultiplicityNoBrackets((MultiplicityElement)property, false));
                return associationSourceLabel.toString();
            }
            return (String)super.caseAssociation(association);
        }

        public String caseConnector(Connector connector) {
            EList ends = connector.getEnds();
            if (ends.size() > 1 && this.semanticTarget != null) {
                return ends.stream().skip(1L).filter(e -> e.getRole() == this.semanticTarget).findFirst().map(e -> this.multiplicityLabelHelper.formatMultiplicityNoBrackets((MultiplicityElement)e, false)).orElse("");
            }
            return (String)super.caseConnector(connector);
        }

        public String caseObjectFlow(ObjectFlow objectFlow) {
            boolean isDecisionInputFlow = Optional.ofNullable(objectFlow.getTarget()).filter(DecisionNode.class::isInstance).map(DecisionNode.class::cast).map(DecisionNode::getDecisionInputFlow).filter(decisionInputFlow -> objectFlow.equals(decisionInputFlow)).isPresent();
            if (isDecisionInputFlow) {
                return "\u00abdecisionInputFlow\u00bb";
            }
            return (String)super.caseObjectFlow(objectFlow);
        }
    }
}

