/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels.domains;

import org.eclipse.uml2.uml.OpaqueExpression;

public class OpaqueExpressionLabelHelper {
    public static String getBodyForLanguage(OpaqueExpression opaqueExpression, String language) {
        String body = "";
        if (language == null) {
            if (!opaqueExpression.getBodies().isEmpty()) {
                body = (String)opaqueExpression.getBodies().get(0);
            }
        } else {
            int index = opaqueExpression.getLanguages().indexOf((Object)language);
            if (index != -1 && index < opaqueExpression.getBodies().size()) {
                body = (String)opaqueExpression.getBodies().get(index);
            }
        }
        return body;
    }

    public static void setBodyForLanguage(OpaqueExpression opaqueExpression, String language, String body) {
        OpaqueExpressionLabelHelper.checkAndCorrectLists(opaqueExpression);
        if (!opaqueExpression.getLanguages().contains((Object)language)) {
            opaqueExpression.getLanguages().add((Object)language);
            opaqueExpression.getBodies().add((Object)body);
        } else {
            int index = opaqueExpression.getLanguages().indexOf((Object)language);
            opaqueExpression.getBodies().set(index, (Object)body);
        }
    }

    public static boolean checkAndCorrectLists(OpaqueExpression opaqueExpression) {
        int languageSize;
        int bodySize = opaqueExpression.getBodies().size();
        if (bodySize == (languageSize = opaqueExpression.getLanguages().size())) {
            return true;
        }
        int difference = languageSize - bodySize;
        if (difference > 0) {
            int i = 0;
            while (i < difference) {
                opaqueExpression.getBodies().add((Object)"");
                ++i;
            }
        } else {
            int i = 0;
            while (i < -difference) {
                opaqueExpression.getLanguages().add((Object)"");
                ++i;
            }
        }
        return false;
    }
}

