/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.modify;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.destroy.ElementDestroyer;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.CollaborationHelper;
import org.eclipse.papyrus.uml.domain.services.modify.IFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.modify.ModificationType;
import org.eclipse.papyrus.uml.domain.services.status.Status;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementFeatureModifier
implements IFeatureModifier {
    private static final String CANNOT_EDIT_MSG = "Selected object cannot be edited";
    private final ECrossReferenceAdapter crossRef;
    private final IEditableChecker editableChecker;

    public ElementFeatureModifier(ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        this.crossRef = crossRef;
        this.editableChecker = editableChecker;
    }

    @Override
    public Status setValue(EObject featureOwner, String featureName, Object newValue) {
        if (!this.editableChecker.canEdit(featureOwner)) {
            return Status.createFailingStatus(CANNOT_EDIT_MSG);
        }
        return (Status)new ElementFeatureModifierSwitch(featureName, newValue, ModificationType.SET, this.editableChecker, this.crossRef).doSwitch(featureOwner);
    }

    @Override
    public Status addValue(EObject featureOwner, String featureName, Object newValue) {
        if (!this.editableChecker.canEdit(featureOwner)) {
            return Status.createFailingStatus(CANNOT_EDIT_MSG);
        }
        return (Status)new ElementFeatureModifierSwitch(featureName, newValue, ModificationType.ADD, this.editableChecker, this.crossRef).doSwitch(featureOwner);
    }

    @Override
    public Status removeValue(EObject featureOwner, String featureName, Object newValue) {
        if (!this.editableChecker.canEdit(featureOwner)) {
            return Status.createFailingStatus(CANNOT_EDIT_MSG);
        }
        return (Status)new ElementFeatureModifierSwitch(featureName, newValue, ModificationType.REMOVE, this.editableChecker, this.crossRef).doSwitch(featureOwner);
    }

    static class ElementFeatureModifierSwitch
    extends UMLSwitch<Status> {
        private final String featureName;
        private final Object newValue;
        private final ModificationType operationType;
        private IEditableChecker editableChecker;
        private ECrossReferenceAdapter crossRef;

        ElementFeatureModifierSwitch(String featureName, Object newValue, ModificationType operationType, IEditableChecker editableChecker, ECrossReferenceAdapter crossRef) {
            this.featureName = featureName;
            this.newValue = newValue;
            this.operationType = operationType;
            this.editableChecker = editableChecker;
            this.crossRef = crossRef;
        }

        /*
         * WARNING - void declaration
         */
        public Status caseActivityPartition(ActivityPartition activityPartition) {
            block7: {
                Object object = this.newValue;
                if (!(object instanceof Action)) break block7;
                Action action = (Action)object;
                Action cfr_ignored_0 = (Action)object;
                if (UMLPackage.eINSTANCE.getActivityPartition_Node().getName().equals(this.featureName)) {
                    void action2;
                    EList inputs = action2.getInputs();
                    EList outputs = action2.getOutputs();
                    if (ModificationType.ADD.equals((Object)this.operationType) || ModificationType.SET.equals((Object)this.operationType)) {
                        for (InputPin inputPin : inputs) {
                            inputPin.getInPartitions().add((Object)activityPartition);
                        }
                        for (OutputPin outputPin : outputs) {
                            outputPin.getInPartitions().add((Object)activityPartition);
                        }
                    } else {
                        for (InputPin inputPin : inputs) {
                            inputPin.getInPartitions().remove((Object)activityPartition);
                        }
                        for (OutputPin outputPin : outputs) {
                            outputPin.getInPartitions().remove((Object)activityPartition);
                        }
                    }
                }
            }
            return (Status)super.caseActivityPartition(activityPartition);
        }

        public Status caseComponent(Component object) {
            if (this.newValue instanceof Component && UMLPackage.eINSTANCE.getClass_NestedClassifier().getName().equals(this.featureName)) {
                return Status.createFailingStatus("Cannot create a Component under another Component using the " + this.featureName + " feature.");
            }
            return (Status)super.caseComponent(object);
        }

        public Status caseProperty(Property object) {
            this.setNoneLiteralToMemberEndsAggregation(object);
            boolean isNullTypeSet = this.deleteAssociationWithNullType(object);
            this.deleteConnectorEndPartWithRole(object);
            if (!isNullTypeSet) {
                return (Status)super.caseProperty(object);
            }
            return Status.DONE;
        }

        private void setNoneLiteralToMemberEndsAggregation(Property property) {
            Association association;
            if (UMLPackage.eINSTANCE.getProperty_Aggregation().getName().equals(this.featureName) && !(property instanceof Port) && this.newValue != AggregationKind.NONE_LITERAL && (association = property.getAssociation()) != null) {
                HashSet members = new HashSet();
                members.addAll(association.getMemberEnds());
                members.remove(property);
                ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
                for (Property member : members) {
                    if (member.getAggregation() == AggregationKind.NONE_LITERAL) continue;
                    modifier.setValue((EObject)member, UMLPackage.eINSTANCE.getProperty_Aggregation().getName(), AggregationKind.NONE_LITERAL);
                }
            }
        }

        private boolean deleteAssociationWithNullType(Property property) {
            boolean isNullTypeSet = false;
            if (UMLPackage.eINSTANCE.getTypedElement_Type().getName().equals(this.featureName) && !(property instanceof Port) && this.newValue == null) {
                List associationRefs = this.crossRef.getInverseReferences((EObject)property, UMLPackage.eINSTANCE.getAssociation_MemberEnd(), true).stream().map(s -> (Association)s.getEObject()).collect(Collectors.toList());
                property.eSet((EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), this.newValue);
                isNullTypeSet = true;
                ElementDestroyer deleter = ElementDestroyer.buildDefault(this.crossRef, this.editableChecker);
                for (Association association : associationRefs) {
                    if (association.getMembers().size() > 2) continue;
                    deleter.destroy((EObject)association);
                }
            }
            return isNullTypeSet;
        }

        private void deleteConnectorEndPartWithRole(Property property) {
            if (UMLPackage.eINSTANCE.getTypedElement_Type().getName().equals(this.featureName) && !(property instanceof Port)) {
                List connectorEnds = this.crossRef.getInverseReferences((EObject)property, UMLPackage.eINSTANCE.getConnectorEnd_PartWithPort(), true).stream().map(s -> (ConnectorEnd)s.getEObject()).collect(Collectors.toList());
                ElementDestroyer deleter = ElementDestroyer.buildDefault(this.crossRef, this.editableChecker);
                Object validProperties = new ArrayList();
                if (this.newValue instanceof StructuredClassifier) {
                    StructuredClassifier strucClassifier = (StructuredClassifier)this.newValue;
                    validProperties = strucClassifier.allAttributes();
                } else {
                    validProperties = this.newValue instanceof DataType ? ((DataType)this.newValue).allAttributes() : List.of();
                }
                for (ConnectorEnd connectorEnd : connectorEnds) {
                    if (connectorEnd.getRole() != null && validProperties.contains(connectorEnd.getRole())) continue;
                    deleter.destroy((EObject)connectorEnd);
                }
            }
        }

        public Status caseCollaboration(Collaboration collaboration) {
            if (UMLPackage.eINSTANCE.getCollaboration_CollaborationRole().getName().equals(this.featureName) && ModificationType.REMOVE.equals((Object)this.operationType) && this.newValue instanceof ConnectableElement) {
                Set<Dependency> relatedRoleBindings = CollaborationHelper.getRelatedRoleBindings(collaboration, (ConnectableElement)this.newValue, this.crossRef);
                ElementDestroyer deleter = ElementDestroyer.buildDefault(this.crossRef, this.editableChecker);
                for (Dependency roleBinding : relatedRoleBindings) {
                    deleter.destroy((EObject)roleBinding);
                }
            }
            return (Status)super.caseCollaboration(collaboration);
        }

        public Status caseCollaborationUse(CollaborationUse collaborationUse) {
            if (UMLPackage.eINSTANCE.getCollaborationUse_Type().getName().equals(this.featureName) && collaborationUse.getType() != this.newValue && (this.newValue instanceof Collaboration || this.newValue == null)) {
                ArrayList roleBindings = new ArrayList(collaborationUse.getRoleBindings());
                ElementDestroyer deleter = ElementDestroyer.buildDefault(this.crossRef, this.editableChecker);
                for (Dependency roleBinding : roleBindings) {
                    deleter.destroy((EObject)roleBinding);
                }
            }
            return (Status)super.caseCollaborationUse(collaborationUse);
        }

        public Status caseCombinedFragment(CombinedFragment combinedFragment) {
            if (UMLPackage.eINSTANCE.getCombinedFragment_Operand().getName().equals(this.featureName) && this.newValue instanceof InteractionOperand && ModificationType.REMOVE.equals((Object)this.operationType) && combinedFragment.getOperands().size() == 1 && combinedFragment.getOperands().get(0) == this.newValue) {
                ElementDestroyer deleter = ElementDestroyer.buildDefault(this.crossRef, this.editableChecker);
                deleter.destroy((EObject)((InteractionOperand)this.newValue));
            }
            return (Status)super.caseCombinedFragment(combinedFragment);
        }

        public Status caseInteractionOperand(InteractionOperand interactionOperand) {
            if (UMLPackage.eINSTANCE.getInteractionOperand_Fragment().getName().equals(this.featureName) && this.newValue instanceof InteractionOperand && interactionOperand.getOwner() instanceof CombinedFragment) {
                CombinedFragment combinedFragment = (CombinedFragment)interactionOperand.getOwner();
                ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
                return modifier.addValue((EObject)combinedFragment, UMLPackage.eINSTANCE.getCombinedFragment_Operand().getName(), this.newValue);
            }
            return (Status)super.caseInteractionOperand(interactionOperand);
        }

        public Status defaultCase(EObject object) {
            Status result;
            EClass eClass = object.eClass();
            EStructuralFeature feature = eClass.getEStructuralFeature(this.featureName);
            if (feature == null) {
                result = Status.createFailingStatus(MessageFormat.format("Unkown feature {0} on {1}", this.featureName, eClass.getName()));
            } else if (feature.isDerived() || !feature.isChangeable()) {
                result = Status.createFailingStatus(MessageFormat.format("{0} can''t be modified on the selected element.", this.featureName));
            } else {
                if (this.newValue != null && !feature.getEType().isInstance(this.newValue)) {
                    return Status.createFailingStatus("Invalid value type for reference " + this.featureName + " object " + String.valueOf(this.newValue));
                }
                result = this.genericSet(object, feature, this.newValue);
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private Status genericSet(EObject owner, EStructuralFeature feature, Object newValueToSet) {
            Status status = Status.DONE;
            switch (this.operationType) {
                case ADD: {
                    if (feature.isMany()) {
                        ((List)owner.eGet(feature)).add(newValueToSet);
                        break;
                    }
                    EStructuralFeature eStructuralFeature = feature;
                    if (eStructuralFeature instanceof EReference) {
                        void ref;
                        EReference eReference = (EReference)eStructuralFeature;
                        EReference cfr_ignored_0 = (EReference)eStructuralFeature;
                        if (ref.isContainment() && owner.eGet(feature) != null) {
                            status = Status.createFailingStatus("Unable to add the element in '" + this.featureName + "' feature. It is already filled with an element and can only contain one.");
                            break;
                        }
                    }
                    owner.eSet(feature, newValueToSet);
                    break;
                }
                case REMOVE: {
                    if (feature.isMany()) {
                        ((List)owner.eGet(feature)).remove(newValueToSet);
                        break;
                    }
                    status = Status.createFailingStatus("Unable to remove a value from an unary feature :" + this.featureName);
                    break;
                }
                case SET: {
                    if (feature.isMany()) {
                        List currentValue = (List)owner.eGet(feature);
                        currentValue.clear();
                        currentValue.add(newValueToSet);
                        break;
                    }
                    owner.eSet(feature, newValueToSet);
                    break;
                }
            }
            return status;
        }
    }
}

