/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class EMFUtils {
    public static String buildQualifiedName(EClass eClass) {
        return eClass.getEPackage().getName() + "::" + eClass.getName();
    }

    public static <T extends EObject> T getAncestor(Class<T> type, EObject object) {
        if (object == null) {
            return null;
        }
        Object result = type.isInstance(object) ? object : EMFUtils.getAncestor(type, object.eContainer());
        return (T)result;
    }

    public static <T extends EObject> List<T> getAncestors(Class<T> type, EObject object, Predicate<EObject> ancestorPredicate) {
        EObject current = object;
        ArrayList<EObject> results = new ArrayList<EObject>();
        while (current != null) {
            if (type.isInstance(current) && (ancestorPredicate == null || ancestorPredicate.test(current))) {
                results.add(current);
            }
            current = current.eContainer();
        }
        return results;
    }

    public static <T extends EObject> List<T> getAncestors(Class<T> type, EObject object) {
        return EMFUtils.getAncestors(type, object, null);
    }

    public static Stream<EObject> eAllContentStreamWithSelf(EObject o) {
        if (o == null) {
            return Stream.empty();
        }
        return Stream.concat(Stream.of(o), StreamSupport.stream(Spliterators.spliteratorUnknownSize(o.eAllContents(), 256), false));
    }

    public static Stream<Notifier> eAllContentSteamWithSelf(Resource r) {
        if (r == null) {
            return Stream.empty();
        }
        return Stream.concat(Stream.of(r), StreamSupport.stream(Spliterators.spliteratorUnknownSize(r.getAllContents(), 256), false));
    }

    /*
     * WARNING - void declaration
     */
    public static Stream<Notifier> eAllContentSteamWithSelf(Notifier n) {
        Stream<Notifier> result = Stream.empty();
        Notifier notifier = n;
        if (notifier instanceof Resource) {
            void resource;
            Resource resource2 = (Resource)notifier;
            Resource cfr_ignored_0 = (Resource)notifier;
            result = EMFUtils.eAllContentSteamWithSelf((Resource)resource);
        } else {
            Notifier notifier2 = n;
            if (notifier2 instanceof EObject) {
                void eObject;
                EObject eObject2 = (EObject)notifier2;
                EObject cfr_ignored_1 = (EObject)notifier2;
                result = EMFUtils.eAllContentStreamWithSelf((EObject)eObject).map(Notifier.class::cast);
            } else {
                Notifier notifier3 = n;
                if (notifier3 instanceof ResourceSet) {
                    void resourceSet;
                    ResourceSet resourceSet2 = (ResourceSet)notifier3;
                    ResourceSet cfr_ignored_2 = (ResourceSet)notifier3;
                    result = EMFUtils.eAllContentSteamWithSelf((ResourceSet)resourceSet);
                }
            }
        }
        return result;
    }

    public static Stream<Notifier> eAllContentSteamWithSelf(ResourceSet rs) {
        if (rs == null) {
            return Stream.empty();
        }
        return Stream.concat(Stream.of(rs), StreamSupport.stream(Spliterators.spliteratorUnknownSize(rs.getAllContents(), 256), false));
    }

    public static <T extends EObject> Stream<T> allContainedObjectOfType(Notifier self, Class<T> type) {
        Stream<Object> result = self instanceof EObject ? EMFUtils.eAllContentStreamWithSelf((EObject)self).filter(e -> type.isInstance(e)).map(e -> (EObject)type.cast(e)) : (self instanceof Resource ? EMFUtils.eAllContentSteamWithSelf((Resource)self).filter(e -> type.isInstance(e)).map(e -> (EObject)type.cast(e)) : (self instanceof ResourceSet ? EMFUtils.eAllContentSteamWithSelf((ResourceSet)self).filter(e -> type.isInstance(e)).map(e -> (EObject)type.cast(e)) : Stream.empty()));
        return result;
    }

    public static <T extends EObject> T getLeastCommonContainer(Class<T> expectedType, EObject e1, EObject e2) {
        List e1Ancestors = EMFUtils.getAncestors(expectedType, e1);
        List<T> e2CommonAncestors = EMFUtils.getAncestors(expectedType, e2, container -> e1Ancestors.contains(container));
        if (e2CommonAncestors.isEmpty()) {
            return null;
        }
        return (T)((EObject)e2CommonAncestors.get(0));
    }
}

