/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.papyrus.uml.domain.services.status.Status;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class StateMachineInternalSourceTorepresentationDropBehaviorProvider
implements IInternalSourceToRepresentationDropBehaviorProvider {
    @Override
    public Status drop(EObject droppedElement, EObject oldContainer, EObject newContainer, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        return (Status)new StateMachineDropOutsideRepresentationBehaviorProviderSwitch(oldContainer, newContainer, crossRef, editableChecker).doSwitch(droppedElement);
    }

    static class StateMachineDropOutsideRepresentationBehaviorProviderSwitch
    extends UMLSwitch<Status> {
        private final EObject oldContainer;
        private final EObject newContainer;
        private final ECrossReferenceAdapter crossRef;
        private final IEditableChecker editableChecker;

        StateMachineDropOutsideRepresentationBehaviorProviderSwitch(EObject oldContainer, EObject newContainer, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
            this.oldContainer = oldContainer;
            this.newContainer = newContainer;
            this.crossRef = crossRef;
            this.editableChecker = editableChecker;
        }

        public Status caseElement(Element droppedElement) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                String refName = droppedElement.eContainmentFeature().getName();
                if (this.oldContainer.eClass().getEStructuralFeature(refName) != null && this.newContainer.eClass().getEStructuralFeature(refName) != null) {
                    Status dropStatus = modifier.removeValue(this.oldContainer, refName, droppedElement);
                    if (State.DONE == dropStatus.getState()) {
                        dropStatus = modifier.addValue(this.newContainer, refName, droppedElement);
                    }
                    return dropStatus;
                }
            }
            return (Status)super.caseElement(droppedElement);
        }
    }
}

