/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.internal.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.edges.ElementDomainBasedEdgeSourceProvider;
import org.eclipse.papyrus.uml.domain.services.edges.ElementDomainBasedEdgeTargetsProvider;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.StructuredActivityNode;

public class ActivityEdgeHelper {
    public Element deduceContainer(EObject source, EObject target) {
        Activity container = null;
        EObject element = source;
        while (element != null && container == null) {
            if (element instanceof Activity) {
                container = (Activity)element;
            } else if (element instanceof StructuredActivityNode && ((StructuredActivityNode)element).allOwnedElements().contains((Object)target)) {
                container = (StructuredActivityNode)element;
            }
            element = element.eContainer();
        }
        return container;
    }

    public void setInPartition(ActivityEdge activityEdge) {
        ActivityNode source = activityEdge.getSource();
        ActivityNode target = activityEdge.getTarget();
        if (source != null && target != null) {
            ArrayList partitions = new ArrayList(source.getInPartitions());
            partitions.retainAll((Collection<?>)target.getInPartitions());
            if (!activityEdge.getInPartitions().isEmpty()) {
                activityEdge.getInPartitions().clear();
            }
            activityEdge.getInPartitions().addAll(partitions);
        }
    }

    public Set<ActivityEdge> getAllActivityEdgesFromActivityNode(ActivityNode activityNode) {
        HashSet<ActivityEdge> allEdges = new HashSet<ActivityEdge>((Collection<ActivityEdge>)activityNode.getIncomings());
        allEdges.addAll((Collection<ActivityEdge>)activityNode.getOutgoings());
        allEdges.addAll(this.getActivityEdgeFromPin(activityNode));
        return allEdges;
    }

    public void updateActivityEdgeContainer(ActivityEdge activityEdge) {
        EObject target;
        Element newActivityEdgeContainer;
        ElementDomainBasedEdgeSourceProvider sourceProvider = new ElementDomainBasedEdgeSourceProvider();
        ElementDomainBasedEdgeTargetsProvider targetsProvider = new ElementDomainBasedEdgeTargetsProvider();
        EObject source = sourceProvider.getSource((EObject)activityEdge);
        Optional optTarget = targetsProvider.getTargets((EObject)activityEdge).stream().findFirst();
        if (optTarget.isPresent() && (newActivityEdgeContainer = this.deduceContainer(source, target = (EObject)optTarget.get())) != activityEdge.getOwner()) {
            if (newActivityEdgeContainer instanceof Activity) {
                Activity activityContainer = (Activity)newActivityEdgeContainer;
                activityContainer.getEdges().add((Object)activityEdge);
            } else if (newActivityEdgeContainer instanceof StructuredActivityNode) {
                StructuredActivityNode structuredActivityNode = (StructuredActivityNode)newActivityEdgeContainer;
                structuredActivityNode.getEdges().add((Object)activityEdge);
            }
        }
    }

    private Set<ActivityEdge> getActivityEdgeFromPin(ActivityNode activityNode) {
        HashSet<ActivityEdge> edgesFromPins = new HashSet<ActivityEdge>();
        if (activityNode instanceof Action) {
            Action action = (Action)activityNode;
            EList potentialEdgeSources = action.getOutputs();
            EList potentialEdgeTargets = action.getInputs();
            for (OutputPin outputPin : potentialEdgeSources) {
                edgesFromPins.addAll((Collection<ActivityEdge>)outputPin.getIncomings());
                edgesFromPins.addAll((Collection<ActivityEdge>)outputPin.getOutgoings());
            }
            for (InputPin inputPin : potentialEdgeTargets) {
                edgesFromPins.addAll((Collection<ActivityEdge>)inputPin.getIncomings());
                edgesFromPins.addAll((Collection<ActivityEdge>)inputPin.getOutgoings());
            }
        }
        return edgesFromPins;
    }
}

